/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap.stringparsers;

import com.martiansoftware.jsap.ParseException;
import com.martiansoftware.jsap.StringParser;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LongSizeStringParser
extends StringParser {
    private static final Pattern PARSE_SIZE_REGEX = Pattern.compile("((#|0x|0X)?[0-9A-Fa-f]+)([KMGTP]i?)?");
    private static final BigInteger LONG_MAX_VALUE = new BigInteger(Long.toString(Long.MAX_VALUE));
    private static final HashMap UNIT2SIZE = new HashMap();
    static final LongSizeStringParser INSTANCE = new LongSizeStringParser();

    private LongSizeStringParser() {
    }

    public static LongSizeStringParser getParser() {
        return INSTANCE;
    }

    @Override
    public Object parse(String arg) throws ParseException {
        return new Long(LongSizeStringParser.parseSize(arg));
    }

    public static long parseSize(CharSequence s) throws ParseException {
        Long size;
        Matcher m = PARSE_SIZE_REGEX.matcher(s);
        if (!m.matches()) {
            throw new ParseException("Invalid size specification '" + s + "'.");
        }
        String unit = m.group(3);
        BigInteger unitSize = BigInteger.ONE;
        if (unit != null) {
            Long unitSizeObj = (Long)UNIT2SIZE.get(unit);
            if (unitSizeObj == null) {
                throw new ParseException("Invalid unit specification '" + unit + "'.");
            }
            unitSize = new BigInteger(unitSizeObj.toString());
        }
        String number = m.group(1);
        try {
            size = Long.decode(number);
            if (size < 0L) {
                throw new ParseException("Sizes cannot be negative.");
            }
        }
        catch (NumberFormatException e) {
            throw new ParseException("Invalid number '" + number + "'.");
        }
        BigInteger result = new BigInteger(size.toString()).multiply(unitSize);
        if (result.compareTo(LONG_MAX_VALUE) > 0) {
            throw new ParseException("Size '" + s + "' is too big.");
        }
        return Long.parseLong(result.toString());
    }

    static {
        UNIT2SIZE.put("K", new Long(1000L));
        UNIT2SIZE.put("M", new Long(1000000L));
        UNIT2SIZE.put("G", new Long(1000000000L));
        UNIT2SIZE.put("T", new Long(1000000000000L));
        UNIT2SIZE.put("P", new Long(1000000000000000L));
        UNIT2SIZE.put("Ki", new Long(1024L));
        UNIT2SIZE.put("Mi", new Long(0x100000L));
        UNIT2SIZE.put("Gi", new Long(0x40000000L));
        UNIT2SIZE.put("Ti", new Long(0x10000000000L));
        UNIT2SIZE.put("Pi", new Long(0x4000000000000L));
    }
}

