/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dct;

import edu.emory.mathcs.jtransforms.dct.FloatDCT_1D;
import edu.emory.mathcs.jtransforms.dct.FloatDCT_2D;
import edu.emory.mathcs.jtransforms.dct.FloatDCT_3D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import edu.emory.mathcs.utils.IOUtils;

public class BenchmarkFloatDCT {
    private static int nthread = 2;
    private static int nsize = 6;
    private static int niter = 200;
    private static boolean doWarmup = true;
    private static int initialExponent1D = 17;
    private static int initialExponent2D = 7;
    private static int initialExponent3D = 2;
    private static boolean doScaling = false;

    private BenchmarkFloatDCT() {
    }

    public static void parseArguments(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println("args[" + i + "]:" + stringArray[i]);
        }
        if (stringArray == null || stringArray.length != 10) {
            System.out.println("Parameters: <number of threads> <THREADS_BEGIN_N_2D> <THREADS_BEGIN_N_3D> <number of iterations> <perform warm-up> <perform scaling> <number of sizes> <initial exponent for 1D transforms> <initial exponent for 2D transforms> <initial exponent for 3D transforms>");
            System.exit(-1);
        }
        nthread = Integer.parseInt(stringArray[0]);
        ConcurrencyUtils.setThreadsBeginN_2D(Integer.parseInt(stringArray[1]));
        ConcurrencyUtils.setThreadsBeginN_3D(Integer.parseInt(stringArray[2]));
        niter = Integer.parseInt(stringArray[3]);
        doWarmup = Boolean.parseBoolean(stringArray[4]);
        doScaling = Boolean.parseBoolean(stringArray[5]);
        nsize = Integer.parseInt(stringArray[6]);
        initialExponent1D = Integer.parseInt(stringArray[7]);
        initialExponent2D = Integer.parseInt(stringArray[8]);
        initialExponent3D = Integer.parseInt(stringArray[9]);
        ConcurrencyUtils.setNumberOfProcessors(nthread);
    }

    public static void benchmarkForward_1D(int n) {
        int[] nArray = new int[nsize];
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            int n2;
            int n3 = n + i;
            nArray[i] = n2 = (int)Math.pow(2.0, n3);
            System.out.println("Forward DCT 1D of size 2^" + n3);
            FloatDCT_1D floatDCT_1D = new FloatDCT_1D(n2);
            float[] fArray = new float[n2];
            if (doWarmup) {
                IOUtils.fillMatrix_1D(n2, fArray);
                floatDCT_1D.forward(fArray, doScaling);
                IOUtils.fillMatrix_1D(n2, fArray);
                floatDCT_1D.forward(fArray, doScaling);
            }
            float f = 0.0f;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_1D(n2, fArray);
                l = System.nanoTime();
                floatDCT_1D.forward(fArray, doScaling);
                l = System.nanoTime() - l;
                f += (float)l;
            }
            dArray[i] = (double)f / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", (double)f / 1000000.0 / (double)niter) + " msec");
            fArray = null;
            floatDCT_1D = null;
            System.gc();
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatForwardDCT_1D.txt", nthread, niter, doWarmup, doScaling, nArray, dArray);
    }

    public static void benchmarkForward_2D_input_1D(int n) {
        int[] nArray = new int[nsize];
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            int n2;
            int n3 = n + i;
            nArray[i] = n2 = (int)Math.pow(2.0, n3);
            System.out.println("Forward DCT 2D (input 1D) of size 2^" + n3 + " x 2^" + n3);
            FloatDCT_2D floatDCT_2D = new FloatDCT_2D(n2, n2);
            float[] fArray = new float[n2 * n2];
            if (doWarmup) {
                IOUtils.fillMatrix_2D(n2, n2, fArray);
                floatDCT_2D.forward(fArray, doScaling);
                IOUtils.fillMatrix_2D(n2, n2, fArray);
                floatDCT_2D.forward(fArray, doScaling);
            }
            float f = 0.0f;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_2D(n2, n2, fArray);
                l = System.nanoTime();
                floatDCT_2D.forward(fArray, doScaling);
                l = System.nanoTime() - l;
                f += (float)l;
            }
            dArray[i] = (double)f / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", (double)f / 1000000.0 / (double)niter) + " msec");
            fArray = null;
            floatDCT_2D = null;
            System.gc();
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatForwardDCT_2D_input_1D.txt", nthread, niter, doWarmup, doScaling, nArray, dArray);
    }

    public static void benchmarkForward_2D_input_2D(int n) {
        int[] nArray = new int[nsize];
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            int n2;
            int n3 = n + i;
            nArray[i] = n2 = (int)Math.pow(2.0, n3);
            System.out.println("Forward DCT 2D (input 2D) of size 2^" + n3 + " x 2^" + n3);
            FloatDCT_2D floatDCT_2D = new FloatDCT_2D(n2, n2);
            float[][] fArray = new float[n2][n2];
            if (doWarmup) {
                IOUtils.fillMatrix_2D(n2, n2, fArray);
                floatDCT_2D.forward(fArray, doScaling);
                IOUtils.fillMatrix_2D(n2, n2, fArray);
                floatDCT_2D.forward(fArray, doScaling);
            }
            float f = 0.0f;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_2D(n2, n2, fArray);
                l = System.nanoTime();
                floatDCT_2D.forward(fArray, doScaling);
                l = System.nanoTime() - l;
                f += (float)l;
            }
            dArray[i] = (double)f / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", (double)f / 1000000.0 / (double)niter) + " msec");
            fArray = null;
            floatDCT_2D = null;
            System.gc();
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatForwardDCT_2D_input_2D.txt", nthread, niter, doWarmup, doScaling, nArray, dArray);
    }

    public static void benchmarkForward_3D_input_1D(int n) {
        int[] nArray = new int[nsize];
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            int n2;
            int n3 = n + i;
            nArray[i] = n2 = (int)Math.pow(2.0, n3);
            System.out.println("Forward DCT 3D (input 1D) of size 2^" + n3 + " x 2^" + n3 + " x 2^" + n3);
            FloatDCT_3D floatDCT_3D = new FloatDCT_3D(n2, n2, n2);
            float[] fArray = new float[n2 * n2 * n2];
            if (doWarmup) {
                IOUtils.fillMatrix_3D(n2, n2, n2, fArray);
                floatDCT_3D.forward(fArray, doScaling);
                IOUtils.fillMatrix_3D(n2, n2, n2, fArray);
                floatDCT_3D.forward(fArray, doScaling);
            }
            float f = 0.0f;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_3D(n2, n2, n2, fArray);
                l = System.nanoTime();
                floatDCT_3D.forward(fArray, doScaling);
                l = System.nanoTime() - l;
                f += (float)l;
            }
            dArray[i] = (double)f / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", (double)f / 1000000.0 / (double)niter) + " msec");
            fArray = null;
            floatDCT_3D = null;
            System.gc();
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatForwardDCT_3D_input_1D.txt", nthread, niter, doWarmup, doScaling, nArray, dArray);
    }

    public static void benchmarkForward_3D_input_3D(int n) {
        int[] nArray = new int[nsize];
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            int n2;
            int n3 = n + i;
            nArray[i] = n2 = (int)Math.pow(2.0, n3);
            System.out.println("Forward DCT 3D (input 3D) of size 2^" + n3 + " x 2^" + n3 + " x 2^" + n3);
            FloatDCT_3D floatDCT_3D = new FloatDCT_3D(n2, n2, n2);
            float[][][] fArray = new float[n2][n2][n2];
            if (doWarmup) {
                IOUtils.fillMatrix_3D(n2, n2, n2, fArray);
                floatDCT_3D.forward(fArray, doScaling);
                IOUtils.fillMatrix_3D(n2, n2, n2, fArray);
                floatDCT_3D.forward(fArray, doScaling);
            }
            float f = 0.0f;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_3D(n2, n2, n2, fArray);
                l = System.nanoTime();
                floatDCT_3D.forward(fArray, doScaling);
                l = System.nanoTime() - l;
                f += (float)l;
            }
            dArray[i] = (double)f / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", (double)f / 1000000.0 / (double)niter) + " msec");
            fArray = null;
            floatDCT_3D = null;
            System.gc();
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatForwardDCT_3D_input_3D.txt", nthread, niter, doWarmup, doScaling, nArray, dArray);
    }

    public static void main(String[] stringArray) {
        BenchmarkFloatDCT.parseArguments(stringArray);
        BenchmarkFloatDCT.benchmarkForward_1D(initialExponent1D);
        BenchmarkFloatDCT.benchmarkForward_2D_input_1D(initialExponent2D);
        BenchmarkFloatDCT.benchmarkForward_2D_input_2D(initialExponent2D);
        BenchmarkFloatDCT.benchmarkForward_3D_input_1D(initialExponent3D);
        BenchmarkFloatDCT.benchmarkForward_3D_input_3D(initialExponent3D);
        System.exit(0);
    }
}

