# an awk script to create GMSH geometry and post processing files from
# tochnog dbs files.
# usage :
# gawk -f mkgmsh.awk foo.dbs
# output:  foo.geo  and foo.pos files
# use gmsh to open foo.geo and "merge" foo.pos
# use the post processing controls to turn off all but one of the
# output values (all of the dof_label are processed).
#
# written by Osman Buyukisik  osman@fuse.net
# 
# as of april/8/2000 handles: tria3 tria6 quad4 quad9
# need to add 3d tetra and hex (gmsh only handles tetra)
# $Id: mkgmsh.awk,v 1.1 2000/05/22 18:15:51 roddemandennis Exp $
# $Log: mkgmsh.awk,v $
# Revision 1.1  2000/05/22 18:15:51  roddemandennis
# start
#
# Revision 1.2  2000/04/11 23:12:56  osman
# added 3d support.
#
#
BEGIN {
        ndim=3;enum=1;
      }
{
if ($1=="number_of_space_dimensions") {ndim=$2+0;getline}
if ($1=="dof_label") {
    for (i=2;i<=NF;i++)dof_labels[i-1]=$i;
    n_dofs=NF-1;
                      }
if ($1=="node") {
    node=$2+0; 
    x[node]=$3+0.0;
    if (ndim > 1) y[node]=$4+0.0;
    if (ndim > 2) z[node]=$5+0.0;
                }
if ($1=="element") {
    if ($3=="-tria3") {
    element[enum,1]=$4+0;
    element[enum,2]=$5+0;
    element[enum,3]=$6+0;
    enum+=1;
                     };
    if ($3=="-tria6"){
    element[enum,1]=$4+0;element[enum,2]=$5+0;element[enum,3]=$7+0;enum+=1;
    element[enum,1]=$5+0;element[enum,2]=$6+0;element[enum,3]=$8+0;enum+=1;
    element[enum,1]=$5+0;element[enum,2]=$8+0;element[enum,3]=$7+0;enum+=1;
    element[enum,1]=$7+0;element[enum,2]=$8+0;element[enum,3]=$9+0;enum+=1;
                    };
    if ($3=="-quad4"){
    element[enum,1]=$4+0;element[enum,2]=$5+0;element[enum,3]=$7+0;enum+=1;
    element[enum,1]=$4+0;element[enum,2]=$7+0;element[enum,3]=$6+0;enum+=1;
                    };
    if ($3=="-quad9"){
    element[enum,1]=$4+0;element[enum,2]=$5+0;element[enum,3]=$8+0;enum+=1;
    element[enum,1]=$4+0;element[enum,2]=$8+0;element[enum,3]=$7+0;enum+=1;
    element[enum,1]=$5+0;element[enum,2]=$6+0;element[enum,3]=$8+0;enum+=1;
    element[enum,1]=$6+0;element[enum,2]=$9+0;element[enum,3]=$8+0;enum+=1;
    element[enum,1]=$7+0;element[enum,2]=$8+0;element[enum,3]=$10+0;enum+=1;
    element[enum,1]=$8+0;element[enum,2]=$11+0;element[enum,3]=$10+0;enum+=1;
    element[enum,1]=$8+0;element[enum,2]=$9+0;element[enum,3]=$12+0;enum+=1;
    element[enum,1]=$8+0;element[enum,2]=$12+0;element[enum,3]=$11+0;enum+=1;
                    };
    if ($3=="-tet4"){
    element[enum,1]=$4+0;element[enum,2]=$5+0;element[enum,3]=$6+0;
    element[enum,4]=$7+0;enum+=1;
                    };
    if ($3=="-hex8"){
    element[enum,1]=$4+0;element[enum,2]=$5+0;element[enum,3]=$6+0;element[enum,4]=$8+0;enum+=1;
    element[enum,1]=$5+0;element[enum,2]=$7+0;element[enum,3]=$6+0;element[enum,4]=$11+0;enum+=1;
    element[enum,1]=$5+0;element[enum,2]=$11+0;element[enum,3]=$8+0;element[enum,4]=$9+0;enum+=1;
    element[enum,1]=$6+0;element[enum,2]=$11+0;element[enum,3]=$8+0;element[enum,4]=$10+0;enum+=1;
    element[enum,1]=$5+0;element[enum,2]=$6+0;element[enum,3]=$8+0;element[enum,4]=$11+0;enum+=1;
                    };
    }
if ($1=="node_dof") {
    node=$2+0;
    for (j=3;j<=NF;j++)values[node,j-2]=$j;
                    }
}
END {
  printf("// %d elements written.\n",enum-1) > "foo.pos";
  for (j=1;j<=n_dofs;j++) {
       printf("View \"%s\" {\n",dof_labels[j]) >> "foo.pos"; 
       for (e=1;e<enum;e++) {
         k=element[e,1];l=element[e,2];m=element[e,3];if(ndim==3)n=element[e,4];
         if (ndim==2)printf("ST(%f,%f,0.0,%f,%f,0.0,%f,%f,0.0) {%f,%f,%f};\n",
                             x[k],y[k],x[l],y[l],x[m],y[m],
                             values[k,j],values[l,j],values[m,j])>>"foo.pos";
         if (ndim==3)printf("SS(%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f) {%f,%f,%f,%f};\n",
             x[k],y[k],z[k],x[l],y[l],z[l],x[m],y[m],z[m],x[n],y[n],z[n],
             values[k,j],values[l,j],values[m,j],values[n,j])>>"foo.pos";
                        }
       printf("};\n")>>"foo.pos";
                           }
  printf("// for element plots\n") > "foo.geo";
  line_num=0;
  if (ndim==3) {
     for (k in x){printf("Point(%d)={%f,%f,%f,1};\n",k,x[k],y[k],z[k])>>"foo.geo"; line_num+=1;}
                  }
  else {
     for (k in x){printf("Point(%d)={%f,%f,0.0,1};\n",k,x[k],y[k],z[k])>>"foo.geo"; line_num+=1;}
         }
  for (e=1;e<enum;e++) {
   if(ndim==2){printf("Line(%d)={%d,%d,%d,%d};\n",line_num,element[e,1],
                                                 element[e,2],element[e,3],
                                                 element[e,1])>>"foo.geo";
               line_num+=1; 
               }
   if(ndim==3) {
     printf("Line(%d)={%d,%d};\n",line_num+0,element[e,1],element[e,2])>>"foo.geo";
     printf("Line(%d)={%d,%d};\n",line_num+1,element[e,2],element[e,3])>>"foo.geo";
     printf("Line(%d)={%d,%d};\n",line_num+2,element[e,3],element[e,1])>>"foo.geo";
     printf("Line(%d)={%d,%d};\n",line_num+3,element[e,3],element[e,4])>>"foo.geo";
     printf("Line(%d)={%d,%d};\n",line_num+4,element[e,2],element[e,4])>>"foo.geo";
     printf("Line(%d)={%d,%d};\n",line_num+5,element[e,1],element[e,4])>>"foo.geo";
#     printf("Line Loop(%d)={%d,%d,%d};\n",line_num+6,line_num+0,line_num+1,line_num+2)>>"foo.geo";
#     printf("Plane Surface(%d)={%d};\n",line_num+7,line_num+6)>>"foo.geo";
#     printf("Line Loop(%d)={%d,%d,-%d};\n",line_num+8,line_num+1,line_num+3,line_num+4)>>"foo.geo";
#     printf("Plane Surface(%d)={%d};\n",line_num+9,line_num+8)>>"foo.geo";
#     printf("Line Loop(%d)={%d,%d,-%d};\n",line_num+10,line_num,line_num+4,line_num+5)>>"foo.geo";
#     printf("Plane Surface(%d)={%d};\n",line_num+11,line_num+10)>>"foo.geo";
#     printf("Line Loop(%d)={%d,%d,-%d};\n",line_num+12,line_num+2,line_num+5,line_num+3)>>"foo.geo";
#     printf("Plane Surface(%d)={%d};\n",line_num+13,line_num+12)>>"foo.geo";
     line_num+=14;
                  }
                          }
   }
