.\"$Header: /home/vikas/src/nocol/doc/RCS/nsmon.8,v 1.6 1998/07/31 18:04:46 vikas Exp $"
.\"
.TH NSMON 8 "May 1994"
.SH NAME
nsmon \- Nameserver monitor
.SH SYNOPSIS
.B nsmon
[
.B \-d
] [
.B \-o
.I output-file
]
.I config-file
.SH DESCRIPTION
.LP
.B nsmon
is part of the NOCOL network monitoring package, used for
testing the nameserver status 
.RI ( named
) for a list of hosts.

The program reads in a list of sites to test from a config file at startup
and then does a nameserver query from the hosts periodically. If the server
does not resolve the query, the
.I named
process is assumed to be down or unavailable and the site is raised to
CRITICAL state (escalated in each pass).

The query type is SOA. Other resolver options set in the query are 
RES_RECURSE off (no recursion), RES_DNSRCH off (parent, etc not searched).
By default, RES_AAONLY is false, hence non-authoritative answers are
accepted. However, the hostname can have the AUTH keyword in the config
file to accept authoritative answers only. 
Note however, that the DNS server may choose to ignore any of these options. 

The servers are queried every POLLINTERVAL (default 60) seconds.

This program can watch multiple domains on multiple dns name servers.
Each DOMAINNAME keyword, starts a new set of hosts to query for that domain.

.\"
.SH OPTIONS
.TP 16
.B \-d
selects verbose debugging output mode
.TP
.BI "\-o" " output file"
Name of the file to which to write the output.  This file is 
.I not
in human-readable format, and is intended to be processed by the 
.BR nocol (1)
display program.
.TP
.I config-file
This file lists the hosts to be queried for the nameserver.
The format of this file is:
.RS
.sp
.nf
POLLINTERVAL    secs
DOMAINNAME      name-string
<SiteName>   <IPaddress>
<SiteName>   <IPaddress>  AUTH
#
DOMAINNAME	name-string
<SiteName>   <IPaddress> AUTH
.fi
.RE
.sp
.IP
The 
.I sitename
is only for the operator's benefit and thus does not have to be a full
internet name. The second column is the site's IP address.
.\"------------------------------------
.SH AUTHOR
This program is part of the NOCOL monitoring package.
Contact
.I vikas@navya.com
.SH CAVEATS
The program uses the
.I res_mkquery()
system call for querying the nameserver.
Unfortunately, discrepancies in the data structures exist between vendors, so
slight modifications to the source might be necessary on some systems.

The nameserver queried can choose to ignore the various flags (like
NORECURSIVE, AAONLY) that the client sets in the query.
.SH SEE ALSO
netconsole(1) nocol-prog(3) perlnocol(3)
eventselect(8) genmon(8) noclogd(8) nocol-overview(8)
nocol-utility(8) nsmon(8) pingmon(8) portmon(8) 
tpmon(8) trapmon(8)

