/*
* MyGoGrinder - a program to practice Go problems
* Copyright (c) 2004-2007 Tim Kington
*   timkington@users.sourceforge.net
* Portions Copyright (C) Ruediger Klehn (2015)
*   RuediRf@users.sourceforge.net
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/

package GoGrinder;

import java.io.*;
import java.awt.*;
import java.net.*; // URL, URI
import java.util.*;
import java.applet.*;
import javax.swing.*;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.security.CodeSource;
import java.security.ProtectionDomain;

import GoGrinder.ui.SplashScreen;

import com.Ostermiller.util.Browser;

import GoGrinder.ui.*;
import GoGrinder.sgf.Validator;
import GoGrinder.sgf.SGFLog;
import GoGrinder.tests.StringChecker;

/**
 * @author  tkington
 * @author  Ruediger Klehn
 */
public class Main {
    
    public static final String DOCP_FROM_ENV = SysVar.get("MYGG_DOCPATH", 3); 
    // docpath: usually in the program's docs subfolder, can be changed to e.g. /usr/share/doc/MyGoGrinder/ (...index.html)
    public static final String SETT_FROM_ENV = SysVar.get("MYGG_SETTINGS", 3);     // 0=boolean, 1=string, 2=int, 3=path
    public static final String LANG_FROM_ENV = SysVar.get("MYGG_LANG", 1); // NOT YET
    public static final String TEST_FROM_ENV = SysVar.get("MYGG_TEST", 0);
    public static final String LOG_LVL_FROM_ENV = SysVar.get("MYGG_LOG_LVL", 2);
    public static final String SGF_MAX_SZ_FROM_ENV = SysVar.get("MYGG_SGF_MAX_SZ", 2);
// ############################ use test environment ##############################
    public static boolean TEST = (!TEST_FROM_ENV.equals("")) ? Boolean.valueOf(TEST_FROM_ENV): false; // ### SET HERE TO DEFAULT
    // all test runs: uses test folder, indicated by the program's title
// ############################ get stack traces ##################################
    public static boolean DEBUG1 = false;     //  common 
    public static boolean DEBUG2 = false;    // sgf parsing
    public static boolean dbg2ToggledFromCLI = false; //  sgf parsing and handling 
    // DEBUG2 can be set in the mygrinder.ini and be temporary toggled by -debug2 switch from the command line
    public static boolean DEBUG3 = false;    //  graphics 
    public static boolean DEBUG4 = false;   //  sgf controller, ProbData 
    public static boolean dbg4ToggledFromCLI = false; //  sgf controller + data
    // DEBUG4 can be set in the mygrinder.ini and be temporary toggled by -debug4 switch from the command line
    public static boolean DEBUG5 = false;   //  sgf selection + collection 
    public static boolean DEBUG6 = false;   //  file
    public static boolean DEBUG7 = false;   // language/locale, Charset
// ################################################################################
    public static int parserLogLevel = (!LOG_LVL_FROM_ENV.equals("")) ? Integer.valueOf(LOG_LVL_FROM_ENV) : 1 ;
    public static boolean parserLogLevelBySysVar = (!LOG_LVL_FROM_ENV.equals(""));
    public static long parserSGFMaxFileSize = (!SGF_MAX_SZ_FROM_ENV.equals("")) ? Long.valueOf(SGF_MAX_SZ_FROM_ENV) : 100000;
    

    public static String GRINDER_TITLE = "";
    public static final int EXPORTREVISION = 1; // for export/import of problems sets (*.gxp)
    public static String GRINDER_VERSION = ""; // from messages: "GoGrinder Version" + NUM_VER_STRING + 
    public static final int NUMERIC_VERSION = 231; // this was used for the update check - but we don't use it anymore...
    public static final String NUM_VER_STRING = "2.3.1"; // this is only used once
    public static final String VERSION_STRING = "Version " + NUM_VER_STRING;

    public static final String PROBLEM_DIR = "problems";
    public static final String STATS_DIR = "stats";
    public static final String DEFECT_DIR = "defect"; // not yet used, planned to move defect files
    public static final String BACKUP_DIR = "backup"; // not yet used, planned to backup original of edited files (and edited themselves also?)
    public static final String NOTSUPPORTED_DIR = "notsupported"; // e.g. files with pass moves
    public static final String EDITS_DIR = "edits"; // files with your edits; copy them manually there - NOT YET USED
    
    public static boolean PORTABLE = false; // change it 
    // we can override this to true by command line switch -p/-portable (then settings + sgf are in the program's folder)

    public static String thisProgsFolder = "./"; // in main we go through thisJarsPath() and set it new

    public static String pathToDocs = "docs";
    public static String pathToStats = "";
    public static String pathToProblems = ""; // these are just the user's own problems; more can be expected in 
                                              // the program's install path and in the AllUsers path resp. shared path
                                              // perhaps we implement this in a later program version
    public static String pathToBackup = "";
    public static String pathToDefect = "";
    public static String pathToNotSupported = "";
    public static String pathToEdits = "";
    public static String pathToDefaultWGFFile = "";
    
    private static String STARTUP_INI; 
    // in $HOME, has the pathToSettings String
    private static String SETTINGS_FOLDER; 
    // name is just a default
    public static final String SETTINGS_FILE_NEW = "mygrinder.ini"; // in the settings folder
    public static final String SETTINGS_FILE_OLD = "grind.dat"; //
    public static final String LOCALE_FILE = "grind.locale"; //
    public static String settingsOldFilePath = ""; // grind.dat with full path (in the settings folder)
    public static String localeOldFilePath = ""; // grind.locale with full path (in the settings folder)
    public static final String SGF_LOG = "sgf-log.txt";
    public static final String COMMON_LOG = "grind-log.txt"; // we use .txt, because Mac tends to open the file with it's own log viewer
    
    private static final String SGF_DEFAULT_FILE = "default.sgf"; // possibly we can forget this, as we have now 
                                                  // an exit button in the selection window; but... this way we can 
                                                  // explore the program without installing problems
    public static String pathToDefaultSGFFile = "";
    public static final String SGF_DEFAULT_CODE = "(;SZ[5]AB[cb][bc][dc]AW[cc]C[Capture!];B[cd]C[Yes!])";
    private static final String WGF_DEFAULT_FILE = "default.wgf"; // if problem loading file from saved history
    private static final String WGF_DEFAULT_CODE = 
            "(;SZ[5];B[cb]W[cd]B[bc]W[dc]B[bd]W[db]B[ce]W[de]B[be]W[cc]B[bb]W[ca]B[ba]W[da];B[ed]W[dd]B[ec]W[eb])";
    // When I activated the WGF editor, I found some problems with a not existing WGF file (from history and when aborting)
    public static long maxLogFileSize = 1000000; // you may change this manually in the settings file
    public static final Color BGCOLOR = new Color(228, 234, 219);
    public static final Color SELCOLOR = new Color(197, 201, 189);

    public static final Random rand = new Random();   
         // for flip/turnaround board, switch colours + answer path - oh, and white stones
        
    public static AudioClip clickSound;
    public static AudioClip rightSound;
    public static AudioClip wrongSound;

    public static final String NEW_LINE = "\r\n"; // This is for the log and the sgf files
    public static String USER_HOME = System.getProperty("user.home"); // PRIVAT (rest: see SysInfo)
    public static final String SLASH = System.getProperty("file.separator"); // for working with paths
    public static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    public static final boolean IS_MAC = (System.getProperty("mrj.version") != null);

    public static String pathToIniFile = "";
    public static File pathToIniFileF = new File(pathToIniFile);
    public static String pathToSettings = "";
    public static File pathToSettingsF = new File(pathToSettings);
    public static String pathToSettingsFile = "";
    public static String sgfLogFilePath = (TEMP_DIR.endsWith("/") || TEMP_DIR.endsWith("\\")) ? 
                                             TEMP_DIR + SGF_LOG : TEMP_DIR + SLASH + SGF_LOG ;
    public static String commonLogFilePath = (TEMP_DIR.endsWith("/") || TEMP_DIR.endsWith("\\")) ? 
                                             TEMP_DIR + COMMON_LOG : TEMP_DIR + SLASH + COMMON_LOG ;
                                             // we don't want this to become e.g. G:\USERS\Temp\\grind-log.txt
    
    public static String language = ""; // later we integrate this in settings.new
    public static String LANGUAGE_TOKENS = "cz, de, en, es, fr, pt, ru, zh"; // for the messages 
    public static final String PROJECTPAGE = "http://sourceforge.net/projects/mygogrinder"; // and https?

    private static String question = "";
    private static String caption = "";
    public static boolean noSplash = false;
    static final String NL = NEW_LINE;
    public static boolean warningsStartup = false;

    private static final ExceptionHandler handler = new ExceptionHandler();
    public static ProbFrame probFrame;
    public static WGFFrame wgfFrame;
    
    /** Creates a new instance of Main */
    public Main() {
        setColors(); // why was this in .main? (...and in a try-catch block)

        System.setProperty("sun.awt.exception.handler", "GoGrinder.ExceptionHandler");
        GRINDER_VERSION = Messages.getString("gg_version") 
                        + " " + NUM_VER_STRING;
        Browser.init(); // ostermiller
         
        SplashScreen splash = new SplashScreen(probFrame, !noSplash);
        
        // /*## DEBUG ##*/ Runtime run = Runtime.getRuntime(); // ### DEBUG ###
        // /*## DEBUG ##*/ System.out.println(run.totalMemory() - run.freeMemory()); // ### DEBUG ###
        File probDir = new File(pathToProblems);
        if(!probDir.exists()) { // this shouldn't anymore happen - we created it on startup and added a default sgf
            JOptionPane.showMessageDialog(probFrame, Messages.getString("couldnt_find_probdir") + "\n"
                                              + "\"" + probDir.getAbsolutePath() + "\"\n" 
                                              + "Please check the folder and the log file!");
            System.exit(-1);
        }
        GS.setCollections(new ProbCollection(null, probDir, splash)); 
                                          // first this, then load settings? - but right, the collection isn't 
                                          // saved, but read in at startup; GS is only the place to exchange
                                          // the information
        // /*## DEBUG ##*/ System.out.println(run.totalMemory() - run.freeMemory()); // ### DEBUG ###

        splash.setStatus(Messages.getString("loading_settings"));
        GS.loadSettings();
        // backup of log files happens in GS
        probFrame = new ProbFrame(splash);
        wgfFrame = new WGFFrame();
        
        if(GS.getCheckForUpdates() && !warningsStartup) { 
        // The GoGrinder project is nearly dead since 8 years. So why have "check for update" as default?
            JOptionPane.showMessageDialog(null, "GoGrinder Version 1.14 (jan.2006) was the last official version by Tim Kington. \n"
                                              + "This \"tinkered\" version doesn't try to find an update. \n"
                                              + "At the moment (february 2015) there is some movement in this coding attempt. \n"
                                              + "Visit http://sourceforge.net/project/mygogrinder to see progress.");
            GS.setCheckForUpdates(false);
        }
        
        new FileFilters(); // initializes the file filters
        
        if(GS.getClickSoundEnabled() || GS.getSoundEnabled())
            loadSounds(this);
        
        wgfFrame.loadHistory(); // why redirection over WGFFrame? (there redir to wgfController)

        splash.setVisible(false);
        splash.dispose(); // why first unset visible and then dispose?

        probFrame.selectFirstProb();

        if(GS.getProbState()){
//  try { Thread.sleep(500); } catch(Exception e){};   // TEST
            probFrame.setVisible(true);
        }
        else {
            wgfFrame.setVisible(true);}
    }
    
      // called from GG/SGFController, GG/ui/ProbFrame, GG/ui/WGFFrame, GG/ui/SelectionDialog
    public static void onExit() {
      if (!GS.getFullScreen()){ // else it is already set in GS
        // important to switch and get bounds while frame is visible, 
        // as else GS seems to get the values of the maximized frame 
        GS.setWindowStatus(probFrame.getExtendedState()); 
        probFrame.setExtendedState(0);
        GS.setWindowedBounds(probFrame.getBounds());
      }
      GS.setWGFFrameBounds(wgfFrame.getBounds());
      GS.setSplitterPos(wgfFrame.getSplitterPos());
      wgfFrame.saveHistory();
      GS.saveSettings();
      // saveSettingsNew();

      // sometimes, when exiting, we get an "Exception while removing reference." - maybe, we add a delay here? It seems, this has solved the issue:
      try { Thread.sleep(500); } catch(Exception e){};
      System.exit(0);
    }
    
  // switch between ProbFrame and WGFFrame, called from these 2
    public static void switchState() { 
        boolean probState = GS.getProbState();
        if (!GS.getEnableWGFEditor())
          JOptionPane.showMessageDialog(null, "Enable the menu entry for the WGF editor in the settings window");
        probState = !probState;
        GS.setProbState(probState);
        
        if(probState)
            GS.getSelectedSets().resetProblemTime();
        probFrame.setVisible(probState);
        wgfFrame.setVisible(!probState);
    }

     // called from GG/ui/ProbFrame, GG/ui/WGFFrame and 10 (of 11) in GG/ui/actions,
    public static ImageIcon getIcon(String imageName, Object o) {
        String imagePath = "GoGrinder/images/" + imageName;
        ClassLoader cl = o.getClass().getClassLoader();
        URL url = cl.getResource(imagePath);
        return new ImageIcon(url);
    }
    
  // load sounds
    private static void loadSounds(Object obj) {
        clickSound = Applet.newAudioClip(obj.getClass().getResource("/GoGrinder/sounds/click.wav"));
        rightSound = Applet.newAudioClip(obj.getClass().getResource("/GoGrinder/sounds/right.wav"));
        wrongSound = Applet.newAudioClip(obj.getClass().getResource("/GoGrinder/sounds/wrong.wav"));
    }
    
  // handle logs etc. // why not completely handle logs in "ExceptionHandler", "Logging" class or similar? (ExcAndLogs())
    public static void log(Throwable t) { handler.handle(t); }
    public static void logSilent(Throwable t) { handler.logSilent(t); }
    public static void logSilent(Throwable t, String filename) { handler.logSilent(t, filename); }
    public static void logSilent(String s) {handler.logSilent(s);}
    public static void logEditorProblem(Throwable t, String msg) { handler.logEditorProblem(t, msg); }
    
    static void setColors() { // public static Object put(Object key, Object value)   Throws: NullPointerException - if key is null
        UIManager.put("Button.background", BGCOLOR);
        UIManager.put("CheckBox.background", BGCOLOR);
        UIManager.put("CheckBoxMenuItem.background", BGCOLOR);
        UIManager.put("ComboBox.background", BGCOLOR);
        UIManager.put("ComboBox.disabledBackground", BGCOLOR);
        UIManager.put("Menu.background", BGCOLOR);
        UIManager.put("MenuBar.background", BGCOLOR);
        UIManager.put("MenuItem.background", BGCOLOR);
        UIManager.put("OptionPane.background", BGCOLOR);
        UIManager.put("Panel.background", BGCOLOR);
        UIManager.put("ScrollBar.background", BGCOLOR);
        UIManager.put("ScrollBar.thumb", BGCOLOR);
        UIManager.put("Table.background", BGCOLOR);
        UIManager.put("TableHeader.background", BGCOLOR);
        UIManager.put("ToggleButton.background", BGCOLOR);
        UIManager.put("ToolBar.background", BGCOLOR);
        UIManager.put("Viewport.background", BGCOLOR);
        UIManager.put("control", BGCOLOR);
        
        UIManager.put("Button.select", SELCOLOR);
        UIManager.put("ToggleButton.select", SELCOLOR);
    }
    
  // do we have a valid java version? (old was 1.4.2 - we don't keep that) 
    private static void checkJavaVersion(){ 
    // could be with needed version and true-false (int verNeeded, int minMax) -1=minNeeded, 1=maxNeeded...
      // we check first, if the Java version is enough for us - so here: 5, -1; for sun.awt.excHandler: 6, 1
          // OH! Ah, need compile with switch for older java releases - 1.5 should be enough
          //   -source <release>          Provide source compatibility with specified release
          // or -target <...>
        String versRequired = Messages.getString("java_5_required");
        String continueText = "We will continue here, but, be warned: unexpected behaviour may be the result!";
        try { // java.version gives e.g. 1.7.0_25
            StringTokenizer tok = new StringTokenizer(SysInfo.JAVA_VERSION, "._-");
            int major = Integer.parseInt(tok.nextToken());
            int minor = Integer.parseInt(tok.nextToken());
            int sub = Integer.parseInt(tok.nextToken());
            boolean badver = false;
            if(major == 1) {   // but what, if Oracle decides to go away from Sun's version numbers?
                if(minor < 5)  // O.K., that is possibly so far in the future, that computers aren't used anyway
                    badver = true;
                else if(minor == 5) {
                    if(sub < 0) // this will not happen, as "-" is one of the split characters
                        badver = true;
                }
            }
            if(badver) { // older versions of Java: don't they have a message window, which can be used here?
                System.out.println(versRequired + "\n" + Messages.getString("you_are_running_ver") + " " + SysInfo.JAVA_VERSION);
                JOptionPane.showMessageDialog(null, versRequired + "\n" 
                                                  + Messages.getString("you_are_running_ver") + " " + SysInfo.JAVA_VERSION
                                                  + continueText);
                return; // here should be a yes/exit message
            }
        } // could be NumberFormatException // here should be a yes/exit message
        catch(Exception e) { // unknown vendors of Java: don't they have a message window, which can be used here?
            System.out.println(Messages.getString("warn_couldnt_parse_ver") + " " + SysInfo.JAVA_VERSION + "\n"
                               + versRequired);
            JOptionPane.showMessageDialog(null, Messages.getString("warn_couldnt_parse_ver") + " " + SysInfo.JAVA_VERSION + "\n"
                                              + versRequired + "\n"
                                              + continueText);
        } // code repetition
    }


  // show preferences window
    public static void showPrefs(JFrame parent) {
        new SettingsDialog(parent);
        if(clickSound == null && (GS.getSoundEnabled() || GS.getClickSoundEnabled()))
            loadSounds(parent);
    }
// ###################################################################################################################    
  // the pathToSettings is saved in an ini file (".mygogrinder.ini") in the user's home folder
    private static boolean findOrCreateSettingsFolder(){ // true = found, it is filled; false = new folder, nothing in it
      boolean validFolder = false;
      if (PORTABLE || FileWorks.testPortable()){ // ###### warningsStartup
      //PORTABLE: command line switch -p/-portable; testPortable(): regular file "PORTABLE" in program's folder
        pathToSettings = Main.thisProgsFolder;
        validFolder = FileWorks.testFolder(pathToSettings, true, false); // ###### warningsStartup
                                         // true: needWrite; false: warnUser (we warn here)
        if (!validFolder && PORTABLE){
          JOptionPane.showMessageDialog(null, "Problem with folder for portable usage of MyGoGrinder:\n"
                                              + "\"" + pathToSettings + "\"\n"
                                              + "Possibly we cannot write."); 
                                 // with demo mode on we can ignore missing write access (thought of: -d/-demo)
                                 // then the program would look for file "DEMO" in the settings folder (portable or not)
          System.exit(-1);
        }
      }
      if ( !SETT_FROM_ENV.equals("") && !PORTABLE){ // if sett. from sys-var // the folder needs to exist already!
        pathToSettings = FileWorks.cleanPath(SETT_FROM_ENV); // remove a possibly existing trailing slash
        pathToSettingsF = new File (pathToSettings);
        validFolder = FileWorks.testFolder(pathToSettings, true, false); // true: needWrite; false: warnUser  // ###### warningsStartup
        if (!validFolder){ // ###### warningsStartup
          JOptionPane.showMessageDialog(null, "Problem with settings folder from environment variable: \n"
                                            + "We read: \"" + pathToSettings + "\""
                                            + "The folder needs to exist!");
        }
      }
      if( !validFolder ){
      
        pathToIniFileF = new File(pathToIniFile); // with one line: path to settings
        
          // read ini file and test content
        if (pathToIniFileF.exists()){/*read one line with pathToSettings*/
          pathToSettings = FileWReadWrite.readFileLineDefaultCharset(pathToIniFile).trim();
            pathToSettingsF = new File (pathToSettings);
            validFolder = FileWorks.testFolder(pathToSettings, true, false); // true: needWrite; false: warnUser WHY NOT WARN?
             // ###### warningsStartup
            
            // result true: use existing settings
          if (!validFolder){ // ###### warningsStartup
            JOptionPane.showMessageDialog(null, "Problem with folder from ini file: \n"
                                              + "\"" + pathToSettings + "\""
                                              + "The folder needs to exist!");
          }
        }
      } // end read settings from ini file
      
      // highlighted button depends on existing default settings folder:
      int defBtn = 0; // (counts left to right, 0 = leftmost button)
      if ( new File(USER_HOME + SLASH + SETTINGS_FOLDER).exists() ){
        defBtn = 1;
        warningsStartup = true;
      }
      else 
        defBtn = 0;
      if (!validFolder) {//no valid entry in ini file (and nothing valid in the sys-var)  // ###### warningsStartup
        // I prefer to now let the user select the language and then proceed // what about this in a nice graphic?
        String caption = "Select folder for settings and problems";
        String msg = "File \"" + pathToIniFileF.getPath() + "\" not found or no valid content! \n"
                                      + "Use standard folder for settings and problems? \n"
                                      + "(\"" + USER_HOME + SLASH + SETTINGS_FOLDER + "\") \n";
        if (SelectionDialog.OKCancelMsg(msg, caption, defBtn)){
          pathToSettings = USER_HOME + SLASH + SETTINGS_FOLDER;
          pathToSettingsF = new File(pathToSettings);
          if (pathToSettingsF.exists()){ // test for existing standard folder // how about open folder in explorer? // ###### warningsStartup
            validFolder = SelectionDialog.OKCancelMsg("There is an already existing standard folder for settings. \n"
                                                            + "Please check the files inside! \n"
                                                            + "Maybe you want to make a backup before proceeding? \n"
                                                            + "Use this folder now?",
                                                              "Standard folder already there");
          }
          else { // create, should be + subfolders: problems, stats, backup, defect
            validFolder = FileWorks.createFolder(pathToSettingsF);
          }
        }
        if(!validFolder) { // select folder for settings
        // Standard: test folder  true: test Subdirs, show files - ok = create ini, write to ini ,not ok = select folder
        //                       false: mkdir(s), create ini, write to ini
          File selected[];
          while (!validFolder){
            selected = FileWorks.selectFolder(1, "Select a folder for MyGoGrinder settings", "Use folder", USER_HOME, true);
            // 1: one folder, true: needWrite
            pathToSettingsF = selected[0];
            validFolder = ( (pathToSettingsF != null) && (pathToSettingsF.exists()) );
            pathToSettings = pathToSettingsF.toString(); // ohhh rasta!!
            // validFolder = pathToSettingsF.exists(); // doublemubble? no, this way we realize, if file selection was aborted
              // file select aborted or not valid
            if (!validFolder) {
              if (SelectionDialog.OKCancelMsg("No folder selected. Quit the program here?", "Quit?")) System.exit(0);
              else continue;
            }
            else {
              String[] listedContent = FileWorks.listFiles(pathToSettings);
              if (listedContent.length != 0){
                validFolder = SelectionDialog.OKCancelMsg("There are files or folders in the choosen folder for settings: \n"
                                                        + "\"" + pathToSettings + "\"\n"
                                                        + "Please check the files inside! \n"
                                                        + "Maybe you want to make a backup before proceeding? \n"
                                                        + "Use this folder now?",
                                                          "Choosen folder is not empty");
              }
            }
          }
        } // end select folder for settings

        if (validFolder){ // write settings to ini
          boolean success = FileWReadWrite.writeFileLine(pathToIniFile, pathToSettings);
          if (!success) JOptionPane.showMessageDialog(null, "Error writing ini-file: \n"
                                                          + "\"" + pathToIniFile + "\"");
          return validFolder;   // CHECK !!
        } // end write settings to ini
        return validFolder; // CHECK LOGICS!!
      } //no valid entry in ini file
      return validFolder;  // CHECK LOGICS!! // we should exit, when we don't get a valid folder
   // heavy taste of spaghetti ... no - its rasta!
     
     
    } // end of findOrCreateSettingsFolder()

    private static void getSettingsFolder(){ // it is better to have all this settings related in an own class
      boolean settingsExist = findOrCreateSettingsFolder(); 
      // the return is just validFolder; but user is asked for o.k. to use existing settings
      // WRONG -> true = found, it is filled; false = new folder, nothing in it
     
      settingsOldFilePath = pathToSettings + SLASH + SETTINGS_FILE_OLD;
      localeOldFilePath = pathToSettings + SLASH + LOCALE_FILE;
      
 //System.out.println("language " + language); // ## DEBUG ##
 //     if (language != null) ;
 //System.out.println("\n language: " + language); // ## DEBUG ##
      Messages.setDefaultLanguage(language); // this here??
      
      pathToDefaultWGFFile = pathToSettings + SLASH + WGF_DEFAULT_FILE; // this here??
      if (!(new File(pathToDefaultWGFFile).exists())){
        FileWReadWrite.writeFileLine(pathToDefaultWGFFile, WGF_DEFAULT_CODE);
      }
      
      sgfLogFilePath = pathToSettings + SLASH + SGF_LOG;
      commonLogFilePath = pathToSettings + SLASH + COMMON_LOG;
      pathToSettingsFile = pathToSettings + SLASH + SETTINGS_FILE_NEW;

      pathToProblems = initialCreateFolder(PROBLEM_DIR);
      
      pathToDefaultSGFFile = pathToProblems + SLASH + SGF_DEFAULT_FILE;
      if (!(new File(pathToDefaultSGFFile).exists())){
        FileWReadWrite.writeFileLine(pathToDefaultSGFFile, SGF_DEFAULT_CODE);
      }
      
      pathToStats = initialCreateFolder(STATS_DIR);
      pathToBackup = initialCreateFolder(BACKUP_DIR); // automatic copy when edited ([X] NOT YET)
      pathToDefect = initialCreateFolder(DEFECT_DIR);  // automatic move of defect files (settings file!)
      pathToNotSupported = initialCreateFolder(NOTSUPPORTED_DIR); // automatic move of pass-move files (settings file!)
      pathToEdits = initialCreateFolder(EDITS_DIR); // copy your edits there (no automatism)
    }

    private static String initialCreateFolder(String subfolder){ // we can extent this and add a remark file, if it doesn't exist
      String fullPath = pathToSettings + SLASH + subfolder;
      File fullPathF = new File(fullPath);
      boolean created = false; // not really good: just used to get FileWorks.createFolder() running
      if (!fullPathF.exists()) created = FileWorks.createFolder(fullPath); // now a describing file
      return fullPath;
    }
    
    private static void writeDefaultFile(String fileWithPath){
      
    }

    // we want to be sure, that we insert a slash where is none, when we construct a path (is this critical?)
    private static void sysPropsToCanonicalFileString(){
      USER_HOME = FileWorks.cleanPath(System.getProperty("user.home")); // we remove a trailing "/"
    }
    
  // stolen from the jEdit installer, where it tests for "!" (but I extended it):
  // the "!" in the jar's path sometimes leads to an error when 
  // using java.util.ResourceBundle (try "!" as folder name or last char. of
  // a parent folder) 
    private static String thisJarsPath(){
      Class thisClass = Main.class;
      ProtectionDomain thisDomain = thisClass.getProtectionDomain();
      CodeSource origin = thisDomain.getCodeSource();
      URL jarPathURL = origin.getLocation();
      URI jarPathURI = null;
      try{
        jarPathURI = jarPathURL.toURI();
      }
      catch (URISyntaxException ex3){
        String msg = "Error in getting thisJarsPath(): cannot make URI out of URL:" + NL
                   + jarPathURL.toString();
        JOptionPane.showMessageDialog(null, msg);
        handler.logCommonProblem(ex3, msg);
      }
      if (jarPathURI == null) System.exit(-1);
      String cleanString = jarPathURI.getPath();
      if (SysInfo.OS_NAME.toLowerCase().startsWith("windows")){cleanString = cleanString.substring(1, cleanString.length());}
      String jarPath = new File(cleanString).getParent();
      return jarPath;
    }
      
    private static void checkDocPath(){
      if (DOCP_FROM_ENV.equals("") )
        pathToDocs = thisProgsFolder + SLASH + pathToDocs;
      else if ( !(new File(DOCP_FROM_ENV.trim()).exists()) ) {
        String msg = "Path to help files in environment variable not valid: \n"
                   + DOCP_FROM_ENV.trim() + "\n"
                   + "(I don't process quotation marks!)\n"
                   + "Using default path (I hope, the help files are there).";
        JOptionPane.showMessageDialog(null, msg);
        pathToDocs = thisProgsFolder + SLASH + pathToDocs;
      }
      else if ( !(new File(DOCP_FROM_ENV.trim() + "/docs.html").exists())) {
        String msg = "I didn't find \"" + DOCP_FROM_ENV.trim() + "/docs.html\" in the docs path.\n"
                   + "Using default docs path (I hope, the help files are there)."; 
                   // when help is called from menu or button (probs+wgf), file.exists() is tested again
        JOptionPane.showMessageDialog(null, msg);
        pathToDocs = thisProgsFolder + SLASH + pathToDocs;
      }
      else 
        pathToDocs = FileWorks.cleanPath(DOCP_FROM_ENV.trim()); // remove a possibly existing trailing slash
    }
      

    public static void main(String[] switches) { // switches from command line
      if (IS_MAC){ // this must be done before the first use of swing
        System.setProperty("apple.laf.useScreenMenuBar", "true");
      }

      Messages.initMessages(); // initializing temporary to current jvm's locale
      checkJavaVersion(); // 1.5 or higher required
 
      thisProgsFolder = thisJarsPath();

      checkDocPath();
      new PrgStartInfo();

      // we should have initVariablesAndFinals(); // there e.g. filters etc. 
      // initTags (first use): do, WHEN CREATE dir
      if (switches.length > 0){ 
        if(!ParseCmdLine.parseCommandLine(switches) ){   // DO THIS BEFORE BUILDING THE SETTINGS PATH, AS WE
           new CmdLineHelp(); //(with exit))             // HAVE SWITCHES "-portable" (set) AND "-test" (toggle)
        }
      }

      // here now set ini, settings folder and caption
      GRINDER_TITLE = (TEST) ? "TEST_Grinder - " : (PORTABLE) ? "MyGoGrinder Portable - " : "MyGoGrinder - ";
      STARTUP_INI = (TEST) ? "TESTgrinder.ini" : ".mygogrinder.ini";
      SETTINGS_FOLDER = (TEST) ? "TESTGrinderSettings" : "MyGoGrinderSettings";
      
      sysPropsToCanonicalFileString(); // just getting $HOME, but without "/" at the end
      pathToIniFile = USER_HOME + SLASH + STARTUP_INI;
 // HERE IS CHEESE HIDDEN!

      // these check the log files' sizes in $TEMP
      //SGFLog.checkLogSize(sgfLogFilePath, GS.getSgfLogWarnFileSize()); 
      //SGFLog.checkLogSize(commonLogFilePath, GS.getCommonLogWarnFileSize());

      getSettingsFolder(); // name was loadSettings - this is better for description
                      // up to here the log has been written to $TEMP/grind.log ; 
                      // we could append that log to the log in the settings folder and delete the tmp-log
        // a settingsFolder from the command line parameters could be handed over here 
 if(PORTABLE) System.out.println("\n Running MyGoGrinder in portable mode.\n");
      SGFLog.setLogFile(sgfLogFilePath);
      // these check the log files' sizes in Grinder's settings folder:
      SGFLog.checkLogSize(sgfLogFilePath, GS.getSgfLogWarnFileSize()); 
      SGFLog.checkLogSize(commonLogFilePath, GS.getCommonLogWarnFileSize());
      // oh these use the presets from GS
       
      try{
        new Main();
      }
      catch(Exception e){
          String msg = "What was that? Anywhere an uncaught exception! \n" 
                       + e.getMessage() + "\nSee " + commonLogFilePath;
          JOptionPane.showMessageDialog(null, msg);
          ExceptionHandler.logCommonProblem(e, msg);
          System.exit(-1);
      }
    }
}
