<?php
    //------------------------------------------------------------------------
    // m_linkblog.php - display a side menu with your del.icio.us links
    //
    // This requires you have (or know of one) an account and RSS feed at
    // http://del.icio.us
    //
    // The RSS for your del.icio.us feed is at http://del.icio.us/rss/<user>
    //------------------------------------------------------------------------
     
    $currentTag = "";
     
    function startElement2($parser, $name, $attrs)
    {
        global $currentTag;
        $currentTag = $name;
         
         
    }
     
    function endElement2($parser, $name)
    {
        global $currentTag, $TITLE, $LINK;
        // clear current tag variable
        switch ($currentTag)
        {
            case "LINK":
            print "<a href = \"$LINK\">$TITLE</a><br />";
            break;
        }
        $currentTag = "";
    }
     
    // process data between tags
    function characterData2($parser, $data)
    {
         
        global $currentTag, $TITLE, $LINK;
        switch ($currentTag)
        {
            case "TITLE":
            // italics for title
            $TITLE = $data;
            break;
             
            case "LINK":
            // italics for title
            $LINK = $data;
            break;
        }
    }
     
     
     
    drawMenuTop("Linkblog");
     
    $linkblogxml = "engine/shards/xmlcache/linkblog.xml";
     
    $filestats = @stat($linkblogxml );
     
    //
    // 1800 seconds is 30 minutes.  If the file doesn't exist or
    // if it older than 30 minutes we are allowed to seek slashdot.org
    // for a refresh.  Otherwise use the local copy of slashdot.xml.
    //
    if (($filestats == FALSE) || ($filestats[9] < time() - 1800) )
    {
		//
        // Your feed can be any RSS feed off of del.icio.us.  
		// (eg, http://del.icio.us/rss/popular)
		//
		$feed = fopen("http://del.icio.us/rss/azsromej", "r" );
        
		$localfeed = fopen($linkblogxml , "w" );
        if ($feed != FALSE )
        {
            while ($data = fread($feed, 4096 ) )
            {
                fwrite($localfeed, $data );
            }
            fclose($feed );
        }
        fclose($localfeed );
    }
     
    $feed = fopen($linkblogxml , "r" );
     
    if ($feed != FALSE )
    {
        $xparser = xml_parser_create();
        xml_set_element_handler($xparser, "startElement2", "endElement2");
        xml_set_character_data_handler($xparser, "characterData2" );
         
        while ($data = fread($feed, 4096 ) )
        {
            if (!xml_parse($xparser, $data, feof($feed)))
            {
                die("some crazy xml parsing error" );
            }
        }
        xml_parser_free($xparser );
    }
    else
    {
        print("<small>failed to open feed</small>");
    }
     
    drawMenuBottom();
     
?>
