/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.util;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import it.unimi.dsi.big.util.StringMap;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.objects.AbstractObject2LongFunction;
import it.unimi.dsi.fastutil.objects.Object2LongFunction;
import it.unimi.dsi.fastutil.objects.ObjectBigList;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.LineIterator;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShiftAddXorSignedStringMap
extends AbstractObject2LongFunction<CharSequence>
implements StringMap<CharSequence>,
Serializable {
    private static final long serialVersionUID = 0L;
    protected final Object2LongFunction<? extends CharSequence> function;
    protected final LongBigList signatures;
    protected final int width;
    protected final int shift;
    protected final long mask;

    public ShiftAddXorSignedStringMap(Iterator<? extends CharSequence> iterator, Object2LongFunction<? extends CharSequence> map) {
        this(iterator, map, 32);
    }

    public ShiftAddXorSignedStringMap(Iterator<? extends CharSequence> iterator, Object2LongFunction<? extends CharSequence> map, int signatureWidth) {
        this.function = map;
        this.width = signatureWidth;
        this.defRetValue = -1L;
        this.shift = 64 - this.width;
        this.mask = this.width == 64 ? 0L : (1L << this.width) - 1L;
        long n = map instanceof Size64 ? ((Size64)map).size64() : (long)map.size();
        this.signatures = LongArrayBitVector.getInstance().asLongBigList(signatureWidth);
        this.signatures.size(n);
        for (long i = 0L; i < n; ++i) {
            CharSequence s = iterator.next();
            this.signatures.set(map.getLong((Object)s), this.signature(s));
        }
        if (iterator.hasNext()) {
            throw new IllegalStateException("Iterator provides more than " + n + " elements");
        }
    }

    private long signature(CharSequence s) {
        long h = 42L;
        int i = s.length();
        while (i-- != 0) {
            h ^= (h << 5) + (long)s.charAt(i) + (h >>> 2);
        }
        return h >>> this.shift ^ h & this.mask;
    }

    private boolean checkSignature(CharSequence s, long index) {
        return index >= 0L && index < (long)this.function.size() && this.signatures.getLong(index) == this.signature(s);
    }

    public long getLong(Object o) {
        CharSequence s = (CharSequence)o;
        long index = this.function.getLong((Object)s);
        return this.checkSignature(s, index) ? index : this.defRetValue;
    }

    public Long get(Object o) {
        CharSequence s = (CharSequence)o;
        long index = this.function.getLong((Object)s);
        return this.checkSignature(s, index) ? Long.valueOf(index) : null;
    }

    public boolean containsKey(Object o) {
        CharSequence s = (CharSequence)o;
        return this.checkSignature(s, this.function.getLong((Object)s));
    }

    @Deprecated
    public int size() {
        return this.signatures.size();
    }

    public long size64() {
        return this.signatures.size64();
    }

    @Override
    public ObjectBigList<CharSequence> list() {
        return null;
    }

    public static void main(String[] arg) throws NoSuchMethodException, IOException, JSAPException, ClassNotFoundException {
        SimpleJSAP jsap = new SimpleJSAP(ShiftAddXorSignedStringMap.class.getName(), "Builds a shift-add-xor signed string map by reading a newline-separated list of strings and a function built on the same list of strings.", new Parameter[]{new FlaggedOption("bufferSize", (StringParser)JSAP.INTSIZE_PARSER, "64Ki", false, 'b', "buffer-size", "The size of the I/O buffer used to read strings."), new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The string file encoding."), new Switch("zipped", 'z', "zipped", "The string list is compressed in gzip format."), new FlaggedOption("width", (StringParser)JSAP.INTEGER_PARSER, Integer.toString(32), false, 'w', "width", "The signature width in bits."), new UnflaggedOption("function", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename of the function to be signed."), new UnflaggedOption("map", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename of the resulting serialised signed string map."), new UnflaggedOption("stringFile", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, false, "Read strings from this file instead of standard input.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        int bufferSize = jsapResult.getInt("bufferSize");
        String functionName = jsapResult.getString("function");
        String mapName = jsapResult.getString("map");
        String stringFile = jsapResult.getString("stringFile");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        int width = jsapResult.getInt("width");
        boolean zipped = jsapResult.getBoolean("zipped");
        InputStream inputStream = stringFile != null ? new FileInputStream(stringFile) : System.in;
        LineIterator iterator = new LineIterator(new FastBufferedReader((Reader)new InputStreamReader(zipped ? new GZIPInputStream(inputStream) : inputStream, encoding), bufferSize));
        Object2LongFunction function = (Object2LongFunction)BinIO.loadObject((CharSequence)functionName);
        Logger logger = LoggerFactory.getLogger(ShiftAddXorSignedStringMap.class);
        logger.info("Signing...");
        BinIO.storeObject((Object)new ShiftAddXorSignedStringMap((Iterator<? extends CharSequence>)((Object)iterator), (Object2LongFunction<? extends CharSequence>)function, width), (CharSequence)mapName);
        if (stringFile != null) {
            inputStream.close();
        }
        logger.info("Completed.");
    }
}

