/*
  Copyright (C) 1996      Seke Wei      (seke@sys.es.osaka-u.ac.jp)

  lang-util.h: provide the prototypes of supplementary routines for translation

        int     inc_ostr(postr,o_len,pbuf_size)
                ;adjust the buffer *postr so that its size *pbuf_size > o_len

        unsigned char   *py2uzpj(py)
                ;returns corresponding pinyin code for certain uzpj code


        unsigned char   *uzpj2py(uzpj)
                ;returns corresponding uzpj code for certain pinyin code

        char    *lang_big5_to_eucjis(istr)
                ;translate Big5 in istr to EUC-Jis in allocated buffer
                ;the allocated buffer is returned and valid until next call

	char	*lang_gb_to_eucjis();
                ;translate GB in istr to EUC-Jis in allocated buffer
                ;the allocated buffer is returned and valid until next call

	char	*lang_eucjis_to_big5();
		;translate EU-Jis in istr to Big5 in allocated buffer
		;the allocated buffer is returned and valid until next call

	int	lang_debug
		;turns on the debug info in translation

	int	lang_uzpj
		;uses the uzpj system for unmappable words

  This program is free for general distribution.

  This program runs on UNIX. You are welcome to port it to other operating
  systems.

*/

struct code_table {
				/* main table */
				/* size = row * char_per_row * 2 */
	char    tbl_name[20];	/* name of src to dest translatio table */
	int     row;		/* row of src code set */
	int     char_per_row;	/* char_per_row of src code set */
	char    *tbl;		/* table itself */

				/* supplementary table */
				/* size = supp_tbl_size = max_index*2 + content */
	int	supp_tbl_size;	/* supplementary translation table */
	int	supp_tbl_max_index;
	char	*supp_tbl;	/* supp table itself, */

	int     loaded;

	int	(*src_seq)();
	int	(*src_seq_to_dest)();
	char *	(*src_to_dest)();

};


#define MAX_PY_TBL      2066
#define MAX_PY_LEN      10

typedef unsigned char Mnemonic[MAX_PY_LEN];

struct uzpj_table {
	int		py_size;
	Mnemonic	*py_tbl;
	Mnemonic	*uzpj_tbl;
	int		loaded;

	unsigned char *	(*py2uzpj)();
	unsigned char *	(*uzpj2py)();
};



/*
	Supplementary Routines for Translation
*/

extern int lang_debug, lang_uzpj;
extern struct code_table	b2jtbl_static, g2jtbl_static, j2btbl_static;
extern struct code_table	g2btbl_static, b2gtbl_static, j2gtbl_static;
extern struct code_table	b2jtbl, g2jtbl, j2btbl, g2btbl, b2gtbl, j2gtbl;
extern struct uzpj_table	uzpjtbl, uzpjtbl_static;

int	inc_ostr(),src_seq_to_dest();
char	*src_to_dest();

char	*lang_big5_to_eucjis(), *lang_gb_to_eucjis();
char	*lang_eucjis_to_big5(), *lang_gb_to_big5();
char	*lang_big5_to_gb(), *lang_eucjis_to_gb();
