/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.net.PlainSocketImpl;
import gnu.java.nio.NIOSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NoConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.UnsupportedAddressTypeException;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;

public final class SocketChannelImpl
extends SocketChannel {
    private PlainSocketImpl impl;
    private NIOSocket socket;
    private boolean connectionPending;

    public final void finalizer() {
        if (this.isConnected()) {
            try {
                this.close();
            }
            catch (Exception exception) {}
        }
    }

    final PlainSocketImpl getPlainSocketImpl() {
        return this.impl;
    }

    protected final void implCloseSelectableChannel() throws IOException {
        this.socket.close();
    }

    protected final void implConfigureBlocking(boolean bl) throws IOException {
        this.socket.setSoTimeout(bl ? 0 : 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean connect(SocketAddress socketAddress) throws IOException {
        Throwable throwable2;
        boolean bl;
        block11: {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.isConnected()) {
                throw new AlreadyConnectedException();
            }
            if (this.connectionPending) {
                throw new ConnectionPendingException();
            }
            if (!(socketAddress instanceof InetSocketAddress)) {
                throw new UnsupportedAddressTypeException();
            }
            if (((InetSocketAddress)socketAddress).isUnresolved()) {
                throw new UnresolvedAddressException();
            }
            this.socket.getPlainSocketImpl().setInChannelOperation(true);
            if (!this.isBlocking()) break block11;
            this.socket.connect(socketAddress);
            boolean bl2 = true;
            Object var3_5 = null;
            this.socket.getPlainSocketImpl().setInChannelOperation(false);
            return bl2;
        }
        try {
            this.socket.connect(socketAddress, 50);
            bl = true;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            try {
                this.connectionPending = true;
                boolean bl3 = false;
                Object var3_7 = null;
                this.socket.getPlainSocketImpl().setInChannelOperation(false);
                return bl3;
            }
            catch (Throwable throwable2) {
                Object var3_8 = null;
                this.socket.getPlainSocketImpl().setInChannelOperation(false);
            }
        }
        Object var3_6 = null;
        this.socket.getPlainSocketImpl().setInChannelOperation(false);
        return bl;
        throw throwable2;
    }

    public final boolean finishConnect() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!this.isConnected() && !this.connectionPending) {
            throw new NoConnectionPendingException();
        }
        if (this.isConnected()) {
            return true;
        }
        AbstractSelector abstractSelector = this.provider().openSelector();
        this.register(abstractSelector, 8);
        if (this.isBlocking()) {
            abstractSelector.select();
            this.connectionPending = false;
            return true;
        }
        int n = abstractSelector.selectNow();
        if (n == 1) {
            this.connectionPending = false;
            return true;
        }
        return false;
    }

    public final boolean isConnected() {
        return this.socket.isConnected();
    }

    public final boolean isConnectionPending() {
        return this.connectionPending;
    }

    public final Socket socket() {
        return this.socket;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int read(ByteBuffer byteBuffer) throws IOException {
        byte[] byArray;
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        int n = 0;
        InputStream inputStream = this.socket.getInputStream();
        int n2 = inputStream.available();
        int n3 = byteBuffer.remaining();
        if (!this.isBlocking() && n2 == 0) {
            return 0;
        }
        if (byteBuffer.hasArray()) {
            n = byteBuffer.arrayOffset() + byteBuffer.position();
            byArray = byteBuffer.array();
        } else {
            byArray = new byte[n3];
        }
        int n4 = 0;
        boolean bl = false;
        try {
            this.begin();
            this.socket.getPlainSocketImpl().setInChannelOperation(true);
            n4 = inputStream.read(byArray, n, n3);
            bl = true;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.end(bl);
            this.socket.getPlainSocketImpl().setInChannelOperation(false);
            throw throwable;
        }
        {
            Object var10_11 = null;
        }
        this.end(bl);
        this.socket.getPlainSocketImpl().setInChannelOperation(false);
        if (n4 <= 0) return n4;
        if (byteBuffer.hasArray()) {
            byteBuffer.position(byteBuffer.position() + n4);
            return n4;
        }
        byteBuffer.put(byArray, n, n4);
        return n4;
    }

    public final long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        if (n < 0 || n > byteBufferArray.length || n2 < 0 || n2 > byteBufferArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        long l = 0L;
        int n3 = n;
        while (n3 < n2) {
            l += (long)this.read(byteBufferArray[n3]);
            ++n3;
        }
        return l;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int write(ByteBuffer byteBuffer) throws IOException {
        byte[] byArray;
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        int n = 0;
        int n2 = byteBuffer.remaining();
        if (!byteBuffer.hasArray()) {
            byArray = new byte[n2];
            byteBuffer.get(byArray, 0, n2);
        } else {
            n = byteBuffer.arrayOffset() + byteBuffer.position();
            byArray = byteBuffer.array();
        }
        OutputStream outputStream = this.socket.getOutputStream();
        boolean bl = false;
        try {
            this.begin();
            this.socket.getPlainSocketImpl().setInChannelOperation(true);
            outputStream.write(byArray, n, n2);
            bl = true;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.end(bl);
            this.socket.getPlainSocketImpl().setInChannelOperation(false);
            throw throwable;
        }
        {
            Object var8_9 = null;
        }
        this.end(bl);
        this.socket.getPlainSocketImpl().setInChannelOperation(false);
        if (byteBuffer.hasArray()) {
            byteBuffer.position(byteBuffer.position() + n2);
        }
        return n2;
    }

    public final long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        if (n < 0 || n > byteBufferArray.length || n2 < 0 || n2 > byteBufferArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        long l = 0L;
        int n3 = n;
        while (n3 < n2) {
            l += (long)this.write(byteBufferArray[n3]);
            ++n3;
        }
        return l;
    }

    SocketChannelImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        this.impl = new PlainSocketImpl();
        this.socket = new NIOSocket(this.impl, this);
        this.configureBlocking(true);
    }

    SocketChannelImpl(SelectorProvider selectorProvider, NIOSocket nIOSocket) throws IOException {
        super(selectorProvider);
        this.impl = nIOSocket.getPlainSocketImpl();
        this.socket = nIOSocket;
    }
}

