/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros;

import java.util.Hashtable;
import java.util.Vector;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.CommandLineArgument;
import org.parosproxy.paros.network.HttpSender;

public class CommandLine {
    static final String SESSION = "-session";
    static final String NEW_SESSION = "-newsession";
    static final String HELP = "-help";
    static final String HELP2 = "-h";
    static final String NO_USER_AGENT = "-nouseragent";
    static final String SP = "-sp";
    private boolean GUI = true;
    private String[] args = null;
    private Hashtable keywords = new Hashtable();
    private Vector commandList = null;

    public CommandLine(String[] stringArray) throws Exception {
        this.args = stringArray;
        this.parseFirst(this.args);
    }

    private boolean checkPair(String[] stringArray, String string, int n) throws Exception {
        String string2 = stringArray[n];
        String string3 = null;
        if (string2 == null) {
            return false;
        }
        if (string2.equalsIgnoreCase(string)) {
            string3 = stringArray[n + 1];
            if (string3 == null) {
                throw new Exception();
            }
            this.keywords.put(string, string3);
            stringArray[n] = null;
            stringArray[n + 1] = null;
            return true;
        }
        return false;
    }

    private boolean checkSwitch(String[] stringArray, String string, int n) throws Exception {
        String string2 = stringArray[n];
        if (string2 == null) {
            return false;
        }
        if (string2.equalsIgnoreCase(string)) {
            this.keywords.put(string, "");
            stringArray[n] = null;
            return true;
        }
        return false;
    }

    private void parseFirst(String[] stringArray) throws Exception {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.parseSwitchs(stringArray, i) && !this.parseKeywords(stringArray, i)) continue;
        }
    }

    public void parse(Vector vector) throws Exception {
        int n;
        this.commandList = vector;
        CommandLineArgument commandLineArgument = null;
        boolean bl = false;
        int n2 = 0;
        for (n = 0; n < this.args.length; ++n) {
            if (this.args[n] == null) continue;
            bl = false;
            for (int i = 0; i < vector.size() && !bl; ++i) {
                CommandLineArgument[] commandLineArgumentArray = (CommandLineArgument[])vector.get(i);
                for (int j = 0; j < commandLineArgumentArray.length && !bl; ++j) {
                    if (this.args[n].compareToIgnoreCase(commandLineArgumentArray[j].getName()) != 0) continue;
                    if (n2 > 0) {
                        throw new Exception("Missing parameters for keyword '" + commandLineArgument.getName() + "'.");
                    }
                    commandLineArgument = commandLineArgumentArray[j];
                    commandLineArgument.setEnabled(true);
                    bl = true;
                    this.args[n] = null;
                    n2 = commandLineArgument.getNumOfArguments();
                }
            }
            if (this.args[n] != null && this.args[n].startsWith("-") || commandLineArgument != null && n2 == 0 || bl || commandLineArgument == null) continue;
            if (commandLineArgument.getPattern() == null || commandLineArgument.getPattern().matcher(this.args[n]).find()) {
                commandLineArgument.getArguments().add(this.args[n]);
                if (n2 > 0) {
                    --n2;
                }
                this.args[n] = null;
                continue;
            }
            throw new Exception(commandLineArgument.getErrorMessage());
        }
        if (commandLineArgument != null && n2 > 0) {
            throw new Exception("Missing parameters for keyword '" + commandLineArgument.getName() + "'.");
        }
        for (n = 0; n < this.args.length; ++n) {
            if (this.args[n] == null) continue;
            throw new Exception("Unknown options: " + this.args[n]);
        }
    }

    private boolean parseSwitchs(String[] stringArray, int n) throws Exception {
        boolean bl = false;
        if (this.checkSwitch(stringArray, NO_USER_AGENT, n)) {
            HttpSender.setUserAgent("");
            Constant.setEyeCatcher("");
            bl = true;
        } else if (this.checkSwitch(stringArray, SP, n)) {
            Constant.setSP(true);
            bl = true;
        } else if (this.checkSwitch(stringArray, HELP, n)) {
            bl = true;
            this.setGUI(false);
        } else if (this.checkSwitch(stringArray, HELP2, n)) {
            bl = true;
            this.setGUI(false);
        }
        return bl;
    }

    private boolean parseKeywords(String[] stringArray, int n) throws Exception {
        boolean bl = false;
        if (this.checkPair(stringArray, NEW_SESSION, n)) {
            this.setGUI(false);
            bl = true;
        } else if (this.checkPair(stringArray, SESSION, n)) {
            this.setGUI(false);
            bl = true;
        }
        return bl;
    }

    public boolean isGUI() {
        return this.GUI;
    }

    public void setGUI(boolean bl) {
        this.GUI = bl;
    }

    public String getArgument(String string) {
        return (String)this.keywords.get(string);
    }

    static String getHelpGeneral() {
        String string = "\r\n";
        String string2 = "GUI usage:" + string + "\tjavaw paros.jar" + string + "\tjava -jar paros.jar" + string + "see java -jar paros.jar {-h|-help} for detail.\r\n\r\n";
        return string2;
    }

    public String getHelp() {
        StringBuffer stringBuffer = new StringBuffer(CommandLine.getHelpGeneral());
        stringBuffer.append("Command line usage:\r\n");
        stringBuffer.append("java -jar paros.jar {-h|-help} {-newsession session_file_path} {options}\r\n");
        stringBuffer.append("options:\r\n\r\n");
        for (int i = 0; i < this.commandList.size(); ++i) {
            CommandLineArgument[] commandLineArgumentArray = (CommandLineArgument[])this.commandList.get(i);
            for (int j = 0; j < commandLineArgumentArray.length; ++j) {
                stringBuffer.append(commandLineArgumentArray[j].getHelpMessage() + "\r\n");
            }
        }
        return stringBuffer.toString();
    }

    public boolean isEnabled(String string) {
        Object v = this.keywords.get(string);
        return v != null && v instanceof String;
    }
}

