/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.util.LinkedList;
import java.util.Map;
import org.sablecc.sablecc.Cast;
import org.sablecc.sablecc.NodeCast;
import org.sablecc.sablecc.ResolveIds;
import org.sablecc.sablecc.StringCast;
import org.sablecc.sablecc.StringComparator;
import org.sablecc.sablecc.TypedHashMap;
import org.sablecc.sablecc.TypedTreeMap;
import org.sablecc.sablecc.analysis.DepthFirstAdapter;
import org.sablecc.sablecc.node.AAst;
import org.sablecc.sablecc.node.AAstAlt;
import org.sablecc.sablecc.node.AAstProd;
import org.sablecc.sablecc.node.AElem;
import org.sablecc.sablecc.node.AProductions;
import org.sablecc.sablecc.node.ATokenSpecifier;
import org.sablecc.sablecc.node.Node;
import org.sablecc.sablecc.node.PAstProd;
import org.sablecc.sablecc.node.TId;
import org.sablecc.sablecc.node.Token;

public class ResolveAstIds
extends DepthFirstAdapter {
    public final Map ast_prods = new TypedTreeMap(StringComparator.instance, (Cast)StringCast.instance, (Cast)NodeCast.instance);
    public final Map ast_alts = new TypedTreeMap(StringComparator.instance, (Cast)StringCast.instance, (Cast)NodeCast.instance);
    public final Map ast_elems = new TypedTreeMap(StringComparator.instance, (Cast)StringCast.instance, (Cast)NodeCast.instance);
    public final Map ast_names = new TypedHashMap(NodeCast.instance, StringCast.instance);
    public final Map ast_elemTypes = new TypedHashMap(NodeCast.instance, StringCast.instance);
    public ResolveIds astIds;
    private String firstAstProduction;
    private String currentProd;
    private String currentAlt;
    private int lastLine;
    private int lastPos;

    public ResolveAstIds(ResolveIds ids) {
        this.astIds = ids;
    }

    public String getFirstAstProduction() {
        return this.firstAstProduction;
    }

    @Override
    public void inAAst(AAst node) {
        LinkedList<PAstProd> listProds = node.getProds();
        if (listProds.size() > 0) {
            AAstProd firstAstProd = (AAstProd)listProds.getFirst();
            this.firstAstProduction = "P" + ResolveIds.name(firstAstProd.getId().getText());
        }
    }

    @Override
    public void inAAstProd(AAstProd node) {
        this.currentProd = ResolveIds.name(node.getId().getText());
        String name = "P" + this.currentProd;
        if (this.ast_prods.put(name, node) != null) {
            ResolveAstIds.error(node.getId(), name);
        }
        this.ast_names.put(node, name);
    }

    @Override
    public void inAAstAlt(AAstAlt alt) {
        if (alt.getAltName() != null) {
            this.currentAlt = "A" + ResolveIds.name(alt.getAltName().getText()) + this.currentProd;
            if (this.ast_alts.put(this.currentAlt, alt) != null) {
                ResolveAstIds.error(alt.getAltName(), this.currentAlt);
            }
            this.ast_names.put(alt, this.currentAlt);
        } else {
            this.currentAlt = "A" + this.currentProd;
            if (this.ast_alts.put(this.currentAlt, alt) != null) {
                this.error(this.currentAlt);
            }
            this.ast_names.put(alt, this.currentAlt);
        }
    }

    @Override
    public void caseAProductions(AProductions node) {
    }

    @Override
    public void caseAElem(AElem elem) {
        TId tid = elem.getElemName() != null ? elem.getElemName() : elem.getId();
        String elem_name = tid.getText();
        String name = this.currentAlt + "." + ResolveIds.name(elem_name);
        if (this.ast_elems.put(name, elem) != null) {
            ResolveAstIds.error(tid, name);
        }
        if (elem_name.equals("class")) {
            ResolveAstIds.error5(tid);
        }
        this.ast_names.put(elem, ResolveIds.name(elem_name));
    }

    @Override
    public void outAAstProd(AAstProd prod) {
        prod.apply(new DepthFirstAdapter(){

            @Override
            public void caseAElem(AElem node) {
                String name = ResolveIds.name(node.getId().getText());
                if (node.getSpecifier() != null) {
                    if (node.getSpecifier() instanceof ATokenSpecifier) {
                        ResolveAstIds.this.ast_elemTypes.put(node, "T" + name);
                    } else {
                        ResolveAstIds.this.ast_elemTypes.put(node, "P" + name);
                    }
                } else {
                    Object token = ResolveAstIds.this.astIds.tokens.get("T" + name);
                    if (token != null) {
                        ResolveAstIds.this.ast_elemTypes.put(node, "T" + name);
                    } else {
                        ResolveAstIds.this.ast_elemTypes.put(node, "P" + name);
                    }
                }
            }
        });
    }

    @Override
    public void outAAst(AAst prod) {
        prod.apply(new DepthFirstAdapter(){

            @Override
            public void caseAElem(AElem node) {
                String name = ResolveIds.name(node.getId().getText());
                if (node.getSpecifier() != null) {
                    if (node.getSpecifier() instanceof ATokenSpecifier) {
                        if (ResolveAstIds.this.astIds.tokens.get("T" + name) == null) {
                            ResolveAstIds.error2(node.getId(), "T" + name);
                        }
                        if (ResolveAstIds.this.astIds.ignTokens.get("T" + name) != null) {
                            ResolveAstIds.error3(node.getId(), "T" + name);
                        }
                        ResolveAstIds.this.ast_elemTypes.put(node, "T" + name);
                    } else {
                        if (ResolveAstIds.this.ast_prods.get("P" + name) == null) {
                            ResolveAstIds.error2(node.getId(), "P" + name);
                        }
                        ResolveAstIds.this.ast_elemTypes.put(node, "P" + name);
                    }
                } else {
                    Object token = ResolveAstIds.this.astIds.tokens.get("T" + name);
                    Object ignToken = ResolveAstIds.this.astIds.ignTokens.get("T" + name);
                    Object ast_production = ResolveAstIds.this.ast_prods.get("P" + name);
                    if (token == null && ast_production == null) {
                        ResolveAstIds.error2(node.getId(), "P" + name + " and T" + name);
                    }
                    if (token != null) {
                        if (ast_production != null) {
                            ResolveAstIds.error4(node.getId(), "P" + name + " and T" + name);
                        }
                        if (ignToken != null) {
                            ResolveAstIds.error3(node.getId(), "T" + name);
                        }
                        ResolveAstIds.this.ast_elemTypes.put(node, "T" + name);
                    } else {
                        ResolveAstIds.this.ast_elemTypes.put(node, "P" + name);
                    }
                }
            }
        });
    }

    public void defaultcase(Node node) {
        if (node instanceof Token) {
            Token t = (Token)node;
            this.lastLine = t.getLine();
            this.lastPos = t.getPos() + t.getText().length();
        }
    }

    private static void error(Token token, String name) {
        throw new RuntimeException("[" + token.getLine() + "," + token.getPos() + "] " + "Redefinition of " + name + ".");
    }

    private void error(String name) {
        throw new RuntimeException("[" + this.lastLine + "," + this.lastPos + "] " + "Redefinition of " + name + ".");
    }

    private static void error2(Token token, String name) {
        throw new RuntimeException("[" + token.getLine() + "," + token.getPos() + "] " + name + " undefined. If it is a production, It should be defined in AST section");
    }

    private static void error3(Token token, String name) {
        throw new RuntimeException("[" + token.getLine() + "," + token.getPos() + "] " + name + " is ignored.");
    }

    private static void error4(Token token, String name) {
        throw new RuntimeException("[" + token.getLine() + "," + token.getPos() + "] " + "ambiguous " + name + ".");
    }

    private static void error5(Token token) {
        throw new RuntimeException("[" + token.getLine() + "," + token.getPos() + "] " + "class is an invalid element name.");
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        String nl = System.getProperty("line.separator");
        s.append("Productions:");
        s.append(nl);
        s.append(this.ast_prods);
        s.append(nl);
        s.append("Alternatives:");
        s.append(nl);
        s.append(this.ast_alts);
        s.append(nl);
        s.append("Elements:");
        s.append(nl);
        s.append(this.ast_elems);
        s.append(nl);
        return s.toString();
    }
}

