/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Logger {
    public static final Logger global = Logger.getLogger("global");
    private final String name;
    private String resourceBundleName;
    private ResourceBundle resourceBundle;
    private Filter filter;
    private final List handlerList;
    private Handler[] handlers;
    private boolean anonymous;
    private boolean useParentHandlers;
    private Level level;
    private Logger parent;

    public static Logger getLogger(String name) {
        return Logger.getLogger(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Logger getLogger(String name, String resourceBundleName) {
        LogManager lm = LogManager.getLogManager();
        name.getClass();
        LogManager logManager = lm;
        synchronized (logManager) {
            Logger result;
            block7: {
                block6: {
                    result = lm.getLogger(name);
                    if (result != null) break block6;
                    result = new Logger(name, resourceBundleName);
                    boolean couldBeAdded = lm.addLogger(result);
                    if (!couldBeAdded) {
                        throw new IllegalStateException("cannot register new logger");
                    }
                    break block7;
                }
                String existingBundleName = result.getResourceBundleName();
                if (existingBundleName == null && resourceBundleName != null) {
                    result.resourceBundle = ResourceBundle.getBundle(resourceBundleName);
                    result.resourceBundleName = resourceBundleName;
                    return result;
                }
                if (!(existingBundleName == resourceBundleName || existingBundleName != null && existingBundleName.equals(resourceBundleName))) {
                    throw new IllegalArgumentException();
                }
            }
            return result;
        }
    }

    public static Logger getAnonymousLogger() {
        return Logger.getAnonymousLogger(null);
    }

    public static Logger getAnonymousLogger(String resourceBundleName) throws MissingResourceException {
        Logger result = new Logger(null, resourceBundleName);
        result.anonymous = true;
        return result;
    }

    public synchronized String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public synchronized ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public synchronized Level getLevel() {
        return this.level;
    }

    public synchronized boolean isLoggable(Level level) {
        if (this.level != null) {
            boolean bl = false;
            if (this.level.intValue() <= level.intValue()) {
                bl = true;
            }
            return bl;
        }
        if (this.parent != null) {
            return this.parent.isLoggable(level);
        }
        return false;
    }

    public synchronized void setLevel(Level level) {
        if (!this.anonymous) {
            LogManager.getLogManager().checkAccess();
        }
        this.level = level;
    }

    public synchronized Filter getFilter() {
        return this.filter;
    }

    public synchronized void setFilter(Filter filter) throws SecurityException {
        if (!this.anonymous) {
            LogManager.getLogManager().checkAccess();
        }
        this.filter = filter;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void log(LogRecord record) {
        if (!this.isLoggable(record.getLevel())) {
            return;
        }
        if (this.filter != null && !this.filter.isLoggable(record)) {
            return;
        }
        if (record.getLoggerName() == null) {
            record.setLoggerName(this.name);
        }
        LogManager logManager = LogManager.getLogManager();
        synchronized (logManager) {
            Logger curLogger = this;
            do {
                int i = 0;
                while (i < curLogger.handlers.length) {
                    curLogger.handlers[i].publish(record);
                    ++i;
                }
                if (!curLogger.getUseParentHandlers()) break;
                curLogger = curLogger.getParent();
            } while (this.parent != null);
            return;
        }
    }

    public void log(Level level, String message) {
        if (this.isLoggable(level)) {
            this.log(level, message, (Object[])null);
        }
    }

    public synchronized void log(Level level, String message, Object param) {
        if (this.isLoggable(level)) {
            StackTraceElement caller = this.getCallerStackFrame();
            this.logp(level, caller != null ? caller.getClassName() : "<unknown>", caller != null ? caller.getMethodName() : "<unknown>", message, param);
        }
    }

    public synchronized void log(Level level, String message, Object[] params) {
        if (this.isLoggable(level)) {
            StackTraceElement caller = this.getCallerStackFrame();
            this.logp(level, caller != null ? caller.getClassName() : "<unknown>", caller != null ? caller.getMethodName() : "<unknown>", message, params);
        }
    }

    public synchronized void log(Level level, String message, Throwable thrown) {
        if (this.isLoggable(level)) {
            StackTraceElement caller = this.getCallerStackFrame();
            this.logp(level, caller != null ? caller.getClassName() : "<unknown>", caller != null ? caller.getMethodName() : "<unknown>", message, thrown);
        }
    }

    public synchronized void logp(Level level, String sourceClass, String sourceMethod, String message) {
        this.logp(level, sourceClass, sourceMethod, message, (Object[])null);
    }

    public synchronized void logp(Level level, String sourceClass, String sourceMethod, String message, Object param) {
        this.logp(level, sourceClass, sourceMethod, message, new Object[]{param});
    }

    private final synchronized ResourceBundle findResourceBundle() {
        if (this.resourceBundle != null) {
            return this.resourceBundle;
        }
        if (this.parent != null) {
            return this.parent.findResourceBundle();
        }
        return null;
    }

    private final synchronized void logImpl(Level level, String sourceClass, String sourceMethod, String message, Object[] params) {
        LogRecord rec = new LogRecord(level, message);
        rec.setResourceBundle(this.findResourceBundle());
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        rec.setParameters(params);
        this.log(rec);
    }

    public synchronized void logp(Level level, String sourceClass, String sourceMethod, String message, Object[] params) {
        this.logImpl(level, sourceClass, sourceMethod, message, params);
    }

    public synchronized void logp(Level level, String sourceClass, String sourceMethod, String message, Throwable thrown) {
        LogRecord rec = new LogRecord(level, message);
        rec.setResourceBundle(this.resourceBundle);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        rec.setThrown(thrown);
        this.log(rec);
    }

    public synchronized void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String message) {
        this.logrb(level, sourceClass, sourceMethod, bundleName, message, (Object[])null);
    }

    public synchronized void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String message, Object param) {
        this.logrb(level, sourceClass, sourceMethod, bundleName, message, new Object[]{param});
    }

    public synchronized void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String message, Object[] params) {
        LogRecord rec = new LogRecord(level, message);
        rec.setResourceBundleName(bundleName);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        rec.setParameters(params);
        this.log(rec);
    }

    public synchronized void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String message, Throwable thrown) {
        LogRecord rec = new LogRecord(level, message);
        rec.setResourceBundleName(bundleName);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        rec.setThrown(thrown);
        this.log(rec);
    }

    public synchronized void entering(String sourceClass, String sourceMethod) {
        if (this.isLoggable(Level.FINER)) {
            this.logp(Level.FINER, sourceClass, sourceMethod, "ENTRY");
        }
    }

    public synchronized void entering(String sourceClass, String sourceMethod, Object param) {
        if (this.isLoggable(Level.FINER)) {
            this.logp(Level.FINER, sourceClass, sourceMethod, "ENTRY {0}", param);
        }
    }

    public synchronized void entering(String sourceClass, String sourceMethod, Object[] params) {
        if (this.isLoggable(Level.FINER)) {
            StringBuffer buf = new StringBuffer(80);
            buf.append("ENTRY");
            int i = 0;
            while (i < params.length) {
                buf.append(" {");
                buf.append(i);
                buf.append('}');
                ++i;
            }
            this.logp(Level.FINER, sourceClass, sourceMethod, buf.toString(), params);
        }
    }

    public synchronized void exiting(String sourceClass, String sourceMethod) {
        if (this.isLoggable(Level.FINER)) {
            this.logp(Level.FINER, sourceClass, sourceMethod, "RETURN");
        }
    }

    public synchronized void exiting(String sourceClass, String sourceMethod, Object result) {
        if (this.isLoggable(Level.FINER)) {
            this.logp(Level.FINER, sourceClass, sourceMethod, "RETURN {0}", result);
        }
    }

    public synchronized void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        if (this.isLoggable(Level.FINER)) {
            this.logp(Level.FINER, sourceClass, sourceMethod, "THROW", thrown);
        }
    }

    public synchronized void severe(String message) {
        if (this.isLoggable(Level.SEVERE)) {
            this.log(Level.SEVERE, message);
        }
    }

    public synchronized void warning(String message) {
        if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, message);
        }
    }

    public synchronized void info(String message) {
        if (this.isLoggable(Level.INFO)) {
            this.log(Level.INFO, message);
        }
    }

    public synchronized void config(String message) {
        if (this.isLoggable(Level.CONFIG)) {
            this.log(Level.CONFIG, message);
        }
    }

    public synchronized void fine(String message) {
        if (this.isLoggable(Level.FINE)) {
            this.log(Level.FINE, message);
        }
    }

    public synchronized void finer(String message) {
        if (this.isLoggable(Level.FINER)) {
            this.log(Level.FINER, message);
        }
    }

    public synchronized void finest(String message) {
        if (this.isLoggable(Level.FINEST)) {
            this.log(Level.FINEST, message);
        }
    }

    public synchronized void addHandler(Handler handler) throws SecurityException {
        handler.getClass();
        if (!this.anonymous) {
            LogManager.getLogManager().checkAccess();
        }
        if (!this.handlerList.contains(handler)) {
            this.handlerList.add(handler);
            this.handlers = this.getHandlers();
        }
    }

    public synchronized void removeHandler(Handler handler) throws SecurityException {
        if (!this.anonymous) {
            LogManager.getLogManager().checkAccess();
        }
        handler.getClass();
        this.handlerList.remove(handler);
        this.handlers = this.getHandlers();
    }

    public synchronized Handler[] getHandlers() {
        return (Handler[])this.handlerList.toArray(new Handler[this.handlerList.size()]);
    }

    public synchronized boolean getUseParentHandlers() {
        return this.useParentHandlers;
    }

    public synchronized void setUseParentHandlers(boolean useParentHandlers) {
        if (!this.anonymous) {
            LogManager.getLogManager().checkAccess();
        }
        this.useParentHandlers = useParentHandlers;
    }

    public synchronized Logger getParent() {
        return this.parent;
    }

    public synchronized void setParent(Logger parent) {
        parent.getClass();
        LogManager lm = LogManager.getLogManager();
        if (this == lm.rootLogger) {
            throw new IllegalArgumentException("only the root logger can have a null parent");
        }
        if (!this.anonymous) {
            LogManager.getLogManager().checkAccess();
        }
        this.parent = parent;
    }

    private final StackTraceElement getCallerStackFrame() {
        Throwable t = new Throwable();
        StackTraceElement[] stackTrace = t.getStackTrace();
        int index = 0;
        while (index < stackTrace.length && !stackTrace[index].getClassName().equals(this.getClass().getName())) {
            ++index;
        }
        while (index < stackTrace.length && stackTrace[index].getClassName().equals(this.getClass().getName())) {
            ++index;
        }
        return index < stackTrace.length ? stackTrace[index] : null;
    }

    void resetLogger() {
        int i = 0;
        while (i < this.handlers.length) {
            this.handlers[i].close();
            this.handlerList.remove(this.handlers[i]);
            ++i;
        }
        this.handlers = this.getHandlers();
    }

    private final /* synthetic */ void this() {
        this.handlerList = new ArrayList(4);
        this.handlers = new Handler[0];
    }

    protected Logger(String name, String resourceBundleName) throws MissingResourceException {
        this.this();
        this.name = name;
        this.resourceBundleName = resourceBundleName;
        this.resourceBundle = resourceBundleName == null ? null : ResourceBundle.getBundle(resourceBundleName);
        this.level = null;
        this.parent = LogManager.getLogManager().rootLogger;
        boolean bl = false;
        if (this.parent != null) {
            bl = true;
        }
        this.useParentHandlers = bl;
    }
}

