/*
Copyright (C) 2003, Nik Reiman - nik@aboleo.net

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/****
  Functions, structures, and global variables common to pretty much every module in the UBS system.
****/

/*+ Needed for the cur_time structure +*/
#include <stdio.h>
#include <time.h>

#ifdef HAVE_DIRENT_H
#include <dirent.h>
#endif

#include "defaults.h"

// Global Defines

/*+ Win32 compatibility crap +*/
#ifdef WIN32
#define bzero ZeroMemory
#define sleep Sleep
#endif

/*+ Maximum abount of arguments the command line is willing to deal with +*/
#define MAXARGS 32

// various buffer sizes
#define SMALLBUF 32	// small strings
#define STRBUF 128	// will do for most buffer strings
#define BIGSTR 512	// bigger string
#define FILEBUF 1024	// longest permissable filename size
#define BIGBUF 4096	// call in the calvary

// output modes
#define ENGLISH 0
#define CSV 1
#define HTML 2
#define SILENT 3

// useful stuff
#define YES 1
#define NO 0
#define TRUE 1
#define FALSE 0

// HTML coloring codes
#define COLOR1 "#ffffff"
#define COLOR2 "#cccccc"

// Error codes
#define OK 0
#define FAIL -1
#define NO_FILE -2
#define NO_DIR -3
#define NO_FORK -4
#define NO_PERMS -5
#define NO_SIGNAL -6
#define NO_MEM -7
#define QUIT -8

// Logging levels
#define LOG_EMERG 0
#define LOG_STATUS 1
#define LOG_ERROR 2
#define LOG_DEBUG 3

// Data structures
#ifndef _UBS_DATA_STRUCTS
#define _UBS_DATA_STRUCTS

// data for the media file
struct media_tag
{
 char title[STRBUF];
 char artist[STRBUF];
 char album[STRBUF]; // maybe we'll need this later...
};

// the format for the logfiles
struct log_entry
{
 char date[6];
 char time[6];
 char field1[BIGBUF]; // filename or process name
 char field2[BIGBUF]; // artist name or warning level
 char field3[BIGBUF]; // song name or error message
};

// the format of the config file...kind of a poor man's hash here
struct conf_arg
{
 char directive[STRBUF]; // the name of the directive parsed
 char argument[STRBUF]; // and the argument that corresponds to it
};

struct _keypair {
 char key[STRBUF];
 char value[BIGSTR];
};
typedef struct _keypair keypair;

struct _ubs_table
{
 int num_values;
 keypair *values;
};
typedef struct _ubs_table ubs_table;

#endif

// Global Variables
#ifndef _UBS_GLOBAL_VARS
#define _UBS_GLOBAL_VARS

char PROCNAME[STRBUF];
struct tm *CUR_TIME;
ubs_table GLOBAL;
int LOGLEVEL;

#endif

// shared functions 

// table.c
int ubs_table_init(ubs_table *t);
int ubs_table_add(ubs_table *t, char *key, char *value);
char *ubs_table_data(ubs_table *t, char *key);
int ubs_table_change(ubs_table *t, char *key, char *newval);
int ubs_table_exists(ubs_table *t, char *key);

// logging.c
void gettime(void);
void get_time(char *fmt_time);
void get_date(char *fmt_time);
int record_pid(int pid);
int record_status(char *msg);
int log_error_msg(int priority, char *msg, ...);
int log_event(char *logfile, char *field1, char *field2, char *field3, int priority);
int write_log(struct log_entry *entry, char *logfile);
int read_log(struct log_entry *entry, char *logbuf);
int print_log(struct log_entry *entry, int mode);
void console_error(char *message, int signal);
void console_warning(char *message);

// common.c
void version(void);
void sig_poll(int sig);
void sig_quit(int sig);
int ubs_init(char *pname);
void set_defaults(void);
int check_running(void);

// music_info.c
int get_media_tag(char *sname, struct media_tag *song_tag);
int get_ogg_tag(char *sname, struct media_tag *song_tag);
int get_mp3_tag(char *sname, struct media_tag *song_tag);
int check_against_tags(char *file1, char *file2);

// get_song.c
int get_song(char *sname);
int make_cache(char *path);
int parse_dir(FILE *fp, char *path);
int check_against_log(char *filename, char *logfile, int backnum);
int check_against_queue(char *filename);
int check_against_cur(char *filename);

// read_config.c
int read_config(char *fname, char *section, ubs_table *table);

// parse_line.c
int parse_line(char *line_buf, char *directive, char *argument);
int weed_white(char *str);
int blank(char ch);
int ubs_strcasestr(char *haystack, char *needle);
void chomp_line(char *line);
int split_line(char ** dest_arr, char *line, int max);

// queue.c
void queue_pop(char *str);
void queue_chop(void);
void queue_init(void);
int queue_length(void);
int queue_push(char *filename);
int queue_prepush(char *filename);

// exec_proc.c
int ping_pid(char *target);
int exec_proc(char *command, char *subarg);
