/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.util;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LineInputStream
extends FilterInputStream {
    private ByteArrayOutputStream buf = new ByteArrayOutputStream();
    private String encoding;
    private boolean eof;
    private final boolean blockReads;

    public String readLine() throws IOException {
        if (this.eof) {
            return null;
        }
        while (true) {
            if (this.blockReads) {
                int n = this.in.available();
                n = n < 1024 ? 1024 : n;
                byte[] byArray = new byte[n];
                this.in.mark(n);
                n = this.in.read(byArray, 0, n);
                if (n == -1) {
                    this.eof = true;
                    if (this.buf.size() == 0) {
                        return null;
                    }
                    return this.buf.toString(this.encoding);
                }
                int n2 = this.indexOf(byArray, n, (byte)10);
                if (n2 != -1) {
                    this.buf.write(byArray, 0, n2);
                    this.in.reset();
                    ++n2;
                    while (n2 > 0) {
                        n = this.in.read(byArray, 0, n2);
                        int n3 = n2 = n == -1 ? -1 : n2 - n;
                    }
                    String string = this.buf.toString(this.encoding);
                    this.buf.reset();
                    return string;
                }
                this.buf.write(byArray, 0, n);
                continue;
            }
            int n = this.in.read();
            switch (n) {
                case -1: {
                    this.eof = true;
                    if (this.buf.size() == 0) {
                        return null;
                    }
                }
                case 10: {
                    String string = this.buf.toString(this.encoding);
                    this.buf.reset();
                    return string;
                }
            }
            this.buf.write(n);
        }
    }

    private final int indexOf(byte[] byArray, int n, byte by) {
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] == by) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public LineInputStream(InputStream inputStream) {
        this(inputStream, "US-ASCII");
    }

    public LineInputStream(InputStream inputStream, String string) {
        super(inputStream);
        this.encoding = string;
        this.eof = false;
        this.blockReads = inputStream.markSupported();
    }
}

