/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class GdkGlyphVector
extends GlyphVector {
    double[] extents;
    int[] codes;
    Font font;
    FontRenderContext fontRenderContext;
    Rectangle2D allLogical;
    Rectangle2D allVisual;

    public double[] getExtents() {
        return this.extents;
    }

    public int[] getCodes() {
        return this.codes;
    }

    public Font getFont() {
        return this.font;
    }

    public FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }

    public int getGlyphCharIndex(int n) {
        return n;
    }

    public int[] getGlyphCharIndices(int n, int n2, int[] nArray) {
        int[] nArray2 = nArray;
        if (nArray2 == null) {
            nArray2 = new int[n2];
        }
        int n3 = 0;
        while (n3 < n2) {
            nArray2[n3] = this.getGlyphCharIndex(n + n3);
            ++n3;
        }
        return nArray2;
    }

    public int getGlyphCode(int n) {
        return this.codes[n];
    }

    public int[] getGlyphCodes(int n, int n2, int[] nArray) {
        if (nArray == null) {
            nArray = new int[n2];
        }
        System.arraycopy(this.codes, n, nArray, 0, n2);
        return nArray;
    }

    public Shape getGlyphLogicalBounds(int n) {
        return new Rectangle2D.Double(this.extents[8 * n], this.extents[8 * n + 1], this.extents[8 * n + 2], this.extents[8 * n + 3]);
    }

    public GlyphMetrics getGlyphMetrics(int n) {
        boolean bl = true;
        double d = this.extents[8 * n + 2];
        double d2 = 0.0;
        return new GlyphMetrics(bl, (float)d, (float)d2, (Rectangle2D)this.getGlyphVisualBounds(n), 0);
    }

    public Shape getGlyphOutline(int n) {
        throw new UnsupportedOperationException();
    }

    public Shape getGlyphOutline(int n, float f, float f2) {
        throw new UnsupportedOperationException();
    }

    public Rectangle getGlyphPixelBounds(int n, FontRenderContext fontRenderContext, float f, float f2) {
        return new Rectangle((int)f, (int)f2, (int)this.extents[8 * n + 6], (int)this.extents[8 * n + 7]);
    }

    public Point2D getGlyphPosition(int n) {
        return new Point2D.Double(this.extents[10 * n + 8], this.extents[10 * n + 9]);
    }

    public float[] getGlyphPositions(int n, int n2, float[] fArray) {
        float[] fArray2 = fArray;
        if (fArray2 == null) {
            fArray2 = new float[n2 * 2];
        }
        int n3 = 0;
        while (n3 < n2) {
            fArray2[2 * n3] = (float)this.extents[10 * n3 + 8];
            fArray2[2 * n3 + 1] = (float)this.extents[10 * n3 + 9];
            ++n3;
        }
        return fArray2;
    }

    public AffineTransform getGlyphTransform(int n) {
        return null;
    }

    public Shape getGlyphVisualBounds(int n) {
        return new Rectangle2D.Double(this.extents[8 * n + 4], this.extents[8 * n + 5], this.extents[8 * n + 6], this.extents[8 * n + 7]);
    }

    public int getLayoutFlags() {
        return 0;
    }

    public Rectangle2D getLogicalBounds() {
        return this.allLogical;
    }

    public int getNumGlyphs() {
        return this.codes.length;
    }

    public Shape getOutline() {
        throw new UnsupportedOperationException();
    }

    public Rectangle getPixelBounds(FontRenderContext fontRenderContext, float f, float f2) {
        return new Rectangle((int)f, (int)f2, (int)this.allVisual.getWidth(), (int)this.allVisual.getHeight());
    }

    public Rectangle2D getVisualBounds() {
        return this.allVisual;
    }

    public void performDefaultLayout() {
    }

    public void setGlyphPosition(int n, Point2D point2D) {
        this.extents[8 * n] = point2D.getX();
        this.extents[8 * n + 1] = point2D.getY();
        this.extents[8 * n + 4] = point2D.getX();
        this.extents[8 * n + 5] = point2D.getY();
    }

    public void setGlyphTransform(int n, AffineTransform affineTransform) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(GlyphVector glyphVector) {
        if (glyphVector == null) {
            return false;
        }
        if (!(glyphVector instanceof GdkGlyphVector)) {
            return false;
        }
        GdkGlyphVector gdkGlyphVector = (GdkGlyphVector)glyphVector;
        if (gdkGlyphVector.codes.length != this.codes.length || gdkGlyphVector.extents.length != this.extents.length) {
            return false;
        }
        if (gdkGlyphVector.font == null && this.font != null || gdkGlyphVector.font != null && this.font == null || !gdkGlyphVector.font.equals(this.font)) {
            return false;
        }
        if (gdkGlyphVector.fontRenderContext == null && this.fontRenderContext != null || gdkGlyphVector.fontRenderContext != null && this.fontRenderContext == null || !gdkGlyphVector.fontRenderContext.equals(this.fontRenderContext)) {
            return false;
        }
        int n = 0;
        while (n < gdkGlyphVector.codes.length) {
            if (gdkGlyphVector.codes[n] != this.codes[n]) {
                return false;
            }
            ++n;
        }
        n = 0;
        while (n < gdkGlyphVector.extents.length) {
            if (gdkGlyphVector.extents[n] != this.extents[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public GlyphJustificationInfo getGlyphJustificationInfo(int n) {
        throw new UnsupportedOperationException();
    }

    public Shape getOutline(float f, float f2) {
        throw new UnsupportedOperationException();
    }

    public GdkGlyphVector(double[] dArray, int[] nArray, Font font, FontRenderContext fontRenderContext) {
        this.extents = dArray;
        this.codes = nArray;
        this.font = font;
        this.fontRenderContext = fontRenderContext;
        this.allLogical = new Rectangle2D.Double();
        this.allVisual = new Rectangle2D.Double();
        int n = 0;
        while (n < nArray.length) {
            this.allLogical.add(new Rectangle2D.Double(dArray[10 * n] + dArray[10 * n + 8], dArray[10 * n + 1] + dArray[10 * n + 9], dArray[10 * n + 2], dArray[10 * n + 3]));
            this.allVisual.add(new Rectangle2D.Double(dArray[10 * n + 4] + dArray[10 * n + 8], dArray[10 * n + 5] + dArray[10 * n + 9], dArray[10 * n + 6], dArray[10 * n + 7]));
            ++n;
        }
    }
}

