require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&FUSE_H_)) {
    eval 'sub FUSE_H_ () {20211204;}' unless defined(&FUSE_H_);
    require 'fcntl.ph';
    require 'fuse_opt.ph';
    require 'refuse/buf.ph';
    require 'refuse/chan.ph';
    require 'refuse/legacy.ph';
    require 'refuse/poll.ph';
    require 'refuse/session.ph';
    require 'sys/cdefs.ph';
    require 'sys/stat.ph';
    require 'sys/statvfs.ph';
    require 'sys/types.ph';
    require 'utime.ph';
    eval 'sub FUSE_MAKE_VERSION {
        my($maj, $min) = @_;
	    eval q(((($maj) > 3|| (($maj) == 3 && ($min) >= 10)) ? ($maj) * 100+ ($min) : ($maj) * 10+ ($min)));
    }' unless defined(&FUSE_MAKE_VERSION);
    eval 'sub _REFUSE_MAJOR_VERSION_ () {3;}' unless defined(&_REFUSE_MAJOR_VERSION_);
    eval 'sub _REFUSE_MINOR_VERSION_ () {10;}' unless defined(&_REFUSE_MINOR_VERSION_);
    eval 'sub _REFUSE_VERSION_ () { &FUSE_MAKE_VERSION( &_REFUSE_MAJOR_VERSION_,  &_REFUSE_MINOR_VERSION_);}' unless defined(&_REFUSE_VERSION_);
    if(defined(&FUSE_USE_VERSION)) {
	if((defined(&FUSE_USE_VERSION) ? &FUSE_USE_VERSION : undef) > (defined(&_REFUSE_VERSION_) ? &_REFUSE_VERSION_ : undef)) {
	    warn("\"The\ requested\ API\ version\ is\ higher\ than\ the\ latest\ one\ supported\ by\ refuse\.\"");
	}
 elsif((defined(&FUSE_USE_VERSION) ? &FUSE_USE_VERSION : undef) < 11) {
	    warn("\"The\ requested\ API\ version\ is\ lower\ than\ the\ oldest\ one\ supported\ by\ refuse\.\"");
	}
    } else {
	if(!defined(&_REFUSE_IMPLEMENTATION_)) {
	    warn("\"User\ code\ including\ \<fuse\.h\>\ should\ define\ FUSE_USE_VERSION\ before\ including\ this\ header\.\ Defaulting\ to\ the\ latest\ version\.\"");
	    eval 'sub FUSE_USE_VERSION () { &_REFUSE_VERSION_;}' unless defined(&FUSE_USE_VERSION);
	}
    }
    if(defined(&FUSE_USE_VERSION)) {
	eval 'sub FUSE_VERSION () { &FUSE_USE_VERSION;}' unless defined(&FUSE_VERSION);
	eval 'sub FUSE_MAJOR_VERSION () {( &FUSE_VERSION / 10);}' unless defined(&FUSE_MAJOR_VERSION);
	eval 'sub FUSE_MINOR_VERSION () {( &FUSE_VERSION % 10);}' unless defined(&FUSE_MINOR_VERSION);
    }
    if(defined(&__cplusplus)) {
    }
    eval 'sub FUSE_CAP_ASYNC_READ () {(1<< 0);}' unless defined(&FUSE_CAP_ASYNC_READ);
    eval 'sub FUSE_CAP_POSIX_LOCKS () {(1<< 1);}' unless defined(&FUSE_CAP_POSIX_LOCKS);
    eval 'sub FUSE_CAP_ATOMIC_O_TRUNC () {(1<< 3);}' unless defined(&FUSE_CAP_ATOMIC_O_TRUNC);
    eval 'sub FUSE_CAP_EXPORT_SUPPORT () {(1<< 4);}' unless defined(&FUSE_CAP_EXPORT_SUPPORT);
    eval 'sub FUSE_CAP_BIG_WRITES () {(1<< 5);}' unless defined(&FUSE_CAP_BIG_WRITES);
    eval 'sub FUSE_CAP_DONT_MASK () {(1<< 6);}' unless defined(&FUSE_CAP_DONT_MASK);
    eval 'sub FUSE_CAP_SPLICE_WRITE () {(1<< 7);}' unless defined(&FUSE_CAP_SPLICE_WRITE);
    eval 'sub FUSE_CAP_SPLICE_MOVE () {(1<< 8);}' unless defined(&FUSE_CAP_SPLICE_MOVE);
    eval 'sub FUSE_CAP_SPLICE_READ () {(1<< 9);}' unless defined(&FUSE_CAP_SPLICE_READ);
    eval 'sub FUSE_CAP_FLOCK_LOCKS () {(1<< 10);}' unless defined(&FUSE_CAP_FLOCK_LOCKS);
    eval 'sub FUSE_CAP_IOCTL_DIR () {(1<< 11);}' unless defined(&FUSE_CAP_IOCTL_DIR);
    eval 'sub FUSE_CAP_AUTO_INVAL_DATA () {(1<< 12);}' unless defined(&FUSE_CAP_AUTO_INVAL_DATA);
    eval 'sub FUSE_CAP_READDIRPLUS () {(1<< 13);}' unless defined(&FUSE_CAP_READDIRPLUS);
    eval 'sub FUSE_CAP_READDIRPLUS_AUTO () {(1<< 14);}' unless defined(&FUSE_CAP_READDIRPLUS_AUTO);
    eval 'sub FUSE_CAP_ASYNC_DIO () {(1<< 15);}' unless defined(&FUSE_CAP_ASYNC_DIO);
    eval 'sub FUSE_CAP_WRITEBACK_CACHE () {(1<< 16);}' unless defined(&FUSE_CAP_WRITEBACK_CACHE);
    eval 'sub FUSE_CAP_NO_OPEN_SUPPORT () {(1<< 17);}' unless defined(&FUSE_CAP_NO_OPEN_SUPPORT);
    eval 'sub FUSE_CAP_PARALLEL_DIROPS () {(1<< 18);}' unless defined(&FUSE_CAP_PARALLEL_DIROPS);
    eval 'sub FUSE_CAP_POSIX_ACL () {(1<< 19);}' unless defined(&FUSE_CAP_POSIX_ACL);
    eval 'sub FUSE_CAP_HANDLE_KILLPRIV () {(1<< 20);}' unless defined(&FUSE_CAP_HANDLE_KILLPRIV);
    eval 'sub FUSE_CAP_CACHE_SYMLINKS () {(1<< 23);}' unless defined(&FUSE_CAP_CACHE_SYMLINKS);
    eval 'sub FUSE_CAP_NO_OPENDIR_SUPPORT () {(1<< 24);}' unless defined(&FUSE_CAP_NO_OPENDIR_SUPPORT);
    eval 'sub FUSE_IOCTL_COMPAT () {(1<< 0);}' unless defined(&FUSE_IOCTL_COMPAT);
    eval 'sub FUSE_IOCTL_UNRESTRICTED () {(1<< 1);}' unless defined(&FUSE_IOCTL_UNRESTRICTED);
    eval 'sub FUSE_IOCTL_RETRY () {(1<< 2);}' unless defined(&FUSE_IOCTL_RETRY);
    eval 'sub FUSE_IOCTL_DIR () {(1<< 4);}' unless defined(&FUSE_IOCTL_DIR);
    eval 'sub FUSE_IOCTL_MAX_IOV () {256;}' unless defined(&FUSE_IOCTL_MAX_IOV);
    eval("sub FUSE_READDIR_PLUS () { (1<<0); }") unless defined(&FUSE_READDIR_PLUS);
    eval("sub FUSE_FILL_DIR_PLUS () { (1<<1); }") unless defined(&FUSE_FILL_DIR_PLUS);
    eval 'sub FUSE_ARGS_INIT {
        my($argc, $argv) = @_;
	    eval q({ $argc, $argv, 0});
    }' unless defined(&FUSE_ARGS_INIT);
    require 'refuse/v11.ph';
    require 'refuse/v21.ph';
    require 'refuse/v22.ph';
    require 'refuse/v23.ph';
    require 'refuse/v25.ph';
    require 'refuse/v26.ph';
    require 'refuse/v28.ph';
    require 'refuse/v29.ph';
    require 'refuse/v30.ph';
    require 'refuse/v32.ph';
    require 'refuse/v34.ph';
    require 'refuse/v35.ph';
    require 'refuse/v38.ph';
    require 'refuse/fs.ph';
    eval 'sub _MK_FUSE_OPERATIONS_ {
        my($VER) = @_;
	    eval q( &__CONCAT( &fuse_operations_v,$VER));
    }' unless defined(&_MK_FUSE_OPERATIONS_);
    if(defined(&FUSE_USE_VERSION)) {
	if((defined(&FUSE_USE_VERSION) ? &FUSE_USE_VERSION : undef) < 21) {
	    eval 'sub _FUSE_OP_VERSION__ () {11;}' unless defined(&_FUSE_OP_VERSION__);
	    eval 'sub fuse_dirfil_t () { &fuse_dirfil_t_v11;}' unless defined(&fuse_dirfil_t);
	    eval 'sub fuse_operations () { &_MK_FUSE_OPERATIONS_( &_FUSE_OP_VERSION__);}' unless defined(&fuse_operations);
	    eval 'sub fuse_mount () { &fuse_mount_v11;}' unless defined(&fuse_mount);
	    eval 'sub fuse_unmount () { &fuse_unmount_v11;}' unless defined(&fuse_unmount);
	    eval 'sub fuse_new {
	        my($fd,$flags,$op) = @_;
    		eval q({  &fuse_new_v11($fd, $flags, $op,  &_FUSE_OP_VERSION__); });
	    }' unless defined(&fuse_new);
	    eval 'sub fuse_destroy () { &fuse_destroy_v11;}' unless defined(&fuse_destroy);
	    eval 'sub fuse_loop_mt () { &fuse_loop_mt_v11;}' unless defined(&fuse_loop_mt);
	}
 elsif((defined(&FUSE_USE_VERSION) ? &FUSE_USE_VERSION : undef) == 21) {
	    eval 'sub _FUSE_OP_VERSION__ () {21;}' unless defined(&_FUSE_OP_VERSION__);
	    eval 'sub fuse_dirfil_t () { &fuse_dirfil_t_v11;}' unless defined(&fuse_dirfil_t);
	    eval 'sub fuse_operations () { &_MK_FUSE_OPERATIONS_( &_FUSE_OP_VERSION__);}' unless defined(&fuse_operations);
	    eval 'sub fuse_mount () { &fuse_mount_v21;}' unless defined(&fuse_mount);
	    eval 'sub fuse_unmount () { &fuse_unmount_v11;}' unless defined(&fuse_unmount);
	    eval 'sub fuse_new {
	        my($fd,$opts,$op) = @_;
    		eval q({  &fuse_new_v21($fd, $opts, $op,  &_FUSE_OP_VERSION__,  &NULL); });
	    }' unless defined(&fuse_new);
	    eval 'sub fuse_destroy () { &fuse_destroy_v11;}' unless defined(&fuse_destroy);
	    eval 'sub fuse_loop_mt () { &fuse_loop_mt_v11;}' unless defined(&fuse_loop_mt);
	}
 elsif((defined(&FUSE_USE_VERSION) ? &FUSE_USE_VERSION : undef) == 22) {
	    eval 'sub _FUSE_OP_VERSION__ () {22;}' unless defined(&_FUSE_OP_VERSION__);
	    eval 'sub fuse_dirfil_t () { &fuse_dirfil_t_v22;}' unless defined(&fuse_dirfil_t);
	    eval 'sub fuse_operations () { &_MK_FUSE_OPERATIONS_( &_FUSE_OP_VERSION__);}' unless defined(&fuse_operations);
	    eval 'sub fuse_mount () { &fuse_mount_v21;}' unless defined(&fuse_mount);
	    eval 'sub fuse_unmount () { &fuse_unmount_v11;}' unless defined(&fuse_unmount);
	    eval 'sub fuse_new {
	        my($fd,$opts,$op) = @_;
    		eval q({  &fuse_new_v21($fd, $opts, $op,  &_FUSE_OP_VERSION__,  &NULL); });
	    }' unless defined(&fuse_new);
	    eval 'sub fuse_destroy () { &fuse_destroy_v11;}' unless defined(&fuse_destroy);
	    eval 'sub fuse_loop_mt () { &fuse_loop_mt_v11;}' unless defined(&fuse_loop_mt);
	    eval 'sub fuse_setup () {
	        eval q((\'int\'  &argc, \'char\' * $argv[],  &const \'struct fuse_operations\' * &op, \'size_t\'  &op_size  &__attribute__(( &__unused__)), \'char\' ** &mountpoint, \'int\' * &multithreaded, \'int\' * &fd) {  &fuse_setup_v22( &argc,  &argv,  &op,  &_FUSE_OP_VERSION__,  &mountpoint,  &multithreaded,  &fd); });
	    }' unless defined(&fuse_setup);
	    eval 'sub fuse_teardown () { &fuse_teardown_v22;}' unless defined(&fuse_teardown);
	}
 elsif((defined(&FUSE_USE_VERSION) ? &FUSE_USE_VERSION : undef) >= 23 && (defined(&FUSE_USE_VERSION) ? &FUSE_USE_VERSION : undef) <= 24) {
	    eval 'sub _FUSE_OP_VERSION__ () {23;}' unless defined(&_FUSE_OP_VERSION__);
	    eval 'sub fuse_dirfil_t () { &fuse_dirfil_t_v22;}' unless defined(&fuse_dirfil_t);
	    eval 'sub fuse_fill_dir_t () { &fuse_fill_dir_t_v23;}' unless defined(&fuse_fill_dir_t);
	    eval 'sub fuse_operations () { &_MK_FUSE_OPERATIONS_( &_FUSE_OP_VERSION__);}' unless defined(&fuse_operations);
	    eval 'sub fuse_mount () { &fuse_mount_v21;}' unless defined(&fuse_mount);
	    eval 'sub fuse_unmount () { &fuse_unmount_v11;}' unless defined(&fuse_unmount);
	    eval 'sub fuse_new () {
	        eval q((\'int\'  &fd,  &const \'char\' * &opts,  &const \'struct fuse_operations\' * &op, \'size_t\'  &op_size  &__attribute__(( &__unused__))) {  &fuse_new_v21( &fd,  &opts,  &op,  &_FUSE_OP_VERSION__,  &NULL); });
	    }' unless defined(&fuse_new);
	    eval 'sub fuse_destroy () { &fuse_destroy_v11;}' unless defined(&fuse_destroy);
	    eval 'sub fuse_loop_mt () { &fuse_loop_mt_v11;}' unless defined(&fuse_loop_mt);
	    eval 'sub fuse_setup () {
	        eval q((\'int\'  &argc, \'char\' * $argv[],  &const \'struct fuse_operations\' * &op, \'size_t\'  &op_size  &__attribute__(( &__unused__)), \'char\' ** &mountpoint, \'int\' * &multithreaded, \'int\' * &fd) {  &fuse_setup_v22( &argc,  &argv,  &op,  &_FUSE_OP_VERSION__,  &mountpoint,  &multithreaded,  &fd); });
	    }' unless defined(&fuse_setup);
	    eval 'sub fuse_teardown () { &fuse_teardown_v22;}' unless defined(&fuse_teardown);
	}
 elsif((defined(&FUSE_USE_VERSION) ? &FUSE_USE_VERSION : undef) == 25) {
	    eval 'sub _FUSE_OP_VERSION__ () {25;}' unless defined(&_FUSE_OP_VERSION__);
	    eval 'sub fuse_dirfil_t () { &fuse_dirfil_t_v22;}' unless defined(&fuse_dirfil_t);
	    eval 'sub fuse_fill_dir_t () { &fuse_fill_dir_t_v23;}' unless defined(&fuse_fill_dir_t);
	    eval 'sub fuse_operations () { &_MK_FUSE_OPERATIONS_( &_FUSE_OP_VERSION__);}' unless defined(&fuse_operations);
	    eval 'sub fuse_mount () { &fuse_mount_v25;}' unless defined(&fuse_mount);
	    eval 'sub fuse_unmount () { &fuse_unmount_v11;}' unless defined(&fuse_unmount);
	    eval 'sub fuse_new () {
	        eval q((\'int\'  &fd, \'struct fuse_args\' * &args,  &const \'struct fuse_operations\' * &op, \'size_t\'  &op_size  &__attribute__(( &__unused__))) {  &fuse_new_v25( &fd,  &args,  &op,  &_FUSE_OP_VERSION__,  &NULL); });
	    }' unless defined(&fuse_new);
	    eval 'sub fuse_destroy () { &fuse_destroy_v11;}' unless defined(&fuse_destroy);
	    eval 'sub fuse_loop_mt () { &fuse_loop_mt_v11;}' unless defined(&fuse_loop_mt);
	    eval 'sub fuse_setup () {
	        eval q((\'int\'  &argc, \'char\' * $argv[],  &const \'struct fuse_operations\' * &op, \'size_t\'  &op_size  &__attribute__(( &__unused__)), \'char\' ** &mountpoint, \'int\' * &multithreaded, \'int\' * &fd) {  &fuse_setup_v22( &argc,  &argv,  &op,  &_FUSE_OP_VERSION__,  &mountpoint,  &multithreaded,  &fd); });
	    }' unless defined(&fuse_setup);
	    eval 'sub fuse_teardown () { &fuse_teardown_v22;}' unless defined(&fuse_teardown);
	    eval 'sub fuse_parse_cmdline () { &fuse_parse_cmdline_v25;}' unless defined(&fuse_parse_cmdline);
	}
 elsif((defined(&FUSE_USE_VERSION) ? &FUSE_USE_VERSION : undef) >= 26 && (defined(&FUSE_USE_VERSION) ? &FUSE_USE_VERSION : undef) <= 27) {
	    eval 'sub _FUSE_OP_VERSION__ () {26;}' unless defined(&_FUSE_OP_VERSION__);
	    eval 'sub fuse_dirfil_t () { &fuse_dirfil_t_v22;}' unless defined(&fuse_dirfil_t);
	    eval 'sub fuse_fill_dir_t () { &fuse_fill_dir_t_v23;}' unless defined(&fuse_fill_dir_t);
	    eval 'sub fuse_operations () { &_MK_FUSE_OPERATIONS_( &_FUSE_OP_VERSION__);}' unless defined(&fuse_operations);
	    eval 'sub fuse_fs_getattr () { &fuse_fs_getattr_v27;}' unless defined(&fuse_fs_getattr);
	    eval 'sub fuse_fs_rename () { &fuse_fs_rename_v27;}' unless defined(&fuse_fs_rename);
	    eval 'sub fuse_fs_chmod () { &fuse_fs_chmod_v27;}' unless defined(&fuse_fs_chmod);
	    eval 'sub fuse_fs_chown () { &fuse_fs_chown_v27;}' unless defined(&fuse_fs_chown);
	    eval 'sub fuse_fs_readdir () { &fuse_fs_readdir_v27;}' unless defined(&fuse_fs_readdir);
	    eval 'sub fuse_fs_truncate () { &fuse_fs_truncate_v27;}' unless defined(&fuse_fs_truncate);
	    eval 'sub fuse_fs_utimens () { &fuse_fs_utimens_v27;}' unless defined(&fuse_fs_utimens);
	    eval 'sub fuse_fs_init () { &fuse_fs_init_v27;}' unless defined(&fuse_fs_init);
	    eval 'sub fuse_main {
	        my($argc,$op,$user_data) = @_;
    		eval q({  &__fuse_main($argc,  &argv, $op,  &_FUSE_OP_VERSION__, $user_data); });
	    }' unless defined(&fuse_main);
	    eval 'sub fuse_mount () { &fuse_mount_v26;}' unless defined(&fuse_mount);
	    eval 'sub fuse_unmount () { &fuse_unmount_v26;}' unless defined(&fuse_unmount);
	    eval 'sub fuse_new () {
	        eval q((\'struct fuse_chan\' * &ch, \'struct fuse_args\' * &args,  &const \'struct fuse_operations\' * &op, \'size_t\'  &op_size  &__attribute__(( &__unused__)),  &void * &user_data) {  &fuse_new_v26( &ch,  &args,  &op,  &_FUSE_OP_VERSION__,  &user_data); });
	    }' unless defined(&fuse_new);
	    eval 'sub fuse_destroy () { &fuse_destroy_v11;}' unless defined(&fuse_destroy);
	    eval 'sub fuse_loop_mt () { &fuse_loop_mt_v11;}' unless defined(&fuse_loop_mt);
	    eval 'sub fuse_setup () {
	        eval q((\'int\'  &argc, \'char\' * $argv[],  &const \'struct fuse_operations\' * &op, \'size_t\'  &op_size  &__attribute__(( &__unused__)), \'char\' ** &mountpoint, \'int\' * &multithreaded,  &void * &user_data) {  &fuse_setup_v26( &argc,  &argv,  &op,  &_FUSE_OP_VERSION__,  &mountpoint,  &multithreaded,  &user_data); });
	    }' unless defined(&fuse_setup);
	    eval 'sub fuse_teardown () { &fuse_teardown_v26;}' unless defined(&fuse_teardown);
	    eval 'sub fuse_parse_cmdline () { &fuse_parse_cmdline_v25;}' unless defined(&fuse_parse_cmdline);
	}
 elsif((defined(&FUSE_USE_VERSION) ? &FUSE_USE_VERSION : undef) == 28) {
	    eval 'sub _FUSE_OP_VERSION__ () {28;}' unless defined(&_FUSE_OP_VERSION__);
	    eval 'sub fuse_dirfil_t () { &fuse_dirfil_t_v22;}' unless defined(&fuse_dirfil_t);
	    eval 'sub fuse_fill_dir_t () { &fuse_fill_dir_t_v23;}' unless defined(&fuse_fill_dir_t);
	    eval 'sub fuse_operations () { &_MK_FUSE_OPERATIONS_( &_FUSE_OP_VERSION__);}' unless defined(&fuse_operations);
	    eval 'sub fuse_fs_getattr () { &fuse_fs_getattr_v27;}' unless defined(&fuse_fs_getattr);
	    eval 'sub fuse_fs_rename () { &fuse_fs_rename_v27;}' unless defined(&fuse_fs_rename);
	    eval 'sub fuse_fs_chmod () { &fuse_fs_chmod_v27;}' unless defined(&fuse_fs_chmod);
	    eval 'sub fuse_fs_chown () { &fuse_fs_chown_v27;}' unless defined(&fuse_fs_chown);
	    eval 'sub fuse_fs_readdir () { &fuse_fs_readdir_v27;}' unless defined(&fuse_fs_readdir);
	    eval 'sub fuse_fs_truncate () { &fuse_fs_truncate_v27;}' unless defined(&fuse_fs_truncate);
	    eval 'sub fuse_fs_utimens () { &fuse_fs_utimens_v27;}' unless defined(&fuse_fs_utimens);
	    eval 'sub fuse_fs_ioctl () { &fuse_fs_ioctl_v28;}' unless defined(&fuse_fs_ioctl);
	    eval 'sub fuse_fs_init () { &fuse_fs_init_v27;}' unless defined(&fuse_fs_init);
	    eval 'sub fuse_main {
	        my($argc,$op,$user_data) = @_;
    		eval q({  &__fuse_main($argc,  &argv, $op,  &_FUSE_OP_VERSION__, $user_data); });
	    }' unless defined(&fuse_main);
	    eval 'sub fuse_mount () { &fuse_mount_v26;}' unless defined(&fuse_mount);
	    eval 'sub fuse_unmount () { &fuse_unmount_v26;}' unless defined(&fuse_unmount);
	    eval 'sub fuse_new () {
	        eval q((\'struct fuse_chan\' * &ch, \'struct fuse_args\' * &args,  &const \'struct fuse_operations\' * &op, \'size_t\'  &op_size  &__attribute__(( &__unused__)),  &void * &user_data) {  &fuse_new_v26( &ch,  &args,  &op,  &_FUSE_OP_VERSION__,  &user_data); });
	    }' unless defined(&fuse_new);
	    eval 'sub fuse_destroy () { &fuse_destroy_v11;}' unless defined(&fuse_destroy);
	    eval 'sub fuse_loop_mt () { &fuse_loop_mt_v11;}' unless defined(&fuse_loop_mt);
	    eval 'sub fuse_setup () {
	        eval q((\'int\'  &argc, \'char\' * $argv[],  &const \'struct fuse_operations\' * &op, \'size_t\'  &op_size  &__attribute__(( &__unused__)), \'char\' ** &mountpoint, \'int\' * &multithreaded,  &void * &user_data) {  &fuse_setup_v26( &argc,  &argv,  &op,  &_FUSE_OP_VERSION__,  &mountpoint,  &multithreaded,  &user_data); });
	    }' unless defined(&fuse_setup);
	    eval 'sub fuse_teardown () { &fuse_teardown_v26;}' unless defined(&fuse_teardown);
	    eval 'sub fuse_parse_cmdline () { &fuse_parse_cmdline_v25;}' unless defined(&fuse_parse_cmdline);
	}
 elsif((defined(&FUSE_USE_VERSION) ? &FUSE_USE_VERSION : undef) == 29) {
	    eval 'sub _FUSE_OP_VERSION__ () {29;}' unless defined(&_FUSE_OP_VERSION__);
	    eval 'sub fuse_dirfil_t () { &fuse_dirfil_t_v22;}' unless defined(&fuse_dirfil_t);
	    eval 'sub fuse_fill_dir_t () { &fuse_fill_dir_t_v23;}' unless defined(&fuse_fill_dir_t);
	    eval 'sub fuse_operations () { &_MK_FUSE_OPERATIONS_( &_FUSE_OP_VERSION__);}' unless defined(&fuse_operations);
	    eval 'sub fuse_fs_getattr () { &fuse_fs_getattr_v27;}' unless defined(&fuse_fs_getattr);
	    eval 'sub fuse_fs_rename () { &fuse_fs_rename_v27;}' unless defined(&fuse_fs_rename);
	    eval 'sub fuse_fs_chmod () { &fuse_fs_chmod_v27;}' unless defined(&fuse_fs_chmod);
	    eval 'sub fuse_fs_chown () { &fuse_fs_chown_v27;}' unless defined(&fuse_fs_chown);
	    eval 'sub fuse_fs_readdir () { &fuse_fs_readdir_v27;}' unless defined(&fuse_fs_readdir);
	    eval 'sub fuse_fs_truncate () { &fuse_fs_truncate_v27;}' unless defined(&fuse_fs_truncate);
	    eval 'sub fuse_fs_utimens () { &fuse_fs_utimens_v27;}' unless defined(&fuse_fs_utimens);
	    eval 'sub fuse_fs_ioctl () { &fuse_fs_ioctl_v28;}' unless defined(&fuse_fs_ioctl);
	    eval 'sub fuse_fs_init () { &fuse_fs_init_v27;}' unless defined(&fuse_fs_init);
	    eval 'sub fuse_main {
	        my($argc,$op,$user_data) = @_;
    		eval q({  &__fuse_main($argc,  &argv, $op,  &_FUSE_OP_VERSION__, $user_data); });
	    }' unless defined(&fuse_main);
	    eval 'sub fuse_mount () { &fuse_mount_v26;}' unless defined(&fuse_mount);
	    eval 'sub fuse_unmount () { &fuse_unmount_v26;}' unless defined(&fuse_unmount);
	    eval 'sub fuse_new () {
	        eval q((\'struct fuse_chan\' * &ch, \'struct fuse_args\' * &args,  &const \'struct fuse_operations\' * &op, \'size_t\'  &op_size  &__attribute__(( &__unused__)),  &void * &user_data) {  &fuse_new_v26( &ch,  &args,  &op,  &_FUSE_OP_VERSION__,  &user_data); });
	    }' unless defined(&fuse_new);
	    eval 'sub fuse_destroy () { &fuse_destroy_v11;}' unless defined(&fuse_destroy);
	    eval 'sub fuse_loop_mt () { &fuse_loop_mt_v11;}' unless defined(&fuse_loop_mt);
	    eval 'sub fuse_setup () {
	        eval q((\'int\'  &argc, \'char\' * $argv[],  &const \'struct fuse_operations\' * &op, \'size_t\'  &op_size  &__attribute__(( &__unused__)), \'char\' ** &mountpoint, \'int\' * &multithreaded,  &void * &user_data) {  &fuse_setup_v26( &argc,  &argv,  &op,  &_FUSE_OP_VERSION__,  &mountpoint,  &multithreaded,  &user_data); });
	    }' unless defined(&fuse_setup);
	    eval 'sub fuse_teardown () { &fuse_teardown_v26;}' unless defined(&fuse_teardown);
	    eval 'sub fuse_parse_cmdline () { &fuse_parse_cmdline_v25;}' unless defined(&fuse_parse_cmdline);
	}
 elsif((defined(&FUSE_USE_VERSION) ? &FUSE_USE_VERSION : undef) >= 30 && (defined(&FUSE_USE_VERSION) ? &FUSE_USE_VERSION : undef) <= 31) {
	    eval 'sub _FUSE_OP_VERSION__ () {30;}' unless defined(&_FUSE_OP_VERSION__);
	    eval 'sub fuse_fill_dir_t () { &fuse_fill_dir_t_v30;}' unless defined(&fuse_fill_dir_t);
	    eval 'sub fuse_operations () { &_MK_FUSE_OPERATIONS_( &_FUSE_OP_VERSION__);}' unless defined(&fuse_operations);
	    eval 'sub fuse_fs_getattr () { &fuse_fs_getattr_v30;}' unless defined(&fuse_fs_getattr);
	    eval 'sub fuse_fs_rename () { &fuse_fs_rename_v30;}' unless defined(&fuse_fs_rename);
	    eval 'sub fuse_fs_chmod () { &fuse_fs_chmod_v30;}' unless defined(&fuse_fs_chmod);
	    eval 'sub fuse_fs_chown () { &fuse_fs_chown_v30;}' unless defined(&fuse_fs_chown);
	    eval 'sub fuse_fs_readdir () { &fuse_fs_readdir_v30;}' unless defined(&fuse_fs_readdir);
	    eval 'sub fuse_fs_truncate () { &fuse_fs_truncate_v30;}' unless defined(&fuse_fs_truncate);
	    eval 'sub fuse_fs_utimens () { &fuse_fs_utimens_v30;}' unless defined(&fuse_fs_utimens);
	    eval 'sub fuse_fs_ioctl () { &fuse_fs_ioctl_v28;}' unless defined(&fuse_fs_ioctl);
	    eval 'sub fuse_fs_init () { &fuse_fs_init_v30;}' unless defined(&fuse_fs_init);
	    eval 'sub fuse_main {
	        my($argc,$op,$user_data) = @_;
    		eval q({  &__fuse_main($argc,  &argv, $op,  &_FUSE_OP_VERSION__, $user_data); });
	    }' unless defined(&fuse_main);
	    eval 'sub fuse_mount () { &fuse_mount_v30;}' unless defined(&fuse_mount);
	    eval 'sub fuse_unmount () { &fuse_unmount_v30;}' unless defined(&fuse_unmount);
	    eval 'sub fuse_new () {
	        eval q((\'struct fuse_args\' * &args,  &const \'struct fuse_operations\' * &op, \'size_t\'  &op_size  &__attribute__(( &__unused__)),  &void * &user_data) {  &fuse_new_v30( &args,  &op,  &_FUSE_OP_VERSION__,  &user_data); });
	    }' unless defined(&fuse_new);
	    eval 'sub fuse_destroy () { &fuse_destroy_v30;}' unless defined(&fuse_destroy);
	    eval 'sub fuse_loop_mt () { &fuse_loop_mt_v30;}' unless defined(&fuse_loop_mt);
	    eval 'sub fuse_parse_cmdline () { &fuse_parse_cmdline_v30;}' unless defined(&fuse_parse_cmdline);
	}
 elsif((defined(&FUSE_USE_VERSION) ? &FUSE_USE_VERSION : undef) >= 32 && (defined(&FUSE_USE_VERSION) ? &FUSE_USE_VERSION : undef) <= 33) {
	    eval 'sub _FUSE_OP_VERSION__ () {30;}' unless defined(&_FUSE_OP_VERSION__);
	    eval 'sub fuse_fill_dir_t () { &fuse_fill_dir_t_v30;}' unless defined(&fuse_fill_dir_t);
	    eval 'sub fuse_operations () { &_MK_FUSE_OPERATIONS_( &_FUSE_OP_VERSION__);}' unless defined(&fuse_operations);
	    eval 'sub fuse_fs_getattr () { &fuse_fs_getattr_v30;}' unless defined(&fuse_fs_getattr);
	    eval 'sub fuse_fs_rename () { &fuse_fs_rename_v30;}' unless defined(&fuse_fs_rename);
	    eval 'sub fuse_fs_chmod () { &fuse_fs_chmod_v30;}' unless defined(&fuse_fs_chmod);
	    eval 'sub fuse_fs_chown () { &fuse_fs_chown_v30;}' unless defined(&fuse_fs_chown);
	    eval 'sub fuse_fs_readdir () { &fuse_fs_readdir_v30;}' unless defined(&fuse_fs_readdir);
	    eval 'sub fuse_fs_truncate () { &fuse_fs_truncate_v30;}' unless defined(&fuse_fs_truncate);
	    eval 'sub fuse_fs_utimens () { &fuse_fs_utimens_v30;}' unless defined(&fuse_fs_utimens);
	    eval 'sub fuse_fs_ioctl () { &fuse_fs_ioctl_v28;}' unless defined(&fuse_fs_ioctl);
	    eval 'sub fuse_fs_init () { &fuse_fs_init_v30;}' unless defined(&fuse_fs_init);
	    eval 'sub fuse_main {
	        my($argc,$op,$user_data) = @_;
    		eval q({  &__fuse_main($argc,  &argv, $op,  &_FUSE_OP_VERSION__, $user_data); });
	    }' unless defined(&fuse_main);
	    eval 'sub fuse_mount () { &fuse_mount_v30;}' unless defined(&fuse_mount);
	    eval 'sub fuse_unmount () { &fuse_unmount_v30;}' unless defined(&fuse_unmount);
	    eval 'sub fuse_new () {
	        eval q((\'struct fuse_args\' * &args,  &const \'struct fuse_operations\' * &op, \'size_t\'  &op_size  &__attribute__(( &__unused__)),  &void * &user_data) {  &fuse_new_v30( &args,  &op,  &_FUSE_OP_VERSION__,  &user_data); });
	    }' unless defined(&fuse_new);
	    eval 'sub fuse_destroy () { &fuse_destroy_v30;}' unless defined(&fuse_destroy);
	    eval 'sub fuse_loop_mt () { &fuse_loop_mt_v32;}' unless defined(&fuse_loop_mt);
	    eval 'sub fuse_parse_cmdline () { &fuse_parse_cmdline_v30;}' unless defined(&fuse_parse_cmdline);
	}
 elsif((defined(&FUSE_USE_VERSION) ? &FUSE_USE_VERSION : undef) == 34) {
	    eval 'sub _FUSE_OP_VERSION__ () {34;}' unless defined(&_FUSE_OP_VERSION__);
	    eval 'sub fuse_fill_dir_t () { &fuse_fill_dir_t_v30;}' unless defined(&fuse_fill_dir_t);
	    eval 'sub fuse_operations () { &_MK_FUSE_OPERATIONS_( &_FUSE_OP_VERSION__);}' unless defined(&fuse_operations);
	    eval 'sub fuse_fs_getattr () { &fuse_fs_getattr_v30;}' unless defined(&fuse_fs_getattr);
	    eval 'sub fuse_fs_rename () { &fuse_fs_rename_v30;}' unless defined(&fuse_fs_rename);
	    eval 'sub fuse_fs_chmod () { &fuse_fs_chmod_v30;}' unless defined(&fuse_fs_chmod);
	    eval 'sub fuse_fs_chown () { &fuse_fs_chown_v30;}' unless defined(&fuse_fs_chown);
	    eval 'sub fuse_fs_readdir () { &fuse_fs_readdir_v30;}' unless defined(&fuse_fs_readdir);
	    eval 'sub fuse_fs_truncate () { &fuse_fs_truncate_v30;}' unless defined(&fuse_fs_truncate);
	    eval 'sub fuse_fs_utimens () { &fuse_fs_utimens_v30;}' unless defined(&fuse_fs_utimens);
	    eval 'sub fuse_fs_ioctl () { &fuse_fs_ioctl_v28;}' unless defined(&fuse_fs_ioctl);
	    eval 'sub fuse_fs_init () { &fuse_fs_init_v30;}' unless defined(&fuse_fs_init);
	    eval 'sub fuse_main {
	        my($argc,$op,$user_data) = @_;
    		eval q({  &__fuse_main($argc,  &argv, $op,  &_FUSE_OP_VERSION__, $user_data); });
	    }' unless defined(&fuse_main);
	    eval 'sub fuse_mount () { &fuse_mount_v30;}' unless defined(&fuse_mount);
	    eval 'sub fuse_unmount () { &fuse_unmount_v30;}' unless defined(&fuse_unmount);
	    eval 'sub fuse_new () {
	        eval q((\'struct fuse_args\' * &args,  &const \'struct fuse_operations\' * &op, \'size_t\'  &op_size  &__attribute__(( &__unused__)),  &void * &user_data) {  &fuse_new_v30( &args,  &op,  &_FUSE_OP_VERSION__,  &user_data); });
	    }' unless defined(&fuse_new);
	    eval 'sub fuse_destroy () { &fuse_destroy_v30;}' unless defined(&fuse_destroy);
	    eval 'sub fuse_loop_mt () { &fuse_loop_mt_v32;}' unless defined(&fuse_loop_mt);
	    eval 'sub fuse_parse_cmdline () { &fuse_parse_cmdline_v30;}' unless defined(&fuse_parse_cmdline);
	}
 elsif((defined(&FUSE_USE_VERSION) ? &FUSE_USE_VERSION : undef) >= 35 && (defined(&FUSE_USE_VERSION) ? &FUSE_USE_VERSION : undef) <= 37) {
	    eval 'sub _FUSE_OP_VERSION__ () {35;}' unless defined(&_FUSE_OP_VERSION__);
	    eval 'sub fuse_fill_dir_t () { &fuse_fill_dir_t_v30;}' unless defined(&fuse_fill_dir_t);
	    eval 'sub fuse_operations () { &_MK_FUSE_OPERATIONS_( &_FUSE_OP_VERSION__);}' unless defined(&fuse_operations);
	    eval 'sub fuse_fs_getattr () { &fuse_fs_getattr_v30;}' unless defined(&fuse_fs_getattr);
	    eval 'sub fuse_fs_rename () { &fuse_fs_rename_v30;}' unless defined(&fuse_fs_rename);
	    eval 'sub fuse_fs_chmod () { &fuse_fs_chmod_v30;}' unless defined(&fuse_fs_chmod);
	    eval 'sub fuse_fs_chown () { &fuse_fs_chown_v30;}' unless defined(&fuse_fs_chown);
	    eval 'sub fuse_fs_readdir () { &fuse_fs_readdir_v30;}' unless defined(&fuse_fs_readdir);
	    eval 'sub fuse_fs_truncate () { &fuse_fs_truncate_v30;}' unless defined(&fuse_fs_truncate);
	    eval 'sub fuse_fs_utimens () { &fuse_fs_utimens_v30;}' unless defined(&fuse_fs_utimens);
	    eval 'sub fuse_fs_ioctl () { &fuse_fs_ioctl_v35;}' unless defined(&fuse_fs_ioctl);
	    eval 'sub fuse_fs_init () { &fuse_fs_init_v30;}' unless defined(&fuse_fs_init);
	    eval 'sub fuse_main {
	        my($argc,$op,$user_data) = @_;
    		eval q({  &__fuse_main($argc,  &argv, $op,  &_FUSE_OP_VERSION__, $user_data); });
	    }' unless defined(&fuse_main);
	    eval 'sub fuse_mount () { &fuse_mount_v30;}' unless defined(&fuse_mount);
	    eval 'sub fuse_unmount () { &fuse_unmount_v30;}' unless defined(&fuse_unmount);
	    eval 'sub fuse_new () {
	        eval q((\'struct fuse_args\' * &args,  &const \'struct fuse_operations\' * &op, \'size_t\'  &op_size  &__attribute__(( &__unused__)),  &void * &user_data) {  &fuse_new_v30( &args,  &op,  &_FUSE_OP_VERSION__,  &user_data); });
	    }' unless defined(&fuse_new);
	    eval 'sub fuse_destroy () { &fuse_destroy_v30;}' unless defined(&fuse_destroy);
	    eval 'sub fuse_loop_mt () { &fuse_loop_mt_v32;}' unless defined(&fuse_loop_mt);
	    eval 'sub fuse_parse_cmdline () { &fuse_parse_cmdline_v30;}' unless defined(&fuse_parse_cmdline);
	}
 elsif((defined(&FUSE_USE_VERSION) ? &FUSE_USE_VERSION : undef) >= 38 && (defined(&FUSE_USE_VERSION) ? &FUSE_USE_VERSION : undef) <= 310) {
	    eval 'sub _FUSE_OP_VERSION__ () {38;}' unless defined(&_FUSE_OP_VERSION__);
	    eval 'sub fuse_fill_dir_t () { &fuse_fill_dir_t_v30;}' unless defined(&fuse_fill_dir_t);
	    eval 'sub fuse_operations () { &_MK_FUSE_OPERATIONS_( &_FUSE_OP_VERSION__);}' unless defined(&fuse_operations);
	    eval 'sub fuse_fs_getattr () { &fuse_fs_getattr_v30;}' unless defined(&fuse_fs_getattr);
	    eval 'sub fuse_fs_rename () { &fuse_fs_rename_v30;}' unless defined(&fuse_fs_rename);
	    eval 'sub fuse_fs_chmod () { &fuse_fs_chmod_v30;}' unless defined(&fuse_fs_chmod);
	    eval 'sub fuse_fs_chown () { &fuse_fs_chown_v30;}' unless defined(&fuse_fs_chown);
	    eval 'sub fuse_fs_readdir () { &fuse_fs_readdir_v30;}' unless defined(&fuse_fs_readdir);
	    eval 'sub fuse_fs_truncate () { &fuse_fs_truncate_v30;}' unless defined(&fuse_fs_truncate);
	    eval 'sub fuse_fs_utimens () { &fuse_fs_utimens_v30;}' unless defined(&fuse_fs_utimens);
	    eval 'sub fuse_fs_ioctl () { &fuse_fs_ioctl_v35;}' unless defined(&fuse_fs_ioctl);
	    eval 'sub fuse_fs_init () { &fuse_fs_init_v30;}' unless defined(&fuse_fs_init);
	    eval 'sub fuse_main {
	        my($argc,$op,$user_data) = @_;
    		eval q({  &__fuse_main($argc,  &argv, $op,  &_FUSE_OP_VERSION__, $user_data); });
	    }' unless defined(&fuse_main);
	    eval 'sub fuse_mount () { &fuse_mount_v30;}' unless defined(&fuse_mount);
	    eval 'sub fuse_unmount () { &fuse_unmount_v30;}' unless defined(&fuse_unmount);
	    eval 'sub fuse_new () {
	        eval q((\'struct fuse_args\' * &args,  &const \'struct fuse_operations\' * &op, \'size_t\'  &op_size  &__attribute__(( &__unused__)),  &void * &user_data) {  &fuse_new_v30( &args,  &op,  &_FUSE_OP_VERSION__,  &user_data); });
	    }' unless defined(&fuse_new);
	    eval 'sub fuse_destroy () { &fuse_destroy_v30;}' unless defined(&fuse_destroy);
	    eval 'sub fuse_loop_mt () { &fuse_loop_mt_v32;}' unless defined(&fuse_loop_mt);
	    eval 'sub fuse_parse_cmdline () { &fuse_parse_cmdline_v30;}' unless defined(&fuse_parse_cmdline);
	}
    }
    if(defined(&__cplusplus)) {
    }
}
1;
