/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecodecvssnap;

import gnu.bytecodecvssnap.AttrContainer;
import gnu.bytecodecvssnap.Attribute;
import gnu.bytecodecvssnap.ClassType;
import gnu.bytecodecvssnap.CodeAttr;
import gnu.bytecodecvssnap.ConstantPool;
import gnu.bytecodecvssnap.ConstantValueAttr;
import gnu.bytecodecvssnap.CpoolClass;
import gnu.bytecodecvssnap.CpoolUtf8;
import gnu.bytecodecvssnap.Field;
import gnu.bytecodecvssnap.InnerClassesAttr;
import gnu.bytecodecvssnap.Label;
import gnu.bytecodecvssnap.LineNumbersAttr;
import gnu.bytecodecvssnap.LocalVarsAttr;
import gnu.bytecodecvssnap.Method;
import gnu.bytecodecvssnap.MiscAttr;
import gnu.bytecodecvssnap.Scope;
import gnu.bytecodecvssnap.SourceDebugExtAttr;
import gnu.bytecodecvssnap.SourceFileAttr;
import gnu.bytecodecvssnap.Variable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class ClassFileInput
extends DataInputStream {
    ClassType ctype;
    InputStream str;

    public static ClassType readClassType(InputStream inputStream) throws IOException, ClassFormatError {
        ClassType classType = new ClassType();
        ClassFileInput classFileInput = new ClassFileInput(classType, inputStream);
        return classType;
    }

    public boolean readHeader() throws IOException {
        int n = this.readInt();
        if (n != -889275714) {
            return false;
        }
        short s = this.readShort();
        short s2 = this.readShort();
        return true;
    }

    public ConstantPool readConstants() throws IOException {
        return new ConstantPool(this);
    }

    public void readClassInfo() throws IOException {
        this.ctype.access_flags = this.readUnsignedShort();
        this.ctype.thisClassIndex = this.readUnsignedShort();
        CpoolClass cpoolClass = (CpoolClass)this.ctype.constants.getForced(this.ctype.thisClassIndex, 7);
        String string = cpoolClass.name.string;
        this.ctype.this_name = string.replace('/', '.');
        this.ctype.setSignature("L" + string + ';');
        this.ctype.superClassIndex = this.readUnsignedShort();
        if (this.ctype.superClassIndex == 0) {
            this.ctype.setSuper((ClassType)null);
        } else {
            cpoolClass = (CpoolClass)this.ctype.constants.getForced(this.ctype.superClassIndex, 7);
            string = cpoolClass.name.string;
            this.ctype.setSuper(string.replace('/', '.'));
        }
        int n = this.readUnsignedShort();
        if (n > 0) {
            this.ctype.interfaces = new ClassType[n];
            this.ctype.interfaceIndexes = new int[n];
            int n2 = 0;
            while (n2 < n) {
                int n3;
                this.ctype.interfaceIndexes[n2] = n3 = this.readUnsignedShort();
                cpoolClass = (CpoolClass)this.ctype.constants.getForced(n3, 7);
                string = cpoolClass.name.string.replace('/', '.');
                this.ctype.interfaces[n2] = ClassType.make(string);
                ++n2;
            }
        }
    }

    public int readAttributes(AttrContainer attrContainer) throws IOException {
        int n = this.readUnsignedShort();
        Attribute attribute = attrContainer.getAttributes();
        int n2 = 0;
        while (n2 < n) {
            if (attribute != null) {
                Attribute attribute2;
                while ((attribute2 = attribute.getNext()) != null) {
                    attribute = attribute2;
                }
            }
            int n3 = this.readUnsignedShort();
            CpoolUtf8 cpoolUtf8 = (CpoolUtf8)this.ctype.constants.getForced(n3, 1);
            int n4 = this.readInt();
            cpoolUtf8.intern();
            Attribute attribute3 = this.readAttribute(cpoolUtf8.string, n4, attrContainer);
            if (attribute3 != null) {
                if (attribute3.getNameIndex() == 0) {
                    attribute3.setNameIndex(n3);
                }
                if (attribute == null) {
                    attrContainer.setAttributes(attribute3);
                } else {
                    if (attrContainer.getAttributes() == attribute3) {
                        attrContainer.setAttributes(attribute3.getNext());
                        attribute3.setNext(null);
                    }
                    attribute.setNext(attribute3);
                }
                attribute = attribute3;
            }
            ++n2;
        }
        return n;
    }

    public final void skipAttribute(int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            int n3 = (int)this.skip(n - n2);
            if (n3 == 0) {
                if (this.read() < 0) {
                    throw new EOFException("EOF while reading class files attributes");
                }
                n3 = 1;
            }
            n2 += n3;
        }
    }

    public Attribute readAttribute(String string, int n, AttrContainer attrContainer) throws IOException {
        if (string == "SourceFile" && attrContainer instanceof ClassType) {
            return new SourceFileAttr(this.readUnsignedShort(), (ClassType)attrContainer);
        }
        if (string == "Code" && attrContainer instanceof Method) {
            CodeAttr codeAttr = new CodeAttr((Method)attrContainer);
            codeAttr.setMaxStack(this.readUnsignedShort());
            codeAttr.setMaxLocals(this.readUnsignedShort());
            int n2 = this.readInt();
            byte[] byArray = new byte[n2];
            this.readFully(byArray);
            codeAttr.setCode(byArray);
            int n3 = this.readUnsignedShort();
            int n4 = 0;
            while (n4 < n3) {
                int n5 = this.readUnsignedShort();
                int n6 = this.readUnsignedShort();
                int n7 = this.readUnsignedShort();
                int n8 = this.readUnsignedShort();
                codeAttr.addHandler(n5, n6, n7, n8);
                ++n4;
            }
            this.readAttributes(codeAttr);
            return codeAttr;
        }
        if (string == "LineNumberTable" && attrContainer instanceof CodeAttr) {
            int n9 = 2 * this.readUnsignedShort();
            short[] sArray = new short[n9];
            int n10 = 0;
            while (n10 < n9) {
                sArray[n10] = this.readShort();
                ++n10;
            }
            return new LineNumbersAttr(sArray, (CodeAttr)attrContainer);
        }
        if (string == "LocalVariableTable" && attrContainer instanceof CodeAttr) {
            CodeAttr codeAttr = (CodeAttr)attrContainer;
            LocalVarsAttr localVarsAttr = new LocalVarsAttr(codeAttr);
            Method method = localVarsAttr.getMethod();
            if (localVarsAttr.parameter_scope == null) {
                localVarsAttr.parameter_scope = method.pushScope();
            }
            Scope scope = localVarsAttr.parameter_scope;
            if (scope.end == null) {
                scope.end = new Label(codeAttr.PC);
            }
            ConstantPool constantPool = method.getConstants();
            int n11 = this.readUnsignedShort();
            int n12 = scope.start.position;
            int n13 = scope.end.position;
            int n14 = 0;
            while (n14 < n11) {
                Variable variable = new Variable();
                int n15 = this.readUnsignedShort();
                int n16 = n15 + this.readUnsignedShort();
                if (n15 != n12 || n16 != n13) {
                    while (scope.parent != null && (n15 < scope.start.position || n16 > scope.end.position)) {
                        scope = scope.parent;
                    }
                    Scope scope2 = scope;
                    scope = new Scope(new Label(n15), new Label(n16));
                    scope.linkChild(scope2);
                    n12 = n15;
                    n13 = n16;
                }
                scope.addVariable(variable);
                variable.setName(this.readUnsignedShort(), constantPool);
                variable.setSignature(this.readUnsignedShort(), constantPool);
                variable.offset = this.readUnsignedShort();
                ++n14;
            }
            return localVarsAttr;
        }
        if (string == "ConstantValue" && attrContainer instanceof Field) {
            return new ConstantValueAttr(this.readUnsignedShort());
        }
        if (string == "InnerClasses" && attrContainer instanceof ClassType) {
            int n17 = 4 * this.readUnsignedShort();
            short[] sArray = new short[n17];
            int n18 = 0;
            while (n18 < n17) {
                sArray[n18] = this.readShort();
                ++n18;
            }
            return new InnerClassesAttr(sArray, (ClassType)attrContainer);
        }
        if (string == "Exceptions" && attrContainer instanceof Method) {
            Method method = (Method)attrContainer;
            int n19 = this.readUnsignedShort();
            short[] sArray = new short[n19];
            int n20 = 0;
            while (n20 < n19) {
                sArray[n20] = this.readShort();
                ++n20;
            }
            method.setExceptions(sArray);
            return method.getExceptionAttr();
        }
        if (string == "SourceDebugExtension" && attrContainer instanceof ClassType) {
            SourceDebugExtAttr sourceDebugExtAttr = new SourceDebugExtAttr((ClassType)attrContainer);
            byte[] byArray = new byte[n];
            this.readFully(byArray, 0, n);
            sourceDebugExtAttr.data = byArray;
            sourceDebugExtAttr.dlength = n;
            return sourceDebugExtAttr;
        }
        byte[] byArray = new byte[n];
        this.readFully(byArray, 0, n);
        return new MiscAttr(string, byArray);
    }

    public void readFields() throws IOException {
        int n = this.readUnsignedShort();
        ConstantPool constantPool = this.ctype.constants;
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.readUnsignedShort();
            int n4 = this.readUnsignedShort();
            int n5 = this.readUnsignedShort();
            Field field = this.ctype.addField();
            field.setName(n4, constantPool);
            field.setSignature(n5, constantPool);
            field.flags = n3;
            this.readAttributes(field);
            ++n2;
        }
    }

    public void readMethods() throws IOException {
        int n = this.readUnsignedShort();
        ConstantPool constantPool = this.ctype.constants;
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.readUnsignedShort();
            int n4 = this.readUnsignedShort();
            int n5 = this.readUnsignedShort();
            Method method = this.ctype.addMethod(null, n3);
            method.setName(n4);
            method.setSignature(n5);
            this.readAttributes(method);
            ++n2;
        }
    }

    public ClassFileInput(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public ClassFileInput(ClassType classType, InputStream inputStream) throws IOException, ClassFormatError {
        super(inputStream);
        this.ctype = classType;
        if (!this.readHeader()) {
            throw new ClassFormatError("invalid magic number");
        }
        classType.constants = this.readConstants();
        this.readClassInfo();
        this.readFields();
        this.readMethods();
        this.readAttributes(classType);
    }
}

