/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellEditor;

public class DefaultCellEditor
extends AbstractCellEditor
implements TableCellEditor,
TreeCellEditor {
    private static final long serialVersionUID = 3564035141373880027L;
    protected JComponent editorComponent;
    protected EditorDelegate delegate;
    protected int clickCountToStart;

    public Component getComponent() {
        return this.editorComponent;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public void setClickCountToStart(int n) {
        this.clickCountToStart = n;
    }

    public Object getCellEditorValue() {
        return this.delegate.getCellEditorValue();
    }

    public boolean isCellEditable(EventObject eventObject) {
        return this.delegate.isCellEditable(eventObject);
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return this.delegate.shouldSelectCell(eventObject);
    }

    public boolean stopCellEditing() {
        return this.delegate.stopCellEditing();
    }

    public void cancelCellEditing() {
        this.delegate.cancelCellEditing();
    }

    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        this.delegate.setValue(object);
        return this.editorComponent;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.delegate.setValue(object);
        return this.editorComponent;
    }

    public DefaultCellEditor(JTextField jTextField) {
        this.editorComponent = jTextField;
        this.clickCountToStart = 2;
        this.delegate = new JTextFieldDelegate();
        jTextField.addActionListener(this.delegate);
    }

    public DefaultCellEditor(JCheckBox jCheckBox) {
        this.editorComponent = jCheckBox;
        this.clickCountToStart = 1;
        this.delegate = new JCheckBoxDelegate();
        jCheckBox.addActionListener(this.delegate);
    }

    public DefaultCellEditor(JComboBox jComboBox) {
        this.editorComponent = jComboBox;
        this.clickCountToStart = 1;
        this.delegate = new JComboBoxDelegate();
        jComboBox.addActionListener(this.delegate);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class EditorDelegate
    implements ActionListener,
    ItemListener,
    Serializable {
        private static final long serialVersionUID = -1420007406015481933L;
        protected Object value;

        public void setValue(Object object) {
            this.value = object;
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public boolean isCellEditable(EventObject eventObject) {
            return eventObject == null || !(eventObject instanceof MouseEvent) || ((MouseEvent)eventObject).getClickCount() >= DefaultCellEditor.this.getClickCountToStart();
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        public boolean startCellEditing(EventObject eventObject) {
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.stopCellEditing();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.stopCellEditing();
        }

        void fireEditingStopped() {
            CellEditorListener[] cellEditorListenerArray = DefaultCellEditor.this.getCellEditorListeners();
            int n = 0;
            while (n < cellEditorListenerArray.length) {
                cellEditorListenerArray[n].editingStopped(DefaultCellEditor.this.changeEvent);
                ++n;
            }
        }

        void fireEditingCanceled() {
            CellEditorListener[] cellEditorListenerArray = DefaultCellEditor.this.getCellEditorListeners();
            int n = 0;
            while (n < cellEditorListenerArray.length) {
                cellEditorListenerArray[n].editingCanceled(DefaultCellEditor.this.changeEvent);
                ++n;
            }
        }

        protected EditorDelegate() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class JTextFieldDelegate
    extends EditorDelegate {
        private static final long serialVersionUID = 1L;

        public void setValue(Object object) {
            this.value = object;
            JTextField jTextField = (JTextField)DefaultCellEditor.this.editorComponent;
            if (this.value == null) {
                jTextField.setText("");
            } else {
                jTextField.setText(this.value.toString());
            }
        }

        public Object getCellEditorValue() {
            JTextField jTextField = (JTextField)DefaultCellEditor.this.editorComponent;
            this.value = jTextField.getText();
            return this.value;
        }

        private JTextFieldDelegate() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class JCheckBoxDelegate
    extends EditorDelegate {
        private static final long serialVersionUID = 1L;

        public void setValue(Object object) {
            JCheckBox jCheckBox = (JCheckBox)DefaultCellEditor.this.editorComponent;
            if (object == null) {
                jCheckBox.setSelected(false);
            } else {
                jCheckBox.setSelected((Boolean)object);
            }
        }

        public Object getCellEditorValue() {
            JCheckBox jCheckBox = (JCheckBox)DefaultCellEditor.this.editorComponent;
            this.value = jCheckBox.isSelected() ? Boolean.TRUE : Boolean.FALSE;
            return this.value;
        }

        private JCheckBoxDelegate() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class JComboBoxDelegate
    extends EditorDelegate {
        private static final long serialVersionUID = 1L;

        public void setValue(Object object) {
            this.value = object;
            JComboBox jComboBox = (JComboBox)DefaultCellEditor.this.editorComponent;
            if (this.value != null) {
                jComboBox.setSelectedItem(this.value);
            }
        }

        public Object getCellEditorValue() {
            JComboBox jComboBox = (JComboBox)DefaultCellEditor.this.editorComponent;
            this.value = jComboBox.getSelectedItem();
            return this.value;
        }

        private JComboBoxDelegate() {
        }
    }
}

