#############################################################################
##
#W  semicong.gd                  GAP library                 Andrew Solomon
##
#H  @(#)$Id: semicong.gd,v 4.9 2002/04/15 10:05:20 sal Exp $
##
#Y  Copyright (C)  1997,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
#Y  (C) 1998 School Math and Comp. Sci., University of St.  Andrews, Scotland
#Y  Copyright (C) 2002 The GAP Group
##
##  This file contains the declaration for semigroup congruences.
##
##  Maintenance and further development by:
##  Robert F. Morse
##  Andrew Solomon
##
Revision.semicong_gd :=
    "@(#)$Id: semicong.gd,v 4.9 2002/04/15 10:05:20 sal Exp $";

###########################################################################
##
#M  SemigroupCongruenceByGeneratingPairs(<s>,<list>)
##
##  create a semigroup congruence on <s> generated by the list
##  <list> of pairs.
##
DeclareOperation("SemigroupCongruenceByGeneratingPairs",
    [IsMagma and IsAssociative, IsList]);

#############################################################################
##
#M  RightSemigroupCongruenceByGeneratingPairs(<D>, <pairs> )
##
##  The right congruence on <D> generated by <pairs>
##
DeclareOperation( "RightSemigroupCongruenceByGeneratingPairs", 
    [IsMagma and IsAssociative, IsList ] );

#############################################################################
##
#M  LeftSemigroupCongruenceByGeneratingPairs(<D>, <pairs> )
##
##  The left congruence generated by pairs
##
DeclareOperation( "LeftSemigroupCongruenceByGeneratingPairs", 
    [IsMagma and IsAssociative, IsList ] );

#############################################################################
##
#M  JoinSemigroupCongruences(<cong1>, <cong2>)
##
##  Join of two semigroup congruences 
##
DeclareSynonym("JoinSemigroupCongruences", JoinMagmaCongruences);

#############################################################################
##
#M  MeetSemigroupCongruences(<cong1>, <cong2>)
##
##  Join of two semigroup congruences 
##
DeclareSynonym("MeetSemigroupCongruences", MeetMagmaCongruences);

#############################################################################
##
#A  GeneratingPairsOfSemigroupCongruence(<cong1>, <cong2>)
##
##  Generating Pairs of a semigroup congruences 
##
DeclareSynonym("GeneratingPairsOfSemigroupCongruence", 
                    GeneratingPairsOfMagmaCongruence);

###########################################################################
##
#P  IsLeftSemigroupCongruence(<c>)
##
##  a left magma congruence <c> on a semigroup.
##
DeclareProperty("IsLeftSemigroupCongruence", IsLeftMagmaCongruence);

###########################################################################
##
#P  IsRightSemigroupCongruence(<c>)
##
##  a right magma congruence <c> on a semigroup.
##
DeclareProperty("IsRightSemigroupCongruence", IsRightMagmaCongruence);

###########################################################################
##
#P  IsSemigroupCongruence(<c>)
##
##  a magma congruence <c> on a semigroup.
##
DeclareProperty("IsSemigroupCongruence", IsMagmaCongruence);
InstallTrueMethod(IsLeftSemigroupCongruence,IsSemigroupCongruence);
InstallTrueMethod(IsRightSemigroupCongruence,IsSemigroupCongruence);

###########################################################################
##
#P  IsReesCongruence(<c>)
##
##  returns true precisely when the congruence <c> has at most one
##  nonsingleton congruence class.
##
DeclareProperty("IsReesCongruence", IsSemigroupCongruence );

#############################################################################
##
#E
