/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class WeakIdentityHashMap
extends AbstractMap
implements Map {
    private static final int DEFAULT_CAPACITY = 11;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final Object NULL_KEY = new Object();
    private final ReferenceQueue queue;
    int size;
    private float loadFactor;
    private int threshold;
    int modCount;
    private final WeakEntrySet theEntrySet;
    WeakBucket[] buckets;

    private final int hash(Object object) {
        return Math.abs(System.identityHashCode(object) % this.buckets.length);
    }

    void cleanQueue() {
        Reference reference = this.queue.poll();
        while (reference != null) {
            this.internalRemove((WeakBucket)reference);
            reference = this.queue.poll();
        }
    }

    private final void rehash() {
        WeakBucket[] weakBucketArray = this.buckets;
        int n = this.buckets.length * 2 + 1;
        this.threshold = (int)((float)n * this.loadFactor);
        this.buckets = new WeakBucket[n];
        int n2 = 0;
        while (n2 < weakBucketArray.length) {
            WeakBucket weakBucket = weakBucketArray[n2];
            while (weakBucket != null) {
                WeakBucket weakBucket2 = weakBucket.next;
                Object object = weakBucket.get();
                if (object == null) {
                    weakBucket.slot = -1;
                    --this.size;
                } else {
                    int n3;
                    weakBucket.slot = n3 = this.hash(object);
                    weakBucket.next = this.buckets[n3];
                    this.buckets[n3] = weakBucket;
                }
                weakBucket = weakBucket2;
            }
            ++n2;
        }
    }

    private final WeakBucket.WeakEntry internalGet(Object object) {
        if (object == null) {
            object = NULL_KEY;
        }
        int n = this.hash(object);
        WeakBucket weakBucket = this.buckets[n];
        while (weakBucket != null) {
            WeakBucket.WeakEntry weakEntry = weakBucket.getEntry();
            if (weakEntry != null && object == weakEntry.key) {
                return weakEntry;
            }
            weakBucket = weakBucket.next;
        }
        return null;
    }

    private final void internalAdd(Object object, Object object2) {
        if (object == null) {
            object = NULL_KEY;
        }
        int n = this.hash(object);
        WeakBucket weakBucket = new WeakBucket(object, this.queue, object2, n);
        weakBucket.next = this.buckets[n];
        this.buckets[n] = weakBucket;
        ++this.size;
    }

    void internalRemove(WeakBucket weakBucket) {
        int n = weakBucket.slot;
        if (n == -1) {
            return;
        }
        weakBucket.slot = -1;
        WeakBucket weakBucket2 = null;
        WeakBucket weakBucket3 = this.buckets[n];
        while (weakBucket3 != weakBucket) {
            if (weakBucket3 == null) {
                throw new InternalError("WeakIdentityHashMap in inconsistent state");
            }
            weakBucket2 = weakBucket3;
            weakBucket3 = weakBucket2.next;
        }
        if (weakBucket2 == null) {
            this.buckets[n] = weakBucket.next;
        } else {
            weakBucket2.next = weakBucket.next;
        }
        --this.size;
    }

    public int size() {
        this.cleanQueue();
        return this.size;
    }

    public boolean isEmpty() {
        this.cleanQueue();
        boolean bl = false;
        if (this.size == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean containsKey(Object object) {
        this.cleanQueue();
        boolean bl = false;
        if (this.internalGet(object) != null) {
            bl = true;
        }
        return bl;
    }

    public Object get(Object object) {
        this.cleanQueue();
        WeakBucket.WeakEntry weakEntry = this.internalGet(object);
        return weakEntry == null ? null : weakEntry.getValue();
    }

    public Object put(Object object, Object object2) {
        this.cleanQueue();
        WeakBucket.WeakEntry weakEntry = this.internalGet(object);
        if (weakEntry != null) {
            return weakEntry.setValue(object2);
        }
        ++this.modCount;
        if (this.size >= this.threshold) {
            this.rehash();
        }
        this.internalAdd(object, object2);
        return null;
    }

    public Object remove(Object object) {
        this.cleanQueue();
        WeakBucket.WeakEntry weakEntry = this.internalGet(object);
        if (weakEntry == null) {
            return null;
        }
        ++this.modCount;
        this.internalRemove(weakEntry.getBucket());
        return weakEntry.getValue();
    }

    public Set entrySet() {
        this.cleanQueue();
        return this.theEntrySet;
    }

    public void clear() {
        super.clear();
    }

    public boolean containsValue(Object object) {
        this.cleanQueue();
        return super.containsValue(object);
    }

    public Set keySet() {
        this.cleanQueue();
        return super.keySet();
    }

    public void putAll(Map map) {
        super.putAll(map);
    }

    public Collection values() {
        this.cleanQueue();
        return super.values();
    }

    public WeakIdentityHashMap() {
        this(11, 0.75f);
    }

    public WeakIdentityHashMap(int n) {
        this(n, 0.75f);
    }

    public WeakIdentityHashMap(int n, float f) {
        if (n < 0 || !(f > 0.0f)) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.threshold = (int)((float)n * f);
        this.theEntrySet = new WeakEntrySet();
        this.queue = new ReferenceQueue();
        this.buckets = new WeakBucket[n];
    }

    public WeakIdentityHashMap(Map map) {
        this(map.size(), 0.75f);
        this.putAll(map);
    }

    private static class WeakBucket
    extends WeakReference {
        Object value;
        WeakBucket next;
        int slot;

        WeakEntry getEntry() {
            Object object = this.get();
            if (object == null) {
                return null;
            }
            return new WeakEntry(object);
        }

        public WeakBucket(Object object, ReferenceQueue referenceQueue, Object object2, int n) {
            super(object, referenceQueue);
            this.value = object2;
            this.slot = n;
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        class WeakEntry
        implements Map.Entry {
            Object key;

            public WeakBucket getBucket() {
                return WeakBucket.this;
            }

            public Object getKey() {
                return this.key == NULL_KEY ? null : this.key;
            }

            public Object getValue() {
                return WeakBucket.this.value;
            }

            public Object setValue(Object object) {
                Object object2 = WeakBucket.this.value;
                WeakBucket.this.value = object;
                return object2;
            }

            public int hashCode() {
                int n = System.identityHashCode(this.key);
                int n2 = 0;
                if (WeakBucket.this.value != null) {
                    n2 = WeakBucket.this.value.hashCode();
                }
                return n ^ n2;
            }

            public boolean equals(Object object) {
                if (object instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)object;
                    boolean bl = false;
                    if (this.getKey() == entry.getKey() && (WeakBucket.this.value == null ? entry.getValue() == null : WeakBucket.this.value.equals(entry.getValue()))) {
                        bl = true;
                    }
                    return bl;
                }
                return false;
            }

            public String toString() {
                return "" + this.getKey() + '=' + WeakBucket.this.value;
            }

            public WeakEntry(Object object) {
                this.key = object;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class WeakEntrySet
    extends AbstractSet {
        public final int size() {
            return WeakIdentityHashMap.this.size;
        }

        public final Iterator iterator() {
            return new Iterator(){
                WeakBucket.WeakEntry lastEntry;
                WeakBucket.WeakEntry nextEntry;
                int knownMod;

                private final void checkMod() {
                    WeakIdentityHashMap.this.cleanQueue();
                    if (this.knownMod != WeakIdentityHashMap.this.modCount) {
                        throw new ConcurrentModificationException(this.knownMod + " != " + WeakIdentityHashMap.this.modCount);
                    }
                }

                private final WeakBucket.WeakEntry findNext(WeakBucket.WeakEntry weakEntry) {
                    int n;
                    WeakBucket weakBucket;
                    if (weakEntry != null) {
                        weakBucket = weakEntry.getBucket().next;
                        n = weakEntry.getBucket().slot;
                    } else {
                        weakBucket = WeakIdentityHashMap.this.buckets[0];
                        n = 0;
                    }
                    while (true) {
                        if (weakBucket != null) {
                            WeakBucket.WeakEntry weakEntry2 = weakBucket.getEntry();
                            if (weakEntry2 != null) {
                                return weakEntry2;
                            }
                            weakBucket = weakBucket.next;
                            continue;
                        }
                        if (++n == WeakIdentityHashMap.this.buckets.length) {
                            return null;
                        }
                        weakBucket = WeakIdentityHashMap.this.buckets[n];
                    }
                }

                public final boolean hasNext() {
                    this.checkMod();
                    boolean bl = false;
                    if (this.nextEntry != null) {
                        bl = true;
                    }
                    return bl;
                }

                public final Object next() {
                    this.checkMod();
                    if (this.nextEntry == null) {
                        throw new NoSuchElementException();
                    }
                    this.lastEntry = this.nextEntry;
                    this.nextEntry = this.findNext(this.lastEntry);
                    return this.lastEntry;
                }

                public final void remove() {
                    this.checkMod();
                    if (this.lastEntry == null) {
                        throw new IllegalStateException();
                    }
                    ++WeakIdentityHashMap.this.modCount;
                    WeakIdentityHashMap.this.internalRemove(this.lastEntry.getBucket());
                    this.lastEntry = null;
                    ++this.knownMod;
                }

                private final /* synthetic */ void this() {
                    this.nextEntry = this.findNext(null);
                    this.knownMod = WeakIdentityHashMap.this.modCount;
                }
                {
                    this.this();
                }
            };
        }

        WeakEntrySet() {
        }
    }
}

