/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.security;

import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xbill.DNS.Cache;
import org.xbill.DNS.DNSSEC;
import org.xbill.DNS.KEYRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.RRset;
import org.xbill.DNS.SIGRecord;
import org.xbill.DNS.Type;
import org.xbill.DNS.Verifier;
import org.xbill.DNS.security.DSASignature;
import org.xbill.DNS.security.KEYConverter;

public class DNSSECVerifier
implements Verifier {
    private Map trustedKeys = new HashMap();

    public synchronized void addTrustedKey(KEYRecord kEYRecord) {
        Name name = kEYRecord.getName();
        List list2 = (List)this.trustedKeys.get(name);
        if (list2 == null) {
            list2 = new LinkedList();
            this.trustedKeys.put(name, list2);
        }
        list2.add(kEYRecord);
    }

    public void addTrustedKey(Name name, PublicKey publicKey) {
        KEYRecord kEYRecord = KEYConverter.buildRecord(name, 1, 0L, 0, 3, publicKey);
        if (kEYRecord != null) {
            this.addTrustedKey(kEYRecord);
        }
    }

    private final PublicKey findMatchingKey(Iterator iterator, int n, int n2) {
        while (iterator.hasNext()) {
            KEYRecord kEYRecord = (KEYRecord)iterator.next();
            if (kEYRecord.getAlgorithm() != n || kEYRecord.getFootprint() != n2) continue;
            return KEYConverter.parseRecord(kEYRecord);
        }
        return null;
    }

    private final synchronized PublicKey findTrustedKey(Name name, int n, int n2) {
        List list2 = (List)this.trustedKeys.get(name);
        if (list2 == null) {
            return null;
        }
        return this.findMatchingKey(list2.iterator(), n, n2);
    }

    private final PublicKey findCachedKey(Cache cache, Name name, int n, int n2) {
        RRset[] rRsetArray = cache.findAnyRecords(name, 25);
        if (rRsetArray == null) {
            return null;
        }
        RRset rRset = rRsetArray[0];
        return this.findMatchingKey(rRset.rrs(), n, n2);
    }

    private final PublicKey findKey(Cache cache, Name name, int n, int n2) {
        PublicKey publicKey = this.findTrustedKey(name, n, n2);
        if (publicKey == null && cache != null) {
            return this.findCachedKey(cache, name, n, n2);
        }
        return publicKey;
    }

    private final int verifySIG(RRset rRset, SIGRecord sIGRecord, Cache cache) {
        String string;
        byte[] byArray;
        PublicKey publicKey = this.findKey(cache, sIGRecord.getSigner(), sIGRecord.getAlgorithm(), sIGRecord.getFootprint());
        if (publicKey == null) {
            return 0;
        }
        Date date = new Date();
        if (date.compareTo(sIGRecord.getExpire()) > 0 || date.compareTo(sIGRecord.getTimeSigned()) < 0) {
            System.err.println("Outside of validity period");
            return -1;
        }
        byte[] byArray2 = DNSSEC.digestRRset(sIGRecord, rRset);
        switch (sIGRecord.getAlgorithm()) {
            case 1: {
                byArray = sIGRecord.getSignature();
                string = "MD5withRSA";
                break;
            }
            case 3: {
                byArray = DSASignature.create(sIGRecord);
                string = "SHA1withDSA";
                break;
            }
            case 5: {
                byArray = sIGRecord.getSignature();
                string = "SHA1withRSA";
                break;
            }
            default: {
                return -1;
            }
        }
        try {
            Signature signature = Signature.getInstance(string);
            signature.initVerify(publicKey);
            signature.update(byArray2);
            return signature.verify(byArray) ? 1 : -1;
        }
        catch (GeneralSecurityException generalSecurityException) {
            if (Options.check("verboseexceptions")) {
                System.err.println("Signing data: " + generalSecurityException);
            }
            return -1;
        }
    }

    /*
     * Unable to fully structure code
     */
    public int verify(RRset var1_1, Cache var2_2) {
        var3_3 = var1_1.sigs();
        if (Options.check("verbosesec")) {
            System.out.print("Verifying " + var1_1.getName() + '/' + Type.string(var1_1.getType()) + ": ");
        }
        if (var3_3.hasNext()) ** GOTO lbl13
        if (Options.check("verbosesec")) {
            System.out.println("Insecure");
        }
        return 0;
lbl-1000:
        // 1 sources

        {
            var4_4 = (SIGRecord)var3_3.next();
            if (this.verifySIG(var1_1, var4_4, var2_2) != 1) continue;
            if (Options.check("verbosesec")) {
                System.out.println("Secure");
            }
            return 1;
lbl13:
            // 2 sources

            ** while (var3_3.hasNext())
        }
lbl14:
        // 1 sources

        if (Options.check("verbosesec")) {
            System.out.println("Failed");
        }
        return -1;
    }
}

