/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.html.wikipedia;

import info.bliki.html.wikipedia.HTMLTag;
import info.bliki.htmlcleaner.BaseToken;
import info.bliki.htmlcleaner.ContentToken;
import info.bliki.htmlcleaner.EndTagToken;
import info.bliki.htmlcleaner.TagNode;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractHTMLToWiki {
    final Map<String, HTMLTag> fHashMap;
    final boolean fNoDiv;
    final boolean fNoFont;
    final boolean fNoMSWordTags;

    public AbstractHTMLToWiki(Map<String, HTMLTag> map, boolean noDiv, boolean noFont, boolean noMSWordTags) {
        this.fHashMap = map;
        this.fNoDiv = noDiv;
        this.fNoFont = noFont;
        this.fNoMSWordTags = noMSWordTags;
    }

    public AbstractHTMLToWiki(Map<String, HTMLTag> map, boolean noDiv, boolean noFont) {
        this(map, noDiv, noFont, false);
    }

    public void nodesToText(List nodes, StringBuilder resultBuffer) {
        if (nodes != null && !nodes.isEmpty()) {
            for (Object item : nodes) {
                if (item == null) continue;
                if (item instanceof List) {
                    this.nodesToText((List)item, resultBuffer);
                    continue;
                }
                if (item instanceof EndTagToken) {
                    EndTagToken node = (EndTagToken)item;
                    if (node.getName().equals("br")) {
                        resultBuffer.append("<br>");
                        continue;
                    }
                    if (!node.getName().equals("hr")) continue;
                    resultBuffer.append("\n----\n");
                    continue;
                }
                if (!(item instanceof BaseToken)) continue;
                this.nodeToWiki((BaseToken)item, resultBuffer);
            }
        }
    }

    public void nodeToWiki(BaseToken node, StringBuilder wikiText) {
        if (node instanceof ContentToken) {
            ContentToken contentToken = (ContentToken)node;
            String content = contentToken.getContent();
            content = content.replaceAll("&nbsp;", " ");
            wikiText.append(content);
        } else if (node instanceof TagNode) {
            TagNode tagNode = (TagNode)node;
            String name = tagNode.getName();
            HTMLTag tag = this.fHashMap.get(name);
            if (tag != null) {
                boolean showWithoutTag = false;
                if (this.fNoDiv && name.equals("div")) {
                    showWithoutTag = true;
                }
                if (this.fNoFont && name.equals("font")) {
                    showWithoutTag = true;
                }
                tag.content(this, tagNode, wikiText, showWithoutTag);
            } else if (name.equals("br")) {
                wikiText.append("<br>");
            } else if (name.equals("hr")) {
                wikiText.append("\n----\n");
            } else {
                List<Object> children = tagNode.getChildren();
                if (children.size() != 0) {
                    this.nodesToText(children, wikiText);
                }
            }
        }
    }

    protected void nodesToPlainText(List nodes, StringBuilder resultBuffer) {
        if (nodes != null && !nodes.isEmpty()) {
            for (Object item : nodes) {
                if (item == null) continue;
                if (item instanceof List) {
                    this.nodesToPlainText((List)item, resultBuffer);
                    continue;
                }
                if (item instanceof EndTagToken) {
                    EndTagToken node = (EndTagToken)item;
                    if (node.getName().equals("br")) {
                        resultBuffer.append(" ");
                        continue;
                    }
                    if (!node.getName().equals("hr")) continue;
                    resultBuffer.append(" ");
                    continue;
                }
                if (!(item instanceof BaseToken)) continue;
                this.nodesToPlainText((BaseToken)item, resultBuffer);
            }
        }
    }

    public void nodesToPlainText(BaseToken node, StringBuilder plainText) {
        TagNode tagNode;
        List<Object> children;
        if (node instanceof ContentToken) {
            ContentToken contentToken = (ContentToken)node;
            String content = contentToken.getContent();
            content = content.replaceAll("&nbsp;", " ");
            content = content.replaceAll("&lt;", "<");
            content = content.replaceAll("&gt;", ">");
            content = content.replaceAll("&quot;", "\"");
            content = content.replaceAll("&amp;", "&");
            content = content.replaceAll("&apos;", "'");
            plainText.append(content);
        } else if (node instanceof TagNode && (children = (tagNode = (TagNode)node).getChildren()).size() != 0) {
            this.nodesToPlainText(children, plainText);
        }
    }
}

