/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.htmlcleaner;

import info.bliki.htmlcleaner.SpecialEntities;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static String VAR_START = "${";
    public static String VAR_END = "}";

    public static String ltrim(String s) {
        int index;
        if (s == null) {
            return null;
        }
        int len = s.length();
        for (index = 0; index < len && Character.isWhitespace(s.charAt(index)); ++index) {
        }
        if (index == 0) {
            return s;
        }
        return index >= len ? "" : s.substring(index);
    }

    public static String rtrim(String s) {
        int len;
        int index;
        if (s == null) {
            return null;
        }
        for (index = len = s.length(); index > 0 && Character.isWhitespace(s.charAt(index - 1)); --index) {
        }
        if (index == len) {
            return s;
        }
        return index <= 0 ? "" : s.substring(0, index);
    }

    public static String ltrimNewline(String s) {
        int index;
        if (s == null) {
            return null;
        }
        int len = s.length();
        for (index = 0; index < len && Character.isWhitespace(s.charAt(index)) && s.charAt(index) != '\n'; ++index) {
        }
        if (index == 0) {
            return s;
        }
        return index >= len ? "" : s.substring(index);
    }

    public static String trimNewlineLeft(String s) {
        int rightIndex;
        int leftIndex;
        if (s == null) {
            return null;
        }
        int len = s.length();
        int lastIndex = -1;
        for (leftIndex = 0; leftIndex < len && Character.isWhitespace(s.charAt(leftIndex)); ++leftIndex) {
            if (s.charAt(leftIndex) != '\n') continue;
            lastIndex = leftIndex;
        }
        if (lastIndex >= 0) {
            leftIndex = lastIndex;
        }
        if (leftIndex >= len) {
            return "";
        }
        for (rightIndex = len; rightIndex > 0 && Character.isWhitespace(s.charAt(rightIndex - 1)); --rightIndex) {
        }
        if (rightIndex <= 0) {
            return "";
        }
        if (leftIndex == 0 && rightIndex == len) {
            return s;
        }
        return s.substring(leftIndex, rightIndex);
    }

    public static String trimNewlineRight(String s) {
        int leftIndex;
        if (s == null) {
            return null;
        }
        int len = s.length();
        for (leftIndex = 0; leftIndex < len && Character.isWhitespace(s.charAt(leftIndex)); ++leftIndex) {
        }
        if (leftIndex >= len) {
            return "";
        }
        int rightIndex = len;
        int lastIndex = -1;
        while (rightIndex > 0 && Character.isWhitespace(s.charAt(rightIndex - 1))) {
            if (s.charAt(--rightIndex) != '\n') continue;
            lastIndex = rightIndex + 1;
        }
        if (lastIndex >= 0) {
            rightIndex = lastIndex;
        }
        if (rightIndex <= 0) {
            return "";
        }
        if (leftIndex == 0 && rightIndex == len) {
            return s;
        }
        return s.substring(leftIndex, rightIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer readUrl(URL url, String charset) throws IOException {
        StringBuffer buffer = new StringBuffer(1024);
        Object content = url.getContent();
        if (content instanceof InputStream) {
            InputStreamReader reader = new InputStreamReader((InputStream)content, charset);
            char[] charArray = new char[1024];
            try {
                int charsRead = 0;
                do {
                    if ((charsRead = reader.read(charArray)) < 0) continue;
                    buffer.append(charArray, 0, charsRead);
                } while (charsRead > 0);
            }
            finally {
                reader.close();
            }
        }
        return buffer;
    }

    public static boolean isHexadecimalDigit(char ch) {
        return Character.isDigit(ch) || ch == 'A' || ch == 'a' || ch == 'B' || ch == 'b' || ch == 'C' || ch == 'c' || ch == 'D' || ch == 'd' || ch == 'E' || ch == 'e' || ch == 'F' || ch == 'f';
    }

    public static String escapeXml(String s, boolean advanced, boolean recognizeUnicodeChars, boolean translateSpecialEntities) {
        if (s != null && s.length() != 0) {
            int len = s.length();
            StringBuilder result = new StringBuilder(len + len / 10);
            try {
                Utils.escapeXmlToBuffer(s, result, advanced, recognizeUnicodeChars, translateSpecialEntities);
            }
            catch (IOException e) {
                return "Error in escapeXml: IOException";
            }
            return result.toString();
        }
        return "";
    }

    public static void escapeXmlToBuffer(String s, Appendable result, boolean advanced, boolean recognizeUnicodeChars, boolean translateSpecialEntities) throws IOException {
        if (s != null) {
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                char ch = s.charAt(i);
                if (ch == '&') {
                    String entity;
                    Integer code;
                    String seq;
                    int semiIndex;
                    if (recognizeUnicodeChars && i < len - 1 && s.charAt(i + 1) == '#') {
                        int charIndex;
                        String unicode = "";
                        for (charIndex = i + 2; charIndex < len && (Utils.isHexadecimalDigit(s.charAt(charIndex)) || s.charAt(charIndex) == 'x' || s.charAt(charIndex) == 'X'); ++charIndex) {
                            unicode = unicode + s.charAt(charIndex);
                        }
                        if (charIndex == len || !"".equals(unicode)) {
                            try {
                                char unicodeChar;
                                char c = unicodeChar = unicode.toLowerCase().startsWith("x") ? (char)Integer.parseInt(unicode.substring(1), 16) : (char)Integer.parseInt(unicode);
                                if ("&<>'\"".indexOf(unicodeChar) < 0) {
                                    int replaceChunkSize = charIndex < len && s.charAt(charIndex) == ';' ? unicode.length() + 1 : unicode.length();
                                    result.append(String.valueOf(unicodeChar));
                                    i += replaceChunkSize + 1;
                                    continue;
                                }
                                i = charIndex;
                                result.append("&#" + unicode + ";");
                            }
                            catch (NumberFormatException e) {
                                i = charIndex;
                                result.append("&amp;#" + unicode + ";");
                            }
                            continue;
                        }
                        result.append("&amp;");
                        continue;
                    }
                    if (translateSpecialEntities && (semiIndex = (seq = s.substring(i, i + Math.min(10, len - i))).indexOf(59)) > 0 && (code = (Integer)SpecialEntities.entities.get(entity = seq.substring(1, semiIndex))) != null) {
                        char unicodeChar;
                        int entityLen = entity.length();
                        if (recognizeUnicodeChars && "&<>'\"".indexOf(unicodeChar = (char)code.intValue()) < 0) {
                            result.append(String.valueOf(unicodeChar));
                            i += entityLen + 1;
                            continue;
                        }
                        result.append("&#");
                        result.append(Integer.toString(code));
                        result.append(";");
                        i += entityLen + 1;
                        continue;
                    }
                    if (advanced) {
                        String sub = s.substring(i);
                        if (sub.startsWith("&amp;")) {
                            result.append("&#38;");
                            i += 4;
                            continue;
                        }
                        if (sub.startsWith("&apos;")) {
                            result.append("&#39;");
                            i += 5;
                            continue;
                        }
                        if (sub.startsWith("&gt;")) {
                            result.append("&#62;");
                            i += 3;
                            continue;
                        }
                        if (sub.startsWith("&lt;")) {
                            result.append("&#60;");
                            i += 3;
                            continue;
                        }
                        if (sub.startsWith("&quot;")) {
                            result.append("&#34;");
                            i += 5;
                            continue;
                        }
                        result.append("&#38;");
                        continue;
                    }
                    result.append("&amp;");
                    continue;
                }
                if (ch == '\'') {
                    result.append("&#39;");
                    continue;
                }
                if (ch == '>') {
                    result.append("&#62;");
                    continue;
                }
                if (ch == '<') {
                    result.append("&#60;");
                    continue;
                }
                if (ch == '\"') {
                    result.append("&#34;");
                    continue;
                }
                result.append(ch);
            }
        }
    }

    public static String escapeXmlChars(String s) {
        if (s != null) {
            int len = s.length();
            StringBuilder result = new StringBuilder(len + len / 10);
            for (int i = 0; i < len; ++i) {
                char ch = s.charAt(i);
                if (ch == '\'') {
                    result.append("&apos;");
                    continue;
                }
                if (ch == '>') {
                    result.append("&gt;");
                    continue;
                }
                if (ch == '<') {
                    result.append("&lt;");
                    continue;
                }
                if (ch == '\"') {
                    result.append("&quot;");
                    continue;
                }
                result.append(ch);
            }
            return result.toString();
        }
        return null;
    }

    public static void appendAmpersandEscapedAttribute(StringBuilder writer, String attributeName, Map<String, String> tagAtttributes) {
        String attributeValue = tagAtttributes.get(attributeName);
        if (attributeValue != null) {
            if (writer.length() > 0) {
                writer.append("&amp;");
            }
            writer.append(attributeName);
            writer.append("=");
            try {
                writer.append(URLEncoder.encode(attributeValue, "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public static void appendEscapedAttribute(Appendable writer, String attributeName, Map<String, String> tagAtttributes) throws IOException {
        String attributeValue = tagAtttributes.get(attributeName);
        if (attributeValue != null) {
            Utils.escapeXmlToBuffer(attributeValue, writer, false, false, false);
        }
    }

    public static String evaluateTemplate(String template, Map<String, String> variables) {
        if (template == null) {
            return template;
        }
        StringBuffer result = new StringBuffer();
        int startIndex = template.indexOf(VAR_START);
        int endIndex = -1;
        while (startIndex >= 0 && startIndex < template.length()) {
            result.append(template.substring(endIndex + 1, startIndex));
            endIndex = template.indexOf(VAR_END, startIndex);
            if (endIndex > startIndex) {
                String varName = template.substring(startIndex + VAR_START.length(), endIndex);
                String resultObj = variables != null ? variables.get(varName.toLowerCase()) : "";
                result.append(resultObj == null ? "" : resultObj.toString());
            }
            startIndex = template.indexOf(VAR_START, Math.max(endIndex + VAR_END.length(), startIndex + 1));
        }
        result.append(template.substring(endIndex + 1));
        return result.toString();
    }
}

