/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.accessctl.util;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.eip.accessctl.bean.AccessControlFeatureBean;
import com.aimluck.eip.cayenne.om.account.EipMInactiveApplication;
import com.aimluck.eip.cayenne.om.account.EipTAclPortletFeature;
import com.aimluck.eip.cayenne.om.account.EipTAclRole;
import com.aimluck.eip.cayenne.om.account.EipTAclUserRoleMap;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AccessControlUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AccessControlUtils.class.getName());
    public static final String PORTLET_NAME = "AccessControl";

    public static EipTAclRole getEipTAclRole(RunData rundata, Context context) {
        String aclroleid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (aclroleid == null || Integer.valueOf(aclroleid) == null) {
                logger.debug((Object)"[AccessControlUtils] Empty ID...");
                return null;
            }
            Expression exp = ExpressionFactory.matchDbExp((String)"ROLE_ID", (Object)aclroleid);
            SelectQuery query = Database.query(EipTAclRole.class, (Expression)exp);
            List aclroles = query.fetchList();
            if (aclroles == null || aclroles.size() == 0) {
                logger.debug((Object)"[AccessControlUtils] Not found ID...");
                return null;
            }
            return (EipTAclRole)aclroles.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"AccessControlUtils.getEipTAclRole", (Throwable)ex);
            return null;
        }
    }

    public static List<EipTAclUserRoleMap> getEipTAclUserRoleMaps(int aclroleid) {
        try {
            SelectQuery query = Database.query(EipTAclUserRoleMap.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"eipTAclRole.ROLE_ID", (Object)aclroleid);
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.noMatchExp((String)"turbineUser.disabled", (Object)"T");
            query.andQualifier(exp2);
            List aclroles = query.fetchList();
            if (aclroles == null || aclroles.size() == 0) {
                logger.debug((Object)"[AccessControlUtils] Not found ID...");
                return null;
            }
            return aclroles;
        }
        catch (Exception ex) {
            logger.error((Object)"AccessControlUtils.getEipTAclUserRoleMaps", (Throwable)ex);
            return null;
        }
    }

    public static List<AccessControlFeatureBean> getPortletFeatureList() {
        SelectQuery query = Database.query(EipTAclPortletFeature.class);
        List inActiveApplicationList = Database.query(EipMInactiveApplication.class).fetchList();
        ArrayList<String> inActiveList = new ArrayList<String>();
        for (EipMInactiveApplication model : inActiveApplicationList) {
            inActiveList.add(model.getName().toLowerCase());
        }
        for (String portletName : inActiveList) {
            if (StringUtils.isEmpty((String)portletName)) continue;
            Expression ex = ExpressionFactory.notLikeExp((String)"featureName", (Object)(portletName + "%"));
            query.andQualifier(ex);
        }
        query.orderAscending("featureAliasName");
        List features = query.fetchList();
        if (features == null || features.size() == 0) {
            logger.debug((Object)"[AccessControlUtils] Not found ID...");
            return null;
        }
        ArrayList<AccessControlFeatureBean> list = new ArrayList<AccessControlFeatureBean>();
        for (EipTAclPortletFeature feature : features) {
            AccessControlFeatureBean featureInfo = new AccessControlFeatureBean();
            featureInfo.initField();
            featureInfo.setFeatureId(feature.getFeatureId().longValue());
            featureInfo.setFeatureName(feature.getFeatureName());
            featureInfo.setFeatureAliasName(feature.getFeatureAliasName());
            list.add(featureInfo);
        }
        return list;
    }

    public static void setupAcl(int defineAclType, int aclType, ALNumberField acl) {
        if ((aclType & defineAclType) == defineAclType) {
            acl.setValue(1L);
        }
    }
}

