/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum;

import org.apache.commons.configuration.Configuration;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.Service;
import org.apache.fulcrum.ServiceBroker;
import org.apache.fulcrum.ServiceException;
import org.apache.log4j.Category;

public abstract class BaseService
implements Service {
    protected boolean isInitialized = false;
    protected ServiceBroker serviceBroker;
    protected Configuration configuration;
    protected String name;

    public abstract void init() throws InitializationException;

    public void shutdown() {
        this.setInit(false);
    }

    public boolean getInit() {
        return this.isInitialized();
    }

    public String getStatus() throws ServiceException {
        return this.isInitialized() ? "Initialized" : "Uninitialized";
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    protected void setInit(boolean bl) {
        this.isInitialized = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setServiceBroker(ServiceBroker serviceBroker) {
        this.serviceBroker = serviceBroker;
    }

    public ServiceBroker getServiceBroker() {
        return this.serviceBroker;
    }

    public Configuration getConfiguration() {
        if (this.name == null) {
            return null;
        }
        if (this.configuration == null) {
            this.configuration = this.getServiceBroker().getConfiguration(this.name);
        }
        return this.configuration;
    }

    public Object getServiceObject(String string) {
        return this.getServiceBroker().getServiceObject(string);
    }

    public String getRealPath(String string) {
        return this.getServiceBroker().getRealPath(string);
    }

    public Category getCategory() {
        return this.getServiceBroker().getCategory();
    }
}

