/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.fulcrum.BaseService;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.InstantiationException;
import org.apache.fulcrum.Service;
import org.apache.fulcrum.ServiceBroker;
import org.apache.fulcrum.ServiceException;
import org.apache.log4j.Category;
import org.apache.log4j.helpers.NullEnumeration;

public abstract class BaseServiceBroker
implements ServiceBroker {
    protected Configuration mapping = new BaseConfiguration();
    protected Hashtable services = new Hashtable();
    protected Configuration configuration;
    public static final String SERVICE_PREFIX = "services.";
    public static final String CLASSNAME_SUFFIX = ".classname";
    protected boolean loggingConfigured;
    protected Hashtable serviceObjects = new Hashtable();
    protected Category category = Category.getInstance((String)this.getClass().getName());
    protected String applicationRoot;

    protected BaseServiceBroker() {
    }

    protected boolean isLoggingConfigured() {
        Enumeration enumeration = Category.getRoot().getAllAppenders();
        if (!(enumeration instanceof NullEnumeration)) {
            return true;
        }
        Enumeration enumeration2 = Category.getCurrentCategories();
        while (enumeration2.hasMoreElements()) {
            Category category = (Category)enumeration2.nextElement();
            if (category.getAllAppenders() instanceof NullEnumeration) continue;
            return true;
        }
        return false;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Category getCategory() {
        return this.category;
    }

    public void init() throws InitializationException {
        this.loggingConfigured = this.isLoggingConfigured();
        this.initMapping();
        this.initServices(false);
    }

    public void setServiceObject(String string, Object object) {
        this.serviceObjects.put(string, object);
    }

    public Object getServiceObject(String string) {
        return this.serviceObjects.get(string);
    }

    protected void initMapping() {
        int n = SERVICE_PREFIX.length();
        int n2 = CLASSNAME_SUFFIX.length();
        Iterator iterator = this.configuration.getKeys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.startsWith(SERVICE_PREFIX) || !string.endsWith(CLASSNAME_SUFFIX)) continue;
            String string2 = string.substring(n, string.length() - n2);
            this.notice("Added Mapping for Service: " + string2);
            if (this.mapping.containsKey(string2)) continue;
            this.mapping.setProperty(string2, (Object)this.configuration.getString(string));
        }
    }

    public boolean isRegistered(String string) {
        return this.services.get(string) != null;
    }

    public Iterator getServiceNames() {
        return this.mapping.getKeys();
    }

    public Iterator getServiceNames(String string) {
        return this.mapping.getKeys(string);
    }

    public synchronized void initService(String string) throws InitializationException {
        Service service = this.getServiceInstance(string);
        if (!service.isInitialized()) {
            service.init();
        }
    }

    public void initServices() {
        try {
            this.initServices(false);
        }
        catch (InstantiationException instantiationException) {
        }
        catch (InitializationException initializationException) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     */
    public void initServices(boolean var1_1) throws InstantiationException, InitializationException {
        block5: {
            var2_2 = this.getServiceNames();
            if (!var1_1) ** GOTO lbl15
            while (var2_2.hasNext()) {
                this.doInitService((String)var2_2.next());
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                try {
                    this.doInitService((String)var2_2.next());
                    continue;
                }
                catch (InstantiationException var3_3) {
                    this.error((Throwable)var3_3);
                    continue;
                }
                catch (InitializationException var4_4) {
                    this.error((Throwable)var4_4);
                }
lbl15:
                // 4 sources

                ** while (var2_2.hasNext())
            }
        }
        this.notice("Finished initializing all services!");
    }

    private void doInitService(String string) throws InstantiationException, InitializationException {
        if (this.getConfiguration(string).getBoolean("earlyInit", false)) {
            this.notice("Start Initializing service (early): " + string);
            this.initService(string);
            this.notice("Finish Initializing service (early): " + string);
        }
    }

    public synchronized void shutdownService(String string) {
        try {
            Service service = this.getServiceInstance(string);
            if (service != null && service.isInitialized()) {
                service.shutdown();
                if (service.isInitialized() && service instanceof BaseService) {
                    ((BaseService)service).setInit(false);
                }
            }
        }
        catch (InstantiationException instantiationException) {
            this.error((Throwable)((Object)new ServiceException("Shutdown of a nonexistent Service '" + string + "' was requested", (Throwable)((Object)instantiationException))));
        }
    }

    public void shutdownServices() {
        this.notice("Shutting down all services!");
        Iterator iterator = this.getServiceNames();
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            arrayList.add(0, string);
        }
        iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            this.notice("Shutting down service: " + string);
            this.shutdownService(string);
        }
    }

    public Service getService(String string) throws InstantiationException {
        try {
            Service service = this.getServiceInstance(string);
            if (!service.isInitialized()) {
                Class<?> clazz = service.getClass();
                synchronized (clazz) {
                    if (!service.isInitialized()) {
                        this.notice("Start Initializing service (late): " + string);
                        service.init();
                        this.notice("Finish Initializing service (late): " + string);
                    }
                }
            }
            if (!service.isInitialized()) {
                throw new InitializationException("init() failed to initialize service " + string);
            }
            return service;
        }
        catch (InitializationException initializationException) {
            throw new InstantiationException("Service " + string + " failed to initialize", (Throwable)((Object)initializationException));
        }
    }

    protected Service getServiceInstance(String string) throws InstantiationException {
        Service service = (Service)this.services.get(string);
        if (service == null) {
            block9: {
                String string2 = this.mapping.getString(string);
                if (string2 == null || string2.length() == 0) {
                    throw new InstantiationException("ServiceBroker: Unknown Service '" + string + "' requested");
                }
                try {
                    service = (Service)this.services.get(string2);
                    if (service != null) break block9;
                    try {
                        service = (Service)Class.forName(string2).newInstance();
                    }
                    catch (ThreadDeath threadDeath) {
                        throw threadDeath;
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        throw outOfMemoryError;
                    }
                    catch (Throwable throwable) {
                        String string3 = null;
                        string3 = throwable instanceof NoClassDefFoundError ? "A class referenced by " + string2 + " is unavailable. Check your jars and classes." : (throwable instanceof ClassNotFoundException ? "Class " + string2 + " is unavailable. Check your jars and classes." : (throwable instanceof ClassCastException ? "Class " + string2 + " doesn't implement the Service interface" : "Failed to instantiate " + string2));
                        throw new InstantiationException(string3, throwable);
                    }
                }
                catch (ClassCastException classCastException) {
                    throw new InstantiationException("ServiceBroker: Class " + string2 + " does not implement Service interface.", classCastException);
                }
                catch (InstantiationException instantiationException) {
                    throw new InstantiationException("Failed to instantiate service " + string, (Throwable)((Object)instantiationException));
                }
            }
            service.setServiceBroker(this);
            service.setName(string);
            this.services.put(string, service);
        }
        return service;
    }

    public Configuration getConfiguration(String string) {
        return this.configuration.subset(SERVICE_PREFIX + string);
    }

    public void notice(String string) {
        if (this.loggingConfigured) {
            this.category.info((Object)string);
        } else {
            System.out.println("NOTICE: " + string);
        }
    }

    public void error(Throwable throwable) {
        if (this.loggingConfigured) {
            this.category.info((Object)throwable);
            this.category.info((Object)this.stackTrace(throwable));
        } else {
            System.out.println("ERROR: " + throwable.getMessage());
            throwable.printStackTrace();
        }
    }

    public String stackTrace(Throwable throwable) {
        String string = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            throwable.printStackTrace(new PrintWriter(byteArrayOutputStream, true));
            string = byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public void setApplicationRoot(String string) {
        this.applicationRoot = string;
    }

    public String getApplicationRoot() {
        return this.applicationRoot;
    }

    public String getRealPath(String string) {
        return this.getApplicationRoot() + File.separator + string;
    }
}

