/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.model;

import java.lang.reflect.Method;
import java.util.Locale;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.TurbineServices;
import org.apache.fulcrum.intake.Retrievable;
import org.apache.fulcrum.intake.TurbineIntake;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.validator.InitableByConstraintMap;
import org.apache.fulcrum.intake.validator.ValidationException;
import org.apache.fulcrum.intake.validator.Validator;
import org.apache.fulcrum.intake.xmlmodel.Rule;
import org.apache.fulcrum.intake.xmlmodel.XmlField;
import org.apache.fulcrum.localization.Localization;
import org.apache.fulcrum.util.parser.ParameterParser;
import org.apache.fulcrum.util.parser.ValueParser;
import org.apache.log4j.Category;

public abstract class Field {
    private static final String EMPTY = "";
    private static final String VALUE_IF_ABSENT_KEY = "_vifa_";
    protected final String name;
    protected final String key;
    protected String displayName;
    protected final String mapToObject;
    protected Validator validator;
    protected final Method getter;
    protected final Method setter;
    protected final String ifRequiredMessage;
    protected final boolean isMultiValued;
    protected final Group group;
    protected boolean alwaysRequired;
    protected Object onError;
    protected boolean set_flag;
    protected boolean valid_flag;
    protected boolean required;
    protected boolean initialized;
    protected String message;
    protected Retrievable retrievable;
    private Locale locale;
    private String stringValue;
    private String[] stringValues;
    private Object validValue;
    private Object testValue;
    private Object[] valArray;
    protected ValueParser pp;
    Category category = Category.getInstance((String)this.getClass().getName());

    public Field(XmlField xmlField, Group group) throws Exception {
        Rule rule;
        this.group = group;
        this.key = xmlField.getKey();
        this.name = xmlField.getName();
        this.displayName = xmlField.getDisplayName();
        this.isMultiValued = xmlField.isMultiValued();
        String string = xmlField.getValidator();
        if (string == null && xmlField.getRules().size() > 0) {
            string = this.getDefaultValidator();
        } else if (string != null && string.indexOf(46) == -1) {
            string = "org.apache.fulcrum.intake.validator." + string;
        }
        if (string != null) {
            this.validator = (Validator)Class.forName(string).newInstance();
            if (this.validator instanceof InitableByConstraintMap) {
                ((InitableByConstraintMap)((Object)this.validator)).init(xmlField.getRuleMap());
            }
        }
        if ((rule = (Rule)xmlField.getRuleMap().get("required")) != null) {
            this.alwaysRequired = new Boolean(rule.getValue());
        }
        this.mapToObject = xmlField.getMapToObject();
        String string2 = xmlField.getMapToProperty();
        Method method = null;
        Method method2 = null;
        if (this.mapToObject != null && this.mapToObject.length() != 0) {
            method = TurbineIntake.getFieldGetter(this.mapToObject, string2);
            method2 = TurbineIntake.getFieldSetter(this.mapToObject, string2);
        }
        this.getter = method;
        this.setter = method2;
        this.ifRequiredMessage = xmlField.getIfRequiredMessage();
        this.valArray = new Object[1];
    }

    public Field init(ValueParser valueParser) throws ServiceException {
        this.pp = valueParser;
        this.valid_flag = true;
        if (TurbineServices.getInstance().isRegistered("LocalizationService")) {
            this.locale = valueParser instanceof ParameterParser ? Localization.getLocale(((ParameterParser)valueParser).getRequest()) : Localization.getLocale((String)null);
        }
        if (valueParser.containsKey(this.getKey()) && valueParser.getString(this.getKey()) != null) {
            this.set_flag = true;
            if (this.validate(valueParser)) {
                // empty if block
            }
        } else if (valueParser.containsKey(this.getValueIfAbsent()) && valueParser.getString(this.getValueIfAbsent()) != null) {
            valueParser.add(this.getKey(), valueParser.getString(this.getValueIfAbsent()));
            this.set_flag = true;
            this.validate(valueParser);
        }
        this.initialized = true;
        return this;
    }

    public Field init(Retrievable retrievable) {
        if (!this.initialized) {
            this.valid_flag = true;
        }
        this.retrievable = retrievable;
        return this;
    }

    protected Locale getLocale() {
        return this.locale;
    }

    protected String getDefaultValidator() {
        return "org.apache.fulcrum.intake.validator.DefaultValidator";
    }

    public Validator getValidator() {
        return this.validator;
    }

    public boolean isRequired() {
        return this.alwaysRequired || this.required;
    }

    public void setRequired(boolean bl) {
        this.setRequired(bl, this.ifRequiredMessage);
    }

    public void setRequired(boolean bl, String string) {
        this.required = bl;
        if (bl && !this.set_flag) {
            this.valid_flag = false;
            this.message = string;
        }
    }

    public void removeFromRequest() {
        this.pp.remove(this.getKey());
    }

    public void dispose() {
        this.pp = null;
        this.initialized = false;
        this.set_flag = false;
        this.valid_flag = false;
        this.required = false;
        this.message = null;
        this.retrievable = null;
        this.locale = null;
        this.stringValue = null;
        this.stringValues = null;
        this.validValue = null;
        this.testValue = null;
        this.valArray[0] = null;
    }

    public String getKey() {
        if (this.group == null) {
            return this.key;
        }
        return this.group.getObjectKey() + this.key;
    }

    public String getValueIfAbsent() {
        return this.getKey() + VALUE_IF_ABSENT_KEY;
    }

    public boolean isValid() {
        return this.valid_flag;
    }

    public boolean isSet() {
        return this.set_flag;
    }

    public String getDisplayName() {
        return this.displayName == null ? this.name : this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String getMessage() {
        if (this.message == null) {
            return EMPTY;
        }
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
        this.valid_flag = false;
    }

    protected boolean validate(ValueParser valueParser) {
        return this.validate();
    }

    protected boolean validate() {
        if (this.isMultiValued) {
            this.stringValues = this.pp.getStrings(this.getKey());
            if (this.stringValues.length == 0 || this.stringValues.length == 1 && this.stringValues[0] == null) {
                this.set_flag = false;
            }
            if (this.validator != null) {
                this.setTestValue(this.pp.getStrings(this.getKey()));
                int n = 0;
                while (n < this.stringValues.length) {
                    try {
                        this.validator.assertValidity(this.stringValues[n]);
                    }
                    catch (ValidationException validationException) {
                        this.setMessage(validationException.getMessage());
                    }
                    ++n;
                }
            }
            if (this.set_flag && this.valid_flag) {
                this.doSetValue(this.pp);
            }
        } else {
            this.stringValue = this.pp.getString(this.getKey());
            if (this.validator != null) {
                this.setTestValue(this.pp.getString(this.getKey()));
                try {
                    this.validator.assertValidity(this.stringValue);
                    if (this.set_flag) {
                        this.doSetValue(this.pp);
                    }
                }
                catch (ValidationException validationException) {
                    this.setMessage(validationException.getMessage());
                }
            } else if (this.set_flag) {
                this.doSetValue(this.pp);
            }
        }
        return this.valid_flag;
    }

    protected void doSetValue(ValueParser valueParser) {
        this.doSetValue();
    }

    protected abstract void doSetValue();

    void setInitialValue(Object object) {
        this.validValue = object;
    }

    public Object getInitialValue() throws Exception {
        if (this.validValue == null && this.retrievable != null) {
            this.getProperty(this.retrievable);
        }
        return this.validValue;
    }

    void setTestValue(Object object) {
        this.testValue = object;
    }

    public Object getTestValue() {
        return this.testValue;
    }

    public Object getValue() {
        Object object = null;
        try {
            object = this.getInitialValue();
        }
        catch (Exception exception) {
            this.category.error((Object)exception);
        }
        if (this.getTestValue() != null) {
            object = this.getTestValue();
        }
        if (object == null) {
            object = this.onError;
        }
        return object;
    }

    public String toString() {
        if (this.stringValue != null) {
            return this.stringValue;
        }
        if (this.getValue() != null) {
            return this.getValue().toString();
        }
        return EMPTY;
    }

    public void getProperty(Object object) throws Exception {
        this.validValue = this.getter.invoke(object, null);
    }

    public void setProperty(Object object) throws ServiceException {
        if (!this.isValid()) {
            throw new ServiceException("Attempted to assign an invalid input.");
        }
        if (this.isSet() && this.getTestValue() != null) {
            try {
                this.valArray[0] = this.getTestValue();
                this.setter.invoke(object, this.valArray);
            }
            catch (Exception exception) {
                throw new ServiceException("An exception prevented the setting property " + this.name + " of " + object + " to " + this.valArray[0], exception);
            }
        }
    }
}

