/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.intake.model.BigDecimalField;
import org.apache.fulcrum.intake.model.BooleanField;
import org.apache.fulcrum.intake.model.ComboKeyField;
import org.apache.fulcrum.intake.model.DateStringField;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.model.FileItemField;
import org.apache.fulcrum.intake.model.FloatField;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.model.IntegerField;
import org.apache.fulcrum.intake.model.NumberKeyField;
import org.apache.fulcrum.intake.model.StringField;
import org.apache.fulcrum.intake.model.StringKeyField;
import org.apache.fulcrum.intake.xmlmodel.XmlField;

public abstract class FieldFactory {
    private static Map fieldCtors = FieldFactory.initFieldCtors();

    private static Map initFieldCtors() {
        fieldCtors = new HashMap();
        fieldCtors.put("int", new FieldCtor(){

            public Field getInstance(XmlField xmlField, Group group) throws Exception {
                return new IntegerField(xmlField, group);
            }
        });
        fieldCtors.put("boolean", new FieldCtor(){

            public Field getInstance(XmlField xmlField, Group group) throws Exception {
                return new BooleanField(xmlField, group);
            }
        });
        fieldCtors.put("String", new FieldCtor(){

            public Field getInstance(XmlField xmlField, Group group) throws Exception {
                return new StringField(xmlField, group);
            }
        });
        fieldCtors.put("BigDecimal", new FieldCtor(){

            public Field getInstance(XmlField xmlField, Group group) throws Exception {
                return new BigDecimalField(xmlField, group);
            }
        });
        fieldCtors.put("NumberKey", new FieldCtor(){

            public Field getInstance(XmlField xmlField, Group group) throws Exception {
                return new NumberKeyField(xmlField, group);
            }
        });
        fieldCtors.put("ComboKey", new FieldCtor(){

            public Field getInstance(XmlField xmlField, Group group) throws Exception {
                return new ComboKeyField(xmlField, group);
            }
        });
        fieldCtors.put("StringKey", new FieldCtor(){

            public Field getInstance(XmlField xmlField, Group group) throws Exception {
                return new StringKeyField(xmlField, group);
            }
        });
        fieldCtors.put("FileItem", new FieldCtor(){

            public Field getInstance(XmlField xmlField, Group group) throws Exception {
                return new FileItemField(xmlField, group);
            }
        });
        fieldCtors.put("DateString", new FieldCtor(){

            public Field getInstance(XmlField xmlField, Group group) throws Exception {
                return new DateStringField(xmlField, group);
            }
        });
        fieldCtors.put("float", new FieldCtor(){

            public Field getInstance(XmlField xmlField, Group group) throws Exception {
                return new FloatField(xmlField, group);
            }
        });
        return fieldCtors;
    }

    public static final Field getInstance(XmlField xmlField, Group group) throws Exception {
        FieldCtor fieldCtor = null;
        Field field = null;
        String string = xmlField.getType();
        fieldCtor = (FieldCtor)fieldCtors.get(string);
        if (fieldCtor == null) {
            throw new ServiceException("Unsupported type: " + string);
        }
        field = fieldCtor.getInstance(xmlField, group);
        return field;
    }

    private static abstract class FieldCtor {
        private FieldCtor() {
        }

        public Field getInstance(XmlField xmlField, Group group) throws Exception {
            return null;
        }
    }
}

