/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.validator;

import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.intake.validator.Constraint;
import org.apache.fulcrum.intake.validator.InitableByConstraintMap;
import org.apache.fulcrum.intake.validator.ValidationException;
import org.apache.fulcrum.intake.validator.Validator;
import org.apache.regexp.RE;

public class FileValidator
implements Validator,
InitableByConstraintMap {
    protected boolean required;
    protected String requiredMessage;
    protected RE mask;
    protected String maskMessage;
    protected int minLength;
    protected String minLengthMessage;
    protected int maxLength;
    protected String maxLengthMessage;
    protected String message;

    public FileValidator(Map map) throws ServiceException {
        this.init(map);
    }

    public FileValidator() {
    }

    public void init(Map map) throws ServiceException {
        String string;
        this.minLength = 0;
        this.minLengthMessage = null;
        this.maxLength = 0;
        this.maxLengthMessage = null;
        Constraint constraint = (Constraint)map.get("minLength");
        if (constraint != null) {
            string = constraint.getValue();
            this.minLength = Integer.parseInt(string);
            this.minLengthMessage = constraint.getMessage();
        }
        if ((constraint = (Constraint)map.get("maxLength")) != null) {
            string = constraint.getValue();
            this.maxLength = Integer.parseInt(string);
            this.maxLengthMessage = constraint.getMessage();
        }
        if ((constraint = (Constraint)map.get("required")) == null) {
            this.required = false;
        } else {
            string = constraint.getValue();
            this.required = new Boolean(string);
            this.requiredMessage = constraint.getMessage();
        }
    }

    public boolean isValid(String string) {
        boolean bl = false;
        try {
            this.assertValidity(string);
            bl = true;
        }
        catch (ValidationException validationException) {
            bl = false;
        }
        return bl;
    }

    public void assertValidity(String string) throws ValidationException {
        throw new ValidationException("this validation is not implemented");
    }

    public void assertValidity(FileItem fileItem) throws ValidationException {
        this.message = null;
        if (!(this.required || this.minLength != 0 || fileItem != null && fileItem.getSize() != 0L)) {
            return;
        }
        if (this.required && (fileItem == null || fileItem.getSize() == 0L)) {
            this.message = this.requiredMessage;
            throw new ValidationException(this.requiredMessage);
        }
        this.doAssertValidity(fileItem);
        if (this.minLength > 0 && fileItem.getSize() < (long)this.minLength) {
            this.message = this.minLengthMessage;
            throw new ValidationException(this.minLengthMessage);
        }
        if (this.maxLength > 0 && fileItem.getSize() > (long)this.maxLength) {
            this.message = this.maxLengthMessage;
            throw new ValidationException(this.maxLengthMessage);
        }
    }

    public String getMessage() {
        if (this.message == null) {
            return "";
        }
        return this.message;
    }

    protected void doAssertValidity(FileItem fileItem) throws ValidationException {
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public String getRequiredMessage() {
        return this.requiredMessage;
    }

    public void setRequiredMessage(String string) {
        this.requiredMessage = string;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int n) {
        this.minLength = n;
    }

    public String getMinLengthMessage() {
        return this.minLengthMessage;
    }

    public void setMinLengthMessage(String string) {
        this.minLengthMessage = string;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int n) {
        this.maxLength = n;
    }

    public String getMaxLengthMessage() {
        return this.maxLengthMessage;
    }

    public void setMaxLengthMessage(String string) {
        this.maxLengthMessage = string;
    }
}

