/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.mimetype.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class CharSetMap {
    public static final String DEFAULT_CHARSET = "ISO-8859-1";
    public static final String CHARSET_RESOURCE = "charset.properties";
    private static final int MAP_CACHE = 0;
    private static final int MAP_PROG = 1;
    private static final int MAP_HOME = 2;
    private static final int MAP_SYS = 3;
    private static final int MAP_JAR = 4;
    private static final int MAP_COM = 5;
    private static HashMap commonMapper = new HashMap();
    private Map[] mappers = new Map[6];
    static /* synthetic */ Class class$org$apache$fulcrum$mimetype$util$CharSetMap;

    protected static Map loadStream(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        return new HashMap<Object, Object>(properties);
    }

    protected static Map loadFile(File file) throws IOException {
        return CharSetMap.loadStream(new FileInputStream(file));
    }

    protected static Map loadPath(String string) throws IOException {
        return CharSetMap.loadFile(new File(string));
    }

    protected static Map loadResource(String string) {
        InputStream inputStream = (class$org$apache$fulcrum$mimetype$util$CharSetMap == null ? (class$org$apache$fulcrum$mimetype$util$CharSetMap = CharSetMap.class$("org.apache.fulcrum.mimetype.util.CharSetMap")) : class$org$apache$fulcrum$mimetype$util$CharSetMap).getResourceAsStream(string);
        if (inputStream != null) {
            try {
                return CharSetMap.loadStream(inputStream);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    public CharSetMap() {
        String string;
        try {
            string = System.getProperty("user.home");
            if (string != null) {
                string = string + File.separator + CHARSET_RESOURCE;
                this.mappers[2] = CharSetMap.loadPath(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string = System.getProperty("java.home") + File.separator + "lib" + File.separator + CHARSET_RESOURCE;
            this.mappers[3] = CharSetMap.loadPath(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mappers[4] = CharSetMap.loadResource("/META-INF/charset.properties");
        this.mappers[5] = commonMapper;
        this.mappers[0] = new Hashtable();
    }

    public CharSetMap(Properties properties) {
        this();
        this.mappers[1] = new HashMap<Object, Object>(properties);
    }

    public CharSetMap(InputStream inputStream) throws IOException {
        this();
        this.mappers[1] = CharSetMap.loadStream(inputStream);
    }

    public CharSetMap(File file) throws IOException {
        this();
        this.mappers[1] = CharSetMap.loadFile(file);
    }

    public CharSetMap(String string) throws IOException {
        this();
        this.mappers[1] = CharSetMap.loadPath(string);
    }

    public synchronized void setCharSet(String string, String string2) {
        HashMap<String, String> hashMap = (HashMap<String, String>)this.mappers[1];
        hashMap = hashMap != null ? (HashMap)hashMap.clone() : new HashMap<String, String>();
        hashMap.put(string, string2);
        this.mappers[1] = hashMap;
        this.mappers[0].clear();
    }

    public String getCharSet(Locale locale) {
        String string = locale.toString();
        if (string.length() == 0 && (string = "__" + locale.getVariant()).length() == 2) {
            return DEFAULT_CHARSET;
        }
        String string2 = this.searchCharSet(string);
        if (string2.length() == 0) {
            String[] stringArray = new String[3];
            stringArray[2] = locale.getVariant();
            stringArray[1] = locale.getCountry();
            stringArray[0] = locale.getLanguage();
            string2 = this.searchCharSet(stringArray);
            if (string2.length() == 0) {
                string2 = DEFAULT_CHARSET;
            }
            this.mappers[0].put(string, string2);
        }
        return string2;
    }

    public String getCharSet(Locale locale, String string) {
        if (string != null && string.length() > 0) {
            String string2 = locale.toString();
            string2 = string2.length() == 0 ? ((string2 = "__" + locale.getVariant()).length() > 2 ? string2 + '_' + string : string2 + string) : (locale.getCountry().length() == 0 ? string2 + "__" + string : string2 + '_' + string);
            String string3 = this.searchCharSet(string2);
            if (string3.length() == 0) {
                String[] stringArray = new String[4];
                stringArray[3] = string;
                stringArray[2] = locale.getVariant();
                stringArray[1] = locale.getCountry();
                stringArray[0] = locale.getLanguage();
                string3 = this.searchCharSet(stringArray);
                if (string3.length() == 0) {
                    string3 = DEFAULT_CHARSET;
                }
                this.mappers[0].put(string2, string3);
            }
            return string3;
        }
        return this.getCharSet(locale);
    }

    public String getCharSet(String string) {
        String string2 = this.searchCharSet(string);
        return string2.length() > 0 ? string2 : DEFAULT_CHARSET;
    }

    public String getCharSet(String string, String string2) {
        String string3 = this.searchCharSet(string);
        return string3.length() > 0 ? string3 : string2;
    }

    private String searchCharSet(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = stringArray.length;
        while (n > 0) {
            String string = this.searchCharSet(stringArray, stringBuffer, n);
            if (string.length() > 0) {
                return string;
            }
            stringBuffer.setLength(0);
            --n;
        }
        return "";
    }

    private String searchCharSet(String[] stringArray, StringBuffer stringBuffer, int n) {
        if (--n >= 0 && stringArray[n] != null && stringArray[n].length() > 0) {
            stringBuffer.insert(0, stringArray[n]);
            int n2 = stringBuffer.length();
            int n3 = n;
            while (n3 > 0) {
                String string;
                if (n3 == n || n3 <= 1) {
                    stringBuffer.insert(0, '_');
                    ++n2;
                }
                if ((string = this.searchCharSet(stringArray, stringBuffer, n3)).length() > 0) {
                    return string;
                }
                stringBuffer.delete(0, stringBuffer.length() - n2);
                --n3;
            }
            return this.searchCharSet(stringBuffer.toString());
        }
        return "";
    }

    private String searchCharSet(String string) {
        if (string != null && string.length() > 0) {
            int n = 0;
            while (n < this.mappers.length) {
                String string2;
                Map map = this.mappers[n];
                if (map != null && (string2 = (String)map.get(string)) != null) {
                    if (n > 0) {
                        this.mappers[0].put(string, string2);
                    }
                    return string2;
                }
                ++n;
            }
            this.mappers[0].put(string, "");
        }
        return "";
    }

    protected synchronized void setCommonCharSet(String string, String string2) {
        HashMap hashMap = (HashMap)((HashMap)this.mappers[5]).clone();
        hashMap.put(string, string2);
        this.mappers[5] = hashMap;
        this.mappers[0].clear();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        commonMapper.put("ar", "ISO-8859-6");
        commonMapper.put("be", "ISO-8859-5");
        commonMapper.put("bg", "ISO-8859-5");
        commonMapper.put("ca", DEFAULT_CHARSET);
        commonMapper.put("cs", "ISO-8859-2");
        commonMapper.put("da", DEFAULT_CHARSET);
        commonMapper.put("de", DEFAULT_CHARSET);
        commonMapper.put("el", "ISO-8859-7");
        commonMapper.put("en", DEFAULT_CHARSET);
        commonMapper.put("es", DEFAULT_CHARSET);
        commonMapper.put("et", DEFAULT_CHARSET);
        commonMapper.put("fi", DEFAULT_CHARSET);
        commonMapper.put("fr", DEFAULT_CHARSET);
        commonMapper.put("hr", "ISO-8859-2");
        commonMapper.put("hu", "ISO-8859-2");
        commonMapper.put("is", DEFAULT_CHARSET);
        commonMapper.put("it", DEFAULT_CHARSET);
        commonMapper.put("iw", "ISO-8859-8");
        commonMapper.put("ja", "Shift_JIS");
        commonMapper.put("ko", "EUC-KR");
        commonMapper.put("lt", "ISO-8859-2");
        commonMapper.put("lv", "ISO-8859-2");
        commonMapper.put("mk", "ISO-8859-5");
        commonMapper.put("nl", DEFAULT_CHARSET);
        commonMapper.put("no", DEFAULT_CHARSET);
        commonMapper.put("pl", "ISO-8859-2");
        commonMapper.put("pt", DEFAULT_CHARSET);
        commonMapper.put("ro", "ISO-8859-2");
        commonMapper.put("ru", "ISO-8859-5");
        commonMapper.put("sh", "ISO-8859-5");
        commonMapper.put("sk", "ISO-8859-2");
        commonMapper.put("sl", "ISO-8859-2");
        commonMapper.put("sq", "ISO-8859-2");
        commonMapper.put("sr", "ISO-8859-5");
        commonMapper.put("sv", DEFAULT_CHARSET);
        commonMapper.put("tr", "ISO-8859-9");
        commonMapper.put("uk", "ISO-8859-5");
        commonMapper.put("zh", "GB2312");
        commonMapper.put("zh_TW", "Big5");
    }
}

