/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security;

import org.apache.fulcrum.TurbineServices;
import org.apache.fulcrum.security.SecurityService;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.util.AccessControlList;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.GroupSet;
import org.apache.fulcrum.security.util.PasswordMismatchException;
import org.apache.fulcrum.security.util.PermissionSet;
import org.apache.fulcrum.security.util.RoleSet;
import org.apache.fulcrum.security.util.TurbineSecurityException;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.torque.util.Criteria;

public abstract class TurbineSecurity {
    public static SecurityService getService() {
        return (SecurityService)TurbineServices.getInstance().getService("SecurityService");
    }

    public static String encryptPassword(String string) {
        return TurbineSecurity.getService().encryptPassword(string);
    }

    public static Class getUserClass() throws UnknownEntityException {
        return TurbineSecurity.getService().getUserClass();
    }

    public static User getUserInstance() throws UnknownEntityException {
        return TurbineSecurity.getService().getUserInstance();
    }

    public static boolean accountExists(User user) throws DataBackendException {
        return TurbineSecurity.getService().accountExists(user);
    }

    public static boolean accountExists(String string) throws DataBackendException {
        return TurbineSecurity.getService().accountExists(string);
    }

    public static User getAuthenticatedUser(String string, String string2) throws DataBackendException, UnknownEntityException, PasswordMismatchException {
        return TurbineSecurity.getService().getAuthenticatedUser(string, string2);
    }

    public static User getUser(String string) throws DataBackendException, UnknownEntityException {
        return TurbineSecurity.getService().getUser(string);
    }

    public static User[] getUsers(Criteria criteria) throws DataBackendException {
        return TurbineSecurity.getService().getUsers(criteria);
    }

    public static User getAnonymousUser() throws UnknownEntityException {
        return TurbineSecurity.getService().getAnonymousUser();
    }

    public static void saveUser(User user) throws UnknownEntityException, DataBackendException {
        TurbineSecurity.getService().saveUser(user);
    }

    public static void changePassword(User user, String string, String string2) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        TurbineSecurity.getService().changePassword(user, string, string2);
    }

    public static void forcePassword(User user, String string) throws UnknownEntityException, DataBackendException {
        TurbineSecurity.getService().forcePassword(user, string);
    }

    public static AccessControlList getACL(User user) throws DataBackendException, UnknownEntityException {
        return TurbineSecurity.getService().getACL(user);
    }

    public static void grant(User user, Group group, Role role) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().grant(user, group, role);
    }

    public static void revoke(User user, Group group, Role role) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().revoke(user, group, role);
    }

    public static void revokeAll(User user) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().revokeAll(user);
    }

    public static void grant(Role role, Permission permission) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().grant(role, permission);
    }

    public static void revoke(Role role, Permission permission) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().revoke(role, permission);
    }

    public static void revokeAll(Role role) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().revokeAll(role);
    }

    public static void addUser(User user, String string) throws DataBackendException, EntityExistsException {
        TurbineSecurity.getService().addUser(user, string);
    }

    public static void removeUser(User user) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().removeUser(user);
    }

    public static Group getGlobalGroup() {
        return TurbineSecurity.getService().getGlobalGroup();
    }

    public static Group createGroup(String string) throws TurbineSecurityException {
        return TurbineSecurity.getService().addGroup(TurbineSecurity.getNewGroup(string));
    }

    public static Permission createPermission(String string) throws TurbineSecurityException {
        return TurbineSecurity.getService().addPermission(TurbineSecurity.getNewPermission(string));
    }

    public static Group getGroup(String string) throws DataBackendException, UnknownEntityException {
        return TurbineSecurity.getService().getGroup(string);
    }

    public static Group getNewGroup(String string) throws DataBackendException {
        return TurbineSecurity.getService().getNewGroup(string);
    }

    public static Role getNewRole(String string) throws TurbineSecurityException {
        return TurbineSecurity.getService().getNewRole(string);
    }

    public static Permission getNewPermission(String string) throws DataBackendException {
        return TurbineSecurity.getService().getNewPermission(string);
    }

    public static Role getRole(String string) throws DataBackendException, UnknownEntityException {
        return TurbineSecurity.getService().getRole(string);
    }

    public static Permission getPermission(String string) throws DataBackendException, UnknownEntityException {
        return TurbineSecurity.getService().getPermission(string);
    }

    public static GroupSet getGroups(Criteria criteria) throws DataBackendException {
        return TurbineSecurity.getService().getGroups(criteria);
    }

    public static RoleSet getRoles(Criteria criteria) throws DataBackendException {
        return TurbineSecurity.getService().getRoles(criteria);
    }

    public static PermissionSet getPermissions(Criteria criteria) throws DataBackendException {
        return TurbineSecurity.getService().getPermissions(criteria);
    }

    public static GroupSet getAllGroups() throws DataBackendException {
        return TurbineSecurity.getService().getAllGroups();
    }

    public static RoleSet getAllRoles() throws DataBackendException {
        return TurbineSecurity.getService().getAllRoles();
    }

    public static PermissionSet getAllPermissions() throws DataBackendException {
        return TurbineSecurity.getService().getAllPermissions();
    }

    public static PermissionSet getPermissions(Role role) throws DataBackendException, UnknownEntityException {
        return TurbineSecurity.getService().getPermissions(role);
    }

    public static void saveGroup(Group group) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().saveGroup(group);
    }

    public static void saveRole(Role role) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().saveRole(role);
    }

    public static void savePermission(Permission permission) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().savePermission(permission);
    }

    public static void addGroup(Group group) throws DataBackendException, EntityExistsException {
        TurbineSecurity.getService().addGroup(group);
    }

    public static void addRole(Role role) throws DataBackendException, EntityExistsException {
        TurbineSecurity.getService().addRole(role);
    }

    public static void addPermission(Permission permission) throws DataBackendException, EntityExistsException {
        TurbineSecurity.getService().addPermission(permission);
    }

    public static void removeGroup(Group group) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().removeGroup(group);
    }

    public static void removeRole(Role role) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().removeRole(role);
    }

    public static void removePermission(Permission permission) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().removePermission(permission);
    }

    public static void renameGroup(Group group, String string) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().renameGroup(group, string);
    }

    public static void renameRole(Role role, String string) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().renameRole(role, string);
    }

    public static void renamePermission(Permission permission, String string) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().renamePermission(permission, string);
    }
}

