/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.impl.db;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.fulcrum.security.BaseSecurityService;
import org.apache.fulcrum.security.TurbineSecurity;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.impl.db.entity.BaseTurbineGroupPeer;
import org.apache.fulcrum.security.impl.db.entity.BaseTurbinePermissionPeer;
import org.apache.fulcrum.security.impl.db.entity.BaseTurbineRolePeer;
import org.apache.fulcrum.security.impl.db.entity.BaseTurbineRolePermissionPeer;
import org.apache.fulcrum.security.impl.db.entity.BaseTurbineUserGroupRolePeer;
import org.apache.fulcrum.security.impl.db.entity.TurbineGroup;
import org.apache.fulcrum.security.impl.db.entity.TurbineGroupPeer;
import org.apache.fulcrum.security.impl.db.entity.TurbinePermission;
import org.apache.fulcrum.security.impl.db.entity.TurbinePermissionPeer;
import org.apache.fulcrum.security.impl.db.entity.TurbineRole;
import org.apache.fulcrum.security.impl.db.entity.TurbineRolePeer;
import org.apache.fulcrum.security.impl.db.entity.UserPeer;
import org.apache.fulcrum.security.util.AccessControlList;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.GroupSet;
import org.apache.fulcrum.security.util.PermissionSet;
import org.apache.fulcrum.security.util.RoleSet;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.log4j.Category;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.Criteria;

public class DBSecurityService
extends BaseSecurityService {
    public static final String USER_PEER_CLASS_KEY = "userPeer.class";
    public static final String USER_PEER_CLASS_DEFAULT = "org.apache.turbine.om.security.TurbineUserPeer";
    Category category = Category.getInstance((String)this.getClass().getName());

    public AccessControlList getACL(User user) throws DataBackendException, UnknownEntityException {
        if (!TurbineSecurity.accountExists(user)) {
            throw new UnknownEntityException("The account '" + user.getUserName() + "' does not exist");
        }
        try {
            try {
                Object object;
                Hashtable<Object, RoleSet> hashtable = new Hashtable<Object, RoleSet>();
                Hashtable<Object, PermissionSet> hashtable2 = new Hashtable<Object, PermissionSet>();
                this.lockShared();
                Iterator iterator = this.getAllGroups().elements();
                while (iterator.hasNext()) {
                    object = (Group)iterator.next();
                    RoleSet roleSet = TurbineRolePeer.retrieveSet(user, (Group)object);
                    hashtable.put(object, roleSet);
                    PermissionSet permissionSet = new PermissionSet();
                    Iterator iterator2 = roleSet.elements();
                    while (iterator2.hasNext()) {
                        Role role = (Role)iterator2.next();
                        PermissionSet permissionSet2 = TurbinePermissionPeer.retrieveSet(role);
                        permissionSet.add(permissionSet2);
                    }
                    hashtable2.put(object, permissionSet);
                }
                object = new AccessControlList(hashtable, hashtable2);
                Object var12_12 = null;
                this.unlockShared();
                return object;
            }
            catch (Exception exception) {
                throw new DataBackendException("Failed to build ACL for user '" + user.getUserName() + "'", exception);
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            this.unlockShared();
            throw throwable;
        }
    }

    public synchronized void grant(User user, Group group, Role role) throws DataBackendException, UnknownEntityException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            try {
                this.lockExclusive();
                bl = TurbineSecurity.accountExists(user);
                bl2 = this.checkExists(group);
                bl3 = this.checkExists(role);
                if (bl && bl2 && bl3) {
                    Criteria criteria = new Criteria();
                    criteria.add(BaseTurbineUserGroupRolePeer.USER_ID, (Object)((BaseObject)user).getPrimaryKey());
                    criteria.add(BaseTurbineUserGroupRolePeer.GROUP_ID, (Object)((BaseObject)group).getPrimaryKey());
                    criteria.add(BaseTurbineUserGroupRolePeer.ROLE_ID, (Object)((TurbineRole)role).getPrimaryKey());
                    BaseTurbineUserGroupRolePeer.doInsert(criteria);
                    Object var9_9 = null;
                    this.unlockExclusive();
                    return;
                }
                Object var9_10 = null;
                this.unlockExclusive();
            }
            catch (Exception exception) {
                throw new DataBackendException("grant(User,Group,Role) failed", exception);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.unlockExclusive();
            throw throwable;
        }
        if (!bl) {
            throw new UnknownEntityException("Unknown user '" + user.getUserName() + "'");
        }
        if (!bl2) {
            throw new UnknownEntityException("Unknown group '" + group.getName() + "'");
        }
        if (!bl3) {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
    }

    public synchronized void revoke(User user, Group group, Role role) throws DataBackendException, UnknownEntityException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            try {
                this.lockExclusive();
                bl = TurbineSecurity.accountExists(user);
                bl2 = this.checkExists(group);
                bl3 = this.checkExists(role);
                if (bl && bl2 && bl3) {
                    Criteria criteria = new Criteria();
                    criteria.add(BaseTurbineUserGroupRolePeer.USER_ID, (Object)((BaseObject)user).getPrimaryKey());
                    criteria.add(BaseTurbineUserGroupRolePeer.GROUP_ID, (Object)((BaseObject)group).getPrimaryKey());
                    criteria.add(BaseTurbineUserGroupRolePeer.ROLE_ID, (Object)((TurbineRole)role).getPrimaryKey());
                    BaseTurbineUserGroupRolePeer.doDelete(criteria);
                    Object var9_9 = null;
                    this.unlockExclusive();
                    return;
                }
                Object var9_10 = null;
                this.unlockExclusive();
            }
            catch (Exception exception) {
                throw new DataBackendException("revoke(User,Role,Group) failed", exception);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.unlockExclusive();
            throw throwable;
        }
        if (!bl) {
            throw new UnknownEntityException("Unknown user '" + user.getUserName() + "'");
        }
        if (!bl2) {
            throw new UnknownEntityException("Unknown group '" + group.getName() + "'");
        }
        if (!bl3) {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
    }

    public synchronized void revokeAll(User user) throws DataBackendException, UnknownEntityException {
        boolean bl = false;
        try {
            try {
                this.lockExclusive();
                bl = TurbineSecurity.accountExists(user);
                if (bl) {
                    ObjectKey objectKey = ((BaseObject)user).getPrimaryKey();
                    BasePeer.deleteAll((String)"TURBINE_USER_GROUP_ROLE", (String)BaseTurbineUserGroupRolePeer.USER_ID, (int)((BigDecimal)objectKey.getValue()).intValue());
                    Object var5_5 = null;
                    this.unlockExclusive();
                    return;
                }
                Object var5_6 = null;
                this.unlockExclusive();
            }
            catch (Exception exception) {
                throw new DataBackendException("revokeAll(User) failed", exception);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.unlockExclusive();
            throw throwable;
        }
        throw new UnknownEntityException("Unknown user '" + user.getUserName() + '\'');
    }

    public synchronized void grant(Role role, Permission permission) throws DataBackendException, UnknownEntityException {
        boolean bl = false;
        boolean bl2 = false;
        try {
            try {
                this.lockExclusive();
                bl = this.checkExists(role);
                bl2 = this.checkExists(permission);
                if (bl && bl2) {
                    Criteria criteria = new Criteria();
                    criteria.add(BaseTurbineRolePermissionPeer.ROLE_ID, (Object)((TurbineRole)role).getPrimaryKey());
                    criteria.add(BaseTurbineRolePermissionPeer.PERMISSION_ID, (Object)((BaseObject)permission).getPrimaryKey());
                    BaseTurbineUserGroupRolePeer.doInsert(criteria);
                    Object var7_7 = null;
                    this.unlockExclusive();
                    return;
                }
                Object var7_8 = null;
                this.unlockExclusive();
            }
            catch (Exception exception) {
                throw new DataBackendException("grant(Role,Permission) failed", exception);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.unlockExclusive();
            throw throwable;
        }
        if (!bl) {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
        if (!bl2) {
            throw new UnknownEntityException("Unknown permission '" + permission.getName() + "'");
        }
    }

    public synchronized void revoke(Role role, Permission permission) throws DataBackendException, UnknownEntityException {
        boolean bl = false;
        boolean bl2 = false;
        try {
            try {
                this.lockExclusive();
                bl = this.checkExists(role);
                bl2 = this.checkExists(permission);
                if (bl && bl2) {
                    Criteria criteria = new Criteria();
                    criteria.add(BaseTurbineRolePermissionPeer.ROLE_ID, (Object)((TurbineRole)role).getPrimaryKey());
                    criteria.add(BaseTurbineRolePermissionPeer.PERMISSION_ID, (Object)((BaseObject)permission).getPrimaryKey());
                    BaseTurbineRolePermissionPeer.doDelete(criteria);
                    Object var7_7 = null;
                    this.unlockExclusive();
                    return;
                }
                Object var7_8 = null;
                this.unlockExclusive();
            }
            catch (Exception exception) {
                throw new DataBackendException("revoke(Role,Permission) failed", exception);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.unlockExclusive();
            throw throwable;
        }
        if (!bl) {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
        if (!bl2) {
            throw new UnknownEntityException("Unknown permission '" + permission.getName() + "'");
        }
    }

    public synchronized void revokeAll(Role role) throws DataBackendException, UnknownEntityException {
        boolean bl = false;
        try {
            try {
                this.lockExclusive();
                bl = this.checkExists(role);
                if (bl) {
                    ObjectKey objectKey = ((TurbineRole)role).getPrimaryKey();
                    BasePeer.deleteAll((String)"TURBINE_ROLE_PERMISSION", (String)BaseTurbineRolePermissionPeer.ROLE_ID, (int)((BigDecimal)objectKey.getValue()).intValue());
                    Object var5_5 = null;
                    this.unlockExclusive();
                    return;
                }
                Object var5_6 = null;
                this.unlockExclusive();
            }
            catch (Exception exception) {
                throw new DataBackendException("revokeAll(Role) failed", exception);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.unlockExclusive();
            throw throwable;
        }
        throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
    }

    public GroupSet getGroups(Criteria criteria) throws DataBackendException {
        Object object;
        Criteria criteria2 = new Criteria();
        Iterator iterator = criteria.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            criteria2.put((Object)TurbineGroupPeer.getColumnName((String)object), criteria.get(object));
        }
        object = new Vector(0);
        try {
            object = BaseTurbineGroupPeer.doSelect(criteria);
        }
        catch (Exception exception) {
            throw new DataBackendException("getGroups(Criteria) failed", exception);
        }
        return new GroupSet((Collection)object);
    }

    public RoleSet getRoles(Criteria criteria) throws DataBackendException {
        Object object;
        Criteria criteria2 = new Criteria();
        Iterator iterator = criteria.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            criteria2.put((Object)TurbineRolePeer.getColumnName((String)object), criteria.get(object));
        }
        object = new Vector(0);
        try {
            object = BaseTurbineRolePeer.doSelect(criteria);
        }
        catch (Exception exception) {
            throw new DataBackendException("getRoles(Criteria) failed", exception);
        }
        return new RoleSet((Collection)object);
    }

    public PermissionSet getPermissions(Criteria criteria) throws DataBackendException {
        Object object;
        Criteria criteria2 = new Criteria();
        Iterator iterator = criteria.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            criteria2.put((Object)TurbinePermissionPeer.getColumnName((String)object), criteria.get(object));
        }
        object = new Vector(0);
        try {
            object = BaseTurbinePermissionPeer.doSelect(criteria);
        }
        catch (Exception exception) {
            throw new DataBackendException("getPermissions(Criteria) failed", exception);
        }
        return new PermissionSet((Collection)object);
    }

    public PermissionSet getPermissions(Role role) throws DataBackendException, UnknownEntityException {
        boolean bl = false;
        try {
            try {
                this.lockShared();
                bl = this.checkExists(role);
                if (bl) {
                    PermissionSet permissionSet = TurbinePermissionPeer.retrieveSet(role);
                    Object var5_5 = null;
                    this.unlockShared();
                    return permissionSet;
                }
                Object var5_6 = null;
                this.unlockShared();
            }
            catch (Exception exception) {
                throw new DataBackendException("getPermissions(Role) failed", exception);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.unlockShared();
            throw throwable;
        }
        throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
    }

    public void saveGroup(Group group) throws DataBackendException, UnknownEntityException {
        boolean bl = false;
        try {
            bl = this.checkExists(group);
            if (bl) {
                Criteria criteria = BaseTurbineGroupPeer.buildCriteria((TurbineGroup)group);
                BaseTurbineGroupPeer.doUpdate(criteria);
                return;
            }
        }
        catch (Exception exception) {
            throw new DataBackendException("saveGroup(Group) failed", exception);
        }
        throw new UnknownEntityException("Unknown group '" + group + "'");
    }

    public void saveRole(Role role) throws DataBackendException, UnknownEntityException {
        boolean bl = false;
        try {
            bl = this.checkExists(role);
            if (bl) {
                Criteria criteria = BaseTurbineRolePeer.buildCriteria((TurbineRole)role);
                BaseTurbineRolePeer.doUpdate(criteria);
                return;
            }
        }
        catch (Exception exception) {
            throw new DataBackendException("saveRole(Role) failed", exception);
        }
        throw new UnknownEntityException("Unknown role '" + role + "'");
    }

    public void savePermission(Permission permission) throws DataBackendException, UnknownEntityException {
        boolean bl = false;
        try {
            bl = this.checkExists(permission);
            if (bl) {
                Criteria criteria = BaseTurbinePermissionPeer.buildCriteria((TurbinePermission)permission);
                BaseTurbinePermissionPeer.doUpdate(criteria);
                return;
            }
        }
        catch (Exception exception) {
            throw new DataBackendException("savePermission(Permission) failed", exception);
        }
        throw new UnknownEntityException("Unknown permission '" + permission + "'");
    }

    public Group getNewGroup(String string) {
        return new TurbineGroup(string);
    }

    public Role getNewRole(String string) {
        return new TurbineRole(string);
    }

    public Permission getNewPermission(String string) {
        return new TurbinePermission(string);
    }

    public synchronized Group addGroup(Group group) throws DataBackendException, EntityExistsException {
        boolean bl = false;
        try {
            try {
                this.lockExclusive();
                bl = this.checkExists(group);
                if (!bl) {
                    Criteria criteria = BaseTurbineGroupPeer.buildCriteria((TurbineGroup)group);
                    BaseTurbineGroupPeer.doInsert(criteria);
                    criteria = new Criteria();
                    criteria.add(TurbineGroupPeer.NAME, (Object)group.getName());
                    Vector vector = BaseTurbineGroupPeer.doSelect(criteria);
                    if (vector.size() != 1) {
                        throw new DataBackendException("Internal error - query returned " + vector.size() + " rows");
                    }
                    Group group2 = (Group)vector.get(0);
                    this.getAllGroups().add(group2);
                    Group group3 = group2;
                    Object var8_8 = null;
                    this.unlockExclusive();
                    return group3;
                }
                Object var8_9 = null;
                this.unlockExclusive();
            }
            catch (Exception exception) {
                throw new DataBackendException("addGroup(Group) failed", exception);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.unlockExclusive();
            throw throwable;
        }
        throw new EntityExistsException("Group '" + group + "' already exists");
    }

    public synchronized Role addRole(Role role) throws DataBackendException, EntityExistsException {
        boolean bl = false;
        try {
            try {
                this.lockExclusive();
                bl = this.checkExists(role);
                if (!bl) {
                    Criteria criteria = BaseTurbineRolePeer.buildCriteria((TurbineRole)role);
                    BaseTurbineRolePeer.doInsert(criteria);
                    criteria = new Criteria();
                    criteria.add(TurbineRolePeer.NAME, (Object)role.getName());
                    Vector vector = BaseTurbineRolePeer.doSelect(criteria);
                    if (vector.size() != 1) {
                        throw new DataBackendException("Internal error - query returned " + vector.size() + " rows");
                    }
                    Role role2 = (Role)vector.get(0);
                    this.getAllRoles().add(role2);
                    Role role3 = role2;
                    Object var8_8 = null;
                    this.unlockExclusive();
                    return role3;
                }
                Object var8_9 = null;
                this.unlockExclusive();
            }
            catch (Exception exception) {
                throw new DataBackendException("addRole(Role) failed", exception);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.unlockExclusive();
            throw throwable;
        }
        throw new EntityExistsException("Role '" + role + "' already exists");
    }

    public synchronized Permission addPermission(Permission permission) throws DataBackendException, EntityExistsException {
        boolean bl = false;
        try {
            try {
                this.lockExclusive();
                bl = this.checkExists(permission);
                if (!bl) {
                    Criteria criteria = BaseTurbinePermissionPeer.buildCriteria((TurbinePermission)permission);
                    BaseTurbinePermissionPeer.doInsert(criteria);
                    criteria = new Criteria();
                    criteria.add(TurbinePermissionPeer.NAME, (Object)permission.getName());
                    Vector vector = BaseTurbinePermissionPeer.doSelect(criteria);
                    if (vector.size() != 1) {
                        throw new DataBackendException("Internal error - query returned " + vector.size() + " rows");
                    }
                    Permission permission2 = (Permission)vector.get(0);
                    this.getAllPermissions().add(permission2);
                    Permission permission3 = permission2;
                    Object var8_8 = null;
                    this.unlockExclusive();
                    return permission3;
                }
                Object var8_9 = null;
                this.unlockExclusive();
            }
            catch (Exception exception) {
                throw new DataBackendException("addPermission(Permission) failed", exception);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.unlockExclusive();
            throw throwable;
        }
        throw new EntityExistsException("Permission '" + permission + "' already exists");
    }

    public synchronized void removeGroup(Group group) throws DataBackendException, UnknownEntityException {
        boolean bl = false;
        try {
            try {
                this.lockExclusive();
                bl = this.checkExists(group);
                if (bl) {
                    Criteria criteria = BaseTurbineGroupPeer.buildCriteria((TurbineGroup)group);
                    BaseTurbineGroupPeer.doDelete(criteria);
                    this.getAllGroups().remove(group);
                    Object var5_5 = null;
                    this.unlockExclusive();
                    return;
                }
                Object var5_6 = null;
                this.unlockExclusive();
            }
            catch (Exception exception) {
                this.category.error((Object)"Failed to delete a Group");
                this.category.error((Object)exception);
                throw new DataBackendException("removeGroup(Group) failed", exception);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.unlockExclusive();
            throw throwable;
        }
        throw new UnknownEntityException("Unknown group '" + group + "'");
    }

    public synchronized void removeRole(Role role) throws DataBackendException, UnknownEntityException {
        boolean bl = false;
        try {
            try {
                this.lockExclusive();
                bl = this.checkExists(role);
                if (bl) {
                    this.revokeAll(role);
                    Criteria criteria = BaseTurbineRolePeer.buildCriteria((TurbineRole)role);
                    BaseTurbineRolePeer.doDelete(criteria);
                    this.getAllRoles().remove(role);
                    Object var5_5 = null;
                    this.unlockExclusive();
                    return;
                }
                Object var5_6 = null;
                this.unlockExclusive();
            }
            catch (Exception exception) {
                throw new DataBackendException("removeRole(Role)", exception);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.unlockExclusive();
            throw throwable;
        }
        throw new UnknownEntityException("Unknown role '" + role + "'");
    }

    public synchronized void removePermission(Permission permission) throws DataBackendException, UnknownEntityException {
        boolean bl = false;
        try {
            try {
                this.lockExclusive();
                bl = this.checkExists(permission);
                if (bl) {
                    Criteria criteria = BaseTurbinePermissionPeer.buildCriteria((TurbinePermission)permission);
                    BaseTurbinePermissionPeer.doDelete(criteria);
                    this.getAllPermissions().remove(permission);
                    Object var5_5 = null;
                    this.unlockExclusive();
                    return;
                }
                Object var5_6 = null;
                this.unlockExclusive();
            }
            catch (Exception exception) {
                throw new DataBackendException("removePermission(Permission)", exception);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.unlockExclusive();
            throw throwable;
        }
        throw new UnknownEntityException("Unknown permission '" + permission + "'");
    }

    public synchronized void renameGroup(Group group, String string) throws DataBackendException, UnknownEntityException {
        boolean bl = false;
        try {
            try {
                this.lockExclusive();
                bl = this.checkExists(group);
                if (bl) {
                    group.setName(string);
                    Criteria criteria = BaseTurbineGroupPeer.buildCriteria((TurbineGroup)group);
                    BaseTurbineGroupPeer.doUpdate(criteria);
                    Object var6_6 = null;
                    this.unlockExclusive();
                    return;
                }
                Object var6_7 = null;
                this.unlockExclusive();
            }
            catch (Exception exception) {
                throw new DataBackendException("renameGroup(Group,String)", exception);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.unlockExclusive();
            throw throwable;
        }
        throw new UnknownEntityException("Unknown group '" + group + "'");
    }

    public synchronized void renameRole(Role role, String string) throws DataBackendException, UnknownEntityException {
        boolean bl = false;
        try {
            try {
                this.lockExclusive();
                bl = this.checkExists(role);
                if (bl) {
                    role.setName(string);
                    Criteria criteria = BaseTurbineRolePeer.buildCriteria((TurbineRole)role);
                    BaseTurbineRolePeer.doUpdate(criteria);
                    Object var6_6 = null;
                    this.unlockExclusive();
                    return;
                }
                Object var6_7 = null;
                this.unlockExclusive();
            }
            catch (Exception exception) {
                throw new DataBackendException("renameRole(Role,String)", exception);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.unlockExclusive();
            throw throwable;
        }
        throw new UnknownEntityException("Unknown role '" + role + "'");
    }

    public synchronized void renamePermission(Permission permission, String string) throws DataBackendException, UnknownEntityException {
        boolean bl = false;
        try {
            try {
                this.lockExclusive();
                bl = this.checkExists(permission);
                if (bl) {
                    permission.setName(string);
                    Criteria criteria = BaseTurbinePermissionPeer.buildCriteria((TurbinePermission)permission);
                    BaseTurbinePermissionPeer.doUpdate(criteria);
                    Object var6_6 = null;
                    this.unlockExclusive();
                    return;
                }
                Object var6_7 = null;
                this.unlockExclusive();
            }
            catch (Exception exception) {
                throw new DataBackendException("renamePermission(Permission,name)", exception);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.unlockExclusive();
            throw throwable;
        }
        throw new UnknownEntityException("Unknown permission '" + permission + "'");
    }

    public Class getUserPeerClass() throws UnknownEntityException {
        String string = this.getConfiguration().getString(USER_PEER_CLASS_KEY, USER_PEER_CLASS_DEFAULT);
        try {
            return Class.forName(string);
        }
        catch (Exception exception) {
            throw new UnknownEntityException("Failed create a Class object for UserPeer implementation", exception);
        }
    }

    public UserPeer getUserPeerInstance() throws UnknownEntityException {
        UserPeer userPeer;
        try {
            userPeer = (UserPeer)this.getUserPeerClass().newInstance();
        }
        catch (Exception exception) {
            throw new UnknownEntityException("Failed instantiate an UserPeer implementation object", exception);
        }
        return userPeer;
    }

    protected boolean checkExists(Group group) throws DataBackendException, Exception {
        return TurbineGroupPeer.checkExists(group);
    }

    protected boolean checkExists(Role role) throws DataBackendException, Exception {
        return TurbineRolePeer.checkExists(role);
    }

    protected boolean checkExists(Permission permission) throws DataBackendException, Exception {
        return TurbinePermissionPeer.checkExists(permission);
    }
}

