/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.impl.db.entity;

import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.Objects;
import org.apache.fulcrum.intake.Retrievable;
import org.apache.fulcrum.security.impl.db.entity.BaseTurbineRolePeer;
import org.apache.fulcrum.security.impl.db.entity.BaseTurbineRolePermissionPeer;
import org.apache.fulcrum.security.impl.db.entity.BaseTurbineUserGroupRolePeer;
import org.apache.fulcrum.security.impl.db.entity.TurbineRole;
import org.apache.fulcrum.security.impl.db.entity.TurbineRolePeer;
import org.apache.fulcrum.security.impl.db.entity.TurbineRolePermission;
import org.apache.fulcrum.security.impl.db.entity.TurbineUserGroupRole;
import org.apache.torque.TorqueException;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.Persistent;
import org.apache.torque.pool.DBConnection;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.Criteria;

public abstract class BaseTurbineRole
extends BaseObject
implements Retrievable {
    private static final TurbineRolePeer peer = new TurbineRolePeer();
    private NumberKey role_id;
    private String role_name;
    protected Vector collTurbineRolePermissions;
    private Criteria lastTurbineRolePermissionsCriteria = null;
    protected Vector collTurbineUserGroupRoles;
    private Criteria lastTurbineUserGroupRolesCriteria = null;
    private static Vector fieldNames_ = null;
    private boolean alreadyInSave = false;

    public NumberKey getRoleId() {
        return this.role_id;
    }

    public void setRoleId(NumberKey numberKey) throws TorqueException {
        int n;
        if (numberKey != null && numberKey.getValue() == null) {
            numberKey = null;
        }
        if (!Objects.equals((Object)this.role_id, (Object)numberKey)) {
            this.role_id = numberKey;
            this.setModified(true);
        }
        if (this.collTurbineRolePermissions != null) {
            n = 0;
            while (n < this.collTurbineRolePermissions.size()) {
                ((TurbineRolePermission)this.collTurbineRolePermissions.get(n)).setRoleId(numberKey);
                ++n;
            }
        }
        if (this.collTurbineUserGroupRoles != null) {
            n = 0;
            while (n < this.collTurbineUserGroupRoles.size()) {
                ((TurbineUserGroupRole)this.collTurbineUserGroupRoles.get(n)).setRoleId(numberKey);
                ++n;
            }
        }
    }

    public void setRoleId(String string) throws TorqueException {
        this.setRoleId(new NumberKey(string));
    }

    public String getName() {
        return this.role_name;
    }

    public void setName(String string) {
        if (!Objects.equals((Object)this.role_name, (Object)string)) {
            this.role_name = string;
            this.setModified(true);
        }
    }

    protected void initTurbineRolePermissions() {
        if (this.collTurbineRolePermissions == null) {
            this.collTurbineRolePermissions = new Vector();
        }
    }

    public void addTurbineRolePermission(TurbineRolePermission turbineRolePermission) throws TorqueException {
        this.getTurbineRolePermissions().add(turbineRolePermission);
        turbineRolePermission.setTurbineRole((TurbineRole)this);
    }

    public Vector getTurbineRolePermissions() throws TorqueException {
        if (this.collTurbineRolePermissions == null) {
            this.collTurbineRolePermissions = this.getTurbineRolePermissions(new Criteria(10));
        }
        return this.collTurbineRolePermissions;
    }

    public Vector getTurbineRolePermissions(Criteria criteria) throws TorqueException {
        if (this.collTurbineRolePermissions == null) {
            if (this.isNew()) {
                this.collTurbineRolePermissions = new Vector();
            } else {
                criteria.add(BaseTurbineRolePermissionPeer.ROLE_ID, (Object)this.getRoleId());
                this.collTurbineRolePermissions = BaseTurbineRolePermissionPeer.doSelect(criteria);
            }
        } else if (!this.isNew()) {
            criteria.add(BaseTurbineRolePermissionPeer.ROLE_ID, (Object)this.getRoleId());
            if (!this.lastTurbineRolePermissionsCriteria.equals((Object)criteria)) {
                this.collTurbineRolePermissions = BaseTurbineRolePermissionPeer.doSelect(criteria);
            }
        }
        this.lastTurbineRolePermissionsCriteria = criteria;
        return this.collTurbineRolePermissions;
    }

    protected Vector getTurbineRolePermissionsJoinTurbinePermission(Criteria criteria) throws TorqueException {
        if (this.collTurbineRolePermissions == null) {
            if (this.isNew()) {
                this.collTurbineRolePermissions = new Vector();
            } else {
                criteria.add(BaseTurbineRolePermissionPeer.ROLE_ID, (Object)this.getRoleId());
                this.collTurbineRolePermissions = BaseTurbineRolePermissionPeer.doSelectJoinTurbinePermission(criteria);
            }
        } else {
            boolean bl = true;
            criteria.add(BaseTurbineRolePermissionPeer.ROLE_ID, (Object)this.getRoleId());
            if (!this.lastTurbineRolePermissionsCriteria.equals((Object)criteria)) {
                this.collTurbineRolePermissions = BaseTurbineRolePermissionPeer.doSelectJoinTurbinePermission(criteria);
            }
        }
        this.lastTurbineRolePermissionsCriteria = criteria;
        return this.collTurbineRolePermissions;
    }

    protected void initTurbineUserGroupRoles() {
        if (this.collTurbineUserGroupRoles == null) {
            this.collTurbineUserGroupRoles = new Vector();
        }
    }

    public void addTurbineUserGroupRole(TurbineUserGroupRole turbineUserGroupRole) throws TorqueException {
        this.getTurbineUserGroupRoles().add(turbineUserGroupRole);
        turbineUserGroupRole.setTurbineRole((TurbineRole)this);
    }

    public Vector getTurbineUserGroupRoles() throws TorqueException {
        if (this.collTurbineUserGroupRoles == null) {
            this.collTurbineUserGroupRoles = this.getTurbineUserGroupRoles(new Criteria(10));
        }
        return this.collTurbineUserGroupRoles;
    }

    public Vector getTurbineUserGroupRoles(Criteria criteria) throws TorqueException {
        if (this.collTurbineUserGroupRoles == null) {
            if (this.isNew()) {
                this.collTurbineUserGroupRoles = new Vector();
            } else {
                criteria.add(BaseTurbineUserGroupRolePeer.ROLE_ID, (Object)this.getRoleId());
                this.collTurbineUserGroupRoles = BaseTurbineUserGroupRolePeer.doSelect(criteria);
            }
        } else if (!this.isNew()) {
            criteria.add(BaseTurbineUserGroupRolePeer.ROLE_ID, (Object)this.getRoleId());
            if (!this.lastTurbineUserGroupRolesCriteria.equals((Object)criteria)) {
                this.collTurbineUserGroupRoles = BaseTurbineUserGroupRolePeer.doSelect(criteria);
            }
        }
        this.lastTurbineUserGroupRolesCriteria = criteria;
        return this.collTurbineUserGroupRoles;
    }

    protected Vector getTurbineUserGroupRolesJoinTurbineUser(Criteria criteria) throws TorqueException {
        if (this.collTurbineUserGroupRoles == null) {
            if (this.isNew()) {
                this.collTurbineUserGroupRoles = new Vector();
            } else {
                criteria.add(BaseTurbineUserGroupRolePeer.ROLE_ID, (Object)this.getRoleId());
                this.collTurbineUserGroupRoles = BaseTurbineUserGroupRolePeer.doSelectJoinTurbineUser(criteria);
            }
        } else {
            boolean bl = true;
            criteria.add(BaseTurbineUserGroupRolePeer.ROLE_ID, (Object)this.getRoleId());
            if (!this.lastTurbineUserGroupRolesCriteria.equals((Object)criteria)) {
                this.collTurbineUserGroupRoles = BaseTurbineUserGroupRolePeer.doSelectJoinTurbineUser(criteria);
            }
        }
        this.lastTurbineUserGroupRolesCriteria = criteria;
        return this.collTurbineUserGroupRoles;
    }

    protected Vector getTurbineUserGroupRolesJoinTurbineGroup(Criteria criteria) throws TorqueException {
        if (this.collTurbineUserGroupRoles == null) {
            if (this.isNew()) {
                this.collTurbineUserGroupRoles = new Vector();
            } else {
                criteria.add(BaseTurbineUserGroupRolePeer.ROLE_ID, (Object)this.getRoleId());
                this.collTurbineUserGroupRoles = BaseTurbineUserGroupRolePeer.doSelectJoinTurbineGroup(criteria);
            }
        } else {
            boolean bl = true;
            criteria.add(BaseTurbineUserGroupRolePeer.ROLE_ID, (Object)this.getRoleId());
            if (!this.lastTurbineUserGroupRolesCriteria.equals((Object)criteria)) {
                this.collTurbineUserGroupRoles = BaseTurbineUserGroupRolePeer.doSelectJoinTurbineGroup(criteria);
            }
        }
        this.lastTurbineUserGroupRolesCriteria = criteria;
        return this.collTurbineUserGroupRoles;
    }

    public static synchronized List getFieldNames() {
        if (fieldNames_ == null) {
            fieldNames_ = new Vector();
            fieldNames_.add("RoleId");
            fieldNames_.add("Name");
        }
        return fieldNames_;
    }

    public Object getByName(String string) {
        if (string.equals("RoleId")) {
            return this.getRoleId();
        }
        if (string.equals("Name")) {
            return this.getName();
        }
        return null;
    }

    public Object getByPeerName(String string) {
        if (string.equals(BaseTurbineRolePeer.ROLE_ID)) {
            return this.getRoleId();
        }
        if (string.equals(BaseTurbineRolePeer.ROLE_NAME)) {
            return this.getName();
        }
        return null;
    }

    public Object getByPosition(int n) {
        if (n == 0) {
            return this.getRoleId();
        }
        if (n == 1) {
            return this.getName();
        }
        return null;
    }

    public void save() throws Exception {
        this.save(BaseTurbineRolePeer.getMapBuilder().getDatabaseMap().getName());
    }

    public void save(String string) throws TorqueException {
        DBConnection dBConnection = null;
        try {
            dBConnection = BasePeer.beginTransaction((String)string);
            this.save(dBConnection);
        }
        catch (TorqueException torqueException) {
            BasePeer.rollBackTransaction((DBConnection)dBConnection);
            throw torqueException;
        }
        BasePeer.commitTransaction((DBConnection)dBConnection);
    }

    public void save(DBConnection dBConnection) throws TorqueException {
        if (!this.alreadyInSave) {
            int n;
            this.alreadyInSave = true;
            if (this.isModified()) {
                if (this.isNew()) {
                    BaseTurbineRolePeer.doInsert((TurbineRole)this, dBConnection);
                    this.setNew(false);
                } else {
                    BaseTurbineRolePeer.doUpdate((TurbineRole)this, dBConnection);
                }
            }
            if (this.collTurbineRolePermissions != null) {
                n = 0;
                while (n < this.collTurbineRolePermissions.size()) {
                    ((TurbineRolePermission)this.collTurbineRolePermissions.get(n)).save(dBConnection);
                    ++n;
                }
            }
            if (this.collTurbineUserGroupRoles != null) {
                n = 0;
                while (n < this.collTurbineUserGroupRoles.size()) {
                    ((TurbineUserGroupRole)this.collTurbineUserGroupRoles.get(n)).save(dBConnection);
                    ++n;
                }
            }
            this.alreadyInSave = false;
        }
    }

    public void setPrimaryKey(ObjectKey objectKey) throws TorqueException {
        this.setRoleId((NumberKey)objectKey);
    }

    public void setPrimaryKey(String string) throws TorqueException {
        this.setRoleId(new NumberKey(string));
    }

    public ObjectKey getPrimaryKey() {
        return this.getRoleId();
    }

    public String getQueryKey() {
        if (this.getPrimaryKey() == null) {
            return "";
        }
        return this.getPrimaryKey().toString();
    }

    public void setQueryKey(String string) throws TorqueException {
        this.setPrimaryKey(string);
    }

    public TurbineRole copy() throws TorqueException {
        return this.copyInto(new TurbineRole());
    }

    protected TurbineRole copyInto(TurbineRole turbineRole) throws TorqueException {
        turbineRole.setRoleId(this.role_id);
        turbineRole.setName(this.role_name);
        turbineRole.setNew(false);
        Vector vector = this.getTurbineRolePermissions();
        int n = 0;
        while (n < vector.size()) {
            TurbineRolePermission turbineRolePermission = (TurbineRolePermission)vector.get(n);
            turbineRole.addTurbineRolePermission(turbineRolePermission.copy());
            ((Persistent)vector.get(n)).setNew(true);
            ++n;
        }
        vector = this.getTurbineUserGroupRoles();
        int n2 = 0;
        while (n2 < vector.size()) {
            TurbineUserGroupRole turbineUserGroupRole = (TurbineUserGroupRole)vector.get(n2);
            turbineRole.addTurbineUserGroupRole(turbineUserGroupRole.copy());
            ((Persistent)vector.get(n2)).setNew(true);
            ++n2;
        }
        turbineRole.setNew(true);
        turbineRole.setRoleId((NumberKey)null);
        return turbineRole;
    }

    public TurbineRolePeer getPeer() {
        return peer;
    }
}

