/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.xmlrpc;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import org.apache.fulcrum.BaseService;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.xmlrpc.XmlRpcService;
import org.apache.fulcrum.xmlrpc.util.FileTransfer;
import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcServer;
import org.apache.xmlrpc.secure.SecureWebServer;

public class TurbineXmlRpcService
extends BaseService
implements XmlRpcService {
    private WebServer webserver = null;
    private XmlRpcServer server = null;
    private int port = 0;

    public void init() throws InitializationException {
        try {
            Object object;
            String string;
            Iterator iterator;
            String string2;
            this.server = new XmlRpcServer();
            this.port = this.getConfiguration().getInt("port", 0);
            if (this.port != 0) {
                if (this.getConfiguration().getBoolean("secure.server", false)) {
                    string2 = this.getConfiguration().subset("secure.server.option");
                    iterator = string2.getKeys();
                    while (iterator.hasNext()) {
                        string = (String)iterator.next();
                        object = string2.getString(string);
                        this.getCategory().debug((Object)("JSSE option: " + string + " => " + (String)object));
                        System.setProperty(string, (String)object);
                    }
                    this.webserver = new SecureWebServer(this.port);
                } else {
                    this.webserver = new WebServer(this.port);
                }
            }
            string2 = this.getConfiguration().getString("parser", "org.apache.xerces.parsers.SAXParser");
            XmlRpc.setDriver((String)string2);
            iterator = this.getConfiguration().getKeys("handler");
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                object = string.substring(string.indexOf(46) + 1);
                String string3 = this.getConfiguration().getString(string);
                this.registerHandler((String)object, string3);
            }
            boolean bl = this.getConfiguration().getBoolean("paranoid", false);
            if (bl) {
                Object object2;
                this.webserver.setParanoid(bl);
                this.getCategory().info((Object)"XmlRpcService: Operating in a state of paranoia");
                object = this.getConfiguration().getVector("acceptClient");
                int n = 0;
                while (n < ((Vector)object).size()) {
                    object2 = (String)((Vector)object).get(n);
                    if (object2 != null && !((String)object2).equals("")) {
                        this.webserver.acceptClient((String)object2);
                        this.getCategory().info((Object)("XmlRpcService: Accepting client -> " + (String)object2));
                    }
                    ++n;
                }
                object2 = this.getConfiguration().getVector("denyClient");
                int n2 = 0;
                while (n2 < ((Vector)object2).size()) {
                    String string4 = (String)((Vector)object2).get(n2);
                    if (string4 != null && !string4.equals("")) {
                        this.webserver.denyClient(string4);
                        this.getCategory().info((Object)("XmlRpcService: Denying client -> " + string4));
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            throw new InitializationException("XMLRPCService failed to initialize", exception);
        }
        this.setInit(true);
    }

    public void registerHandler(Object object) throws XmlRpcException, IOException {
        this.registerHandler("$default", object);
    }

    public void registerHandler(String string, Object object) throws XmlRpcException, IOException {
        if (this.webserver != null) {
            this.webserver.addHandler(string, object);
        }
        this.server.addHandler(string, object);
    }

    public void registerHandler(String string, String string2) throws ServiceException {
        try {
            Object obj = Class.forName(string2).newInstance();
            if (this.webserver != null) {
                this.webserver.addHandler(string, obj);
            }
            this.server.addHandler(string, obj);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw outOfMemoryError;
        }
        catch (Throwable throwable) {
            throw new ServiceException("Failed to instantiate " + string2, throwable);
        }
    }

    public void unregisterHandler(String string) {
        if (this.webserver != null) {
            this.webserver.removeHandler(string);
        }
        this.server.removeHandler(string);
    }

    public byte[] handleRequest(InputStream inputStream) {
        return this.server.execute(inputStream);
    }

    public byte[] handleRequest(InputStream inputStream, String string, String string2) {
        return this.server.execute(inputStream, string, string2);
    }

    public Object executeRpc(URL uRL, String string, Vector vector) throws ServiceException {
        try {
            XmlRpcClient xmlRpcClient = new XmlRpcClient(uRL);
            return xmlRpcClient.execute(string, vector);
        }
        catch (Exception exception) {
            throw new ServiceException("XML-RPC call failed", exception);
        }
    }

    public Object executeAuthenticatedRpc(URL uRL, String string, String string2, String string3, Vector vector) throws ServiceException {
        try {
            XmlRpcClient xmlRpcClient = new XmlRpcClient(uRL);
            xmlRpcClient.setBasicAuthentication(string, string2);
            return xmlRpcClient.execute(string3, vector);
        }
        catch (Exception exception) {
            throw new ServiceException("XML-RPC call failed", exception);
        }
    }

    public void send(String string, String string2, String string3, String string4, String string5) throws Exception {
        FileTransfer.send(string, string2, string3, string4, string5);
    }

    public void send(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws Exception {
        FileTransfer.send(string, string2, string3, string4, string5, string6, string7);
    }

    public void get(String string, String string2, String string3, String string4, String string5) throws Exception {
        FileTransfer.get(string, string2, string3, string4, string5);
    }

    public void get(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws Exception {
        FileTransfer.get(string, string2, string3, string4, string5, string6, string7);
    }

    public void remove(String string, String string2, String string3) throws Exception {
        FileTransfer.remove(string, string2, string3);
    }

    public void remove(String string, String string2, String string3, String string4, String string5) throws Exception {
        FileTransfer.remove(string, string2, string3, string4, string5);
    }

    public void setParanoid(boolean bl) {
        this.webserver.setParanoid(bl);
    }

    public void acceptClient(String string) {
        this.webserver.acceptClient(string);
    }

    public void denyClient(String string) {
        this.webserver.denyClient(string);
    }

    public void shutdown() {
        this.webserver.shutdown();
        try {
            Socket socket = new Socket(InetAddress.getLocalHost(), this.port);
            socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setInit(false);
    }
}

