/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.htmlcleaner;

import info.bliki.htmlcleaner.BaseToken;
import info.bliki.htmlcleaner.ContentToken;
import info.bliki.htmlcleaner.TagToken;
import info.bliki.htmlcleaner.XmlSerializer;
import info.bliki.wiki.tags.HTMLTag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class TagNode
extends TagToken {
    public static final String[] ALLOWED_ATTRIBUTES = new String[]{"title", "align", "lang", "dir", "width", "height", "bgcolor", "clear", "noshade", "cite", "size", "face", "color", "type", "start", "value", "compact", "summary", "width", "border", "frame", "rules", "cellspacing", "cellpadding", "valign", "char", "charoff", "colgroup", "col", "span", "abbr", "axis", "headers", "scope", "rowspan", "colspan", "id", "class", "name", "href", "rel", "alt", "src", "target"};
    protected static final HashSet<String> ALLOWED_ATTRIBUTES_SET = new HashSet();
    private TagNode parent = null;
    private Map<String, String> attributes = new TreeMap<String, String>();
    private HashMap<String, Object> objectAttributes = null;
    private List<Object> children = new ArrayList<Object>();
    private List<Object> itemsToMove = null;
    private transient boolean isFormed = false;

    public static Set<String> getAllowedAttributes() {
        return ALLOWED_ATTRIBUTES_SET;
    }

    public static boolean removeAllowedAttribute(String key) {
        return ALLOWED_ATTRIBUTES_SET.remove(key);
    }

    public static boolean addAllowedAttribute(String key) {
        return ALLOWED_ATTRIBUTES_SET.add(key);
    }

    public TagNode() {
    }

    public TagNode(String name) {
        super(name.toLowerCase());
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Map<String, Object> getObjectAttributes() {
        return this.objectAttributes;
    }

    public List<Object> getChildren() {
        return this.children;
    }

    public TagNode getParent() {
        return this.parent;
    }

    public void setParent(TagNode parent) {
        this.parent = parent;
    }

    public boolean addAttribute(String attName, String attValue, boolean checkXSS) {
        if (attName != null && !"".equals(attName.trim()) && attValue != null) {
            boolean checkedAttributes = true;
            String nameLowerCased = attName.toLowerCase();
            String valueLowerCased = attValue.toLowerCase();
            if (checkXSS && !TagNode.getAllowedAttributes().contains(nameLowerCased) && !this.isAllowedAttribute(nameLowerCased)) {
                checkedAttributes = false;
            }
            if (checkedAttributes && valueLowerCased.contains("javascript:")) {
                checkedAttributes = false;
            }
            if (checkedAttributes && attName.equalsIgnoreCase("style")) {
                if (valueLowerCased.contains("expression")) {
                    checkedAttributes = false;
                } else if (valueLowerCased.contains("url")) {
                    checkedAttributes = false;
                } else if (valueLowerCased.contains("tps")) {
                    checkedAttributes = false;
                }
            }
            if (checkedAttributes) {
                this.attributes.put(nameLowerCased, attValue);
                return true;
            }
        }
        return false;
    }

    public boolean addHrefJavascript() {
        this.attributes.put("href", "javascript:void(0);");
        return true;
    }

    public boolean isAllowedAttribute(String attName) {
        return false;
    }

    public void addObjectAttribute(String attName, Object attValue) {
        if (attName != null && attValue != null) {
            if (this.objectAttributes == null) {
                this.objectAttributes = new HashMap(4);
            }
            this.objectAttributes.put(attName, attValue);
        }
    }

    public void addChild(Object child) {
        this.children.add(child);
        if (child instanceof TagNode) {
            TagNode childTagNode = (TagNode)((Object)child);
            childTagNode.parent = this;
        }
    }

    public void addChildren(List<? extends Object> children) {
        if (children != null) {
            for (Object object : children) {
                this.addChild(object);
            }
        }
    }

    public void addItemForMoving(BaseToken item) {
        if (this.itemsToMove == null) {
            this.itemsToMove = new ArrayList<Object>();
        }
        this.itemsToMove.add(item);
    }

    public List<Object> getItemsToMove() {
        return this.itemsToMove;
    }

    public void setItemsToMove(List<Object> itemsToMove) {
        this.itemsToMove = itemsToMove;
    }

    public boolean isFormed() {
        return this.isFormed;
    }

    public void setFormed() {
        this.isFormed = true;
    }

    public void serialize(XmlSerializer xmlSerializer) throws IOException {
        xmlSerializer.serialize(this);
    }

    public TagNode makeCopy() {
        TagNode copy = new TagNode(this.name);
        copy.attributes = this.attributes;
        copy.objectAttributes = this.objectAttributes;
        return copy;
    }

    public Object clone() {
        TagNode tt = (TagNode)((Object)super.clone());
        tt.parent = this.parent;
        tt.itemsToMove = this.itemsToMove;
        tt.isFormed = this.isFormed;
        tt.children = new ArrayList<Object>(this.children);
        tt.attributes = new TreeMap<String, String>(this.attributes);
        tt.objectAttributes = this.objectAttributes == null ? null : new HashMap<String, Object>(this.objectAttributes);
        return tt;
    }

    public String getParents() {
        return null;
    }

    public void getBodyString(Appendable buf) throws IOException {
        List<Object> children = this.getChildren();
        if (children.size() == 1 && children.get(0) instanceof ContentToken) {
            buf.append(((ContentToken)children.get(0)).getContent());
        } else if (children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                TagNode node;
                Map<String, Object> map;
                if (children.get(i) instanceof ContentToken) {
                    buf.append(((ContentToken)children.get(i)).getContent());
                    continue;
                }
                if (children.get(i) instanceof HTMLTag) {
                    ((HTMLTag)((Object)children.get(i))).getBodyString(buf);
                    continue;
                }
                if (!(children.get(i) instanceof TagNode) || (map = (node = (TagNode)((Object)children.get(i))).getObjectAttributes()) != null && map.size() > 0) continue;
                node.getBodyString(buf);
            }
        }
    }

    public String getBodyString() {
        List<Object> children = this.getChildren();
        if (children.size() == 1 && children.get(0) instanceof ContentToken) {
            return ((ContentToken)children.get(0)).getContent();
        }
        if (children.size() > 0) {
            StringBuilder buf = new StringBuilder(children.size() * 16);
            for (int i = 0; i < children.size(); ++i) {
                TagNode node;
                Map<String, Object> map;
                if (children.get(i) instanceof ContentToken) {
                    buf.append(((ContentToken)children.get(i)).getContent());
                    continue;
                }
                if (children.get(i) instanceof HTMLTag) {
                    buf.append(((HTMLTag)((Object)children.get(i))).getBodyString());
                    continue;
                }
                if (!(children.get(i) instanceof TagNode) || (map = (node = (TagNode)((Object)children.get(i))).getObjectAttributes()) != null && map.size() > 0) continue;
                buf.append(node.getBodyString());
            }
            return buf.toString();
        }
        return "";
    }

    static {
        for (int i = 0; i < ALLOWED_ATTRIBUTES.length; ++i) {
            ALLOWED_ATTRIBUTES_SET.add(ALLOWED_ATTRIBUTES[i]);
        }
    }
}

