/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.screens;

import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategoryMap;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardFile;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardTopic;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.modules.screens.FileuploadRawScreen;
import com.aimluck.eip.msgboard.util.MsgboardUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.util.ALEipUtils;
import java.util.List;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;

public class MsgboardTopicFileRawScreen
extends FileuploadRawScreen {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)MsgboardTopicFileRawScreen.class.getName());

    protected void doOutput(RunData rundata) throws Exception {
        try {
            this.doCheckAclPermission(rundata, "msgboard_topic_other", 1);
        }
        catch (ALPermissionException e) {
            try {
                this.doCheckAclPermission(rundata, "msgboard_topic", 1);
            }
            catch (ALPermissionException ex) {
                throw new Exception();
            }
        }
        try {
            EipTMsgboardFile msgboardfile = MsgboardUtils.getEipTMsgboardFile(rundata);
            this.doFileCheckView(rundata, msgboardfile);
            super.setFilePath(MsgboardUtils.getSaveDirPath(Database.getDomainName(), msgboardfile.getOwnerId()) + msgboardfile.getFilePath());
            super.setFileName(msgboardfile.getFileName());
            super.doOutput(rundata);
        }
        catch (ALPermissionException e) {
            throw new Exception();
        }
        catch (Exception e) {
            logger.error((Object)"MsgboardTopicFileRawScreen.doOutput", (Throwable)e);
        }
    }

    private boolean doFileCheckView(RunData rundata, EipTMsgboardFile msgboardfile) throws ALPermissionException {
        int userid = ALEipUtils.getUserId((RunData)rundata);
        EipTMsgboardTopic msgboardtopic = msgboardfile.getEipTMsgboardTopic();
        EipTMsgboardCategory msgboardcategory = msgboardtopic.getEipTMsgboardCategory();
        if ("T".equals(msgboardcategory.getPublicFlag())) {
            return true;
        }
        List categoryMap = msgboardcategory.getEipTMsgboardCategoryMaps();
        for (EipTMsgboardCategoryMap map : categoryMap) {
            if (map.getUserId() != userid) continue;
            return true;
        }
        throw new ALPermissionException();
    }
}

