/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.msgboard;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardFile;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardTopic;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.mail.ALAdminMailContext;
import com.aimluck.eip.mail.ALAdminMailMessage;
import com.aimluck.eip.mail.ALMailService;
import com.aimluck.eip.mail.util.ALEipUserAddr;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.modules.actions.msgboard.MsgboardAction;
import com.aimluck.eip.modules.screens.MsgboardTopicDetailScreen;
import com.aimluck.eip.modules.screens.MsgboardTopicFormJSONScreen;
import com.aimluck.eip.msgboard.util.MsgboardUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class MsgboardTopicReplyFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)MsgboardTopicReplyFormData.class.getName());
    private ALStringField note;
    private ALStringField attachment = null;
    private List<FileuploadLiteBean> fileuploadList = null;
    private String folderName = null;
    private int uid;
    private String orgId;
    private String aclPortletFeature = null;
    private boolean hasAclCategoryList;
    private boolean hasAclUpdateTopicOthers;
    private boolean hasAclDeleteTopicOthers;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.uid = ALEipUtils.getUserId((RunData)rundata);
        this.orgId = Database.getDomainName();
        this.folderName = rundata.getParameters().getString("folderName");
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        this.hasAclCategoryList = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "msgboard_category", 1);
        this.hasAclDeleteTopicOthers = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "msgboard_topic_other", 16);
        this.hasAclUpdateTopicOthers = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "msgboard_topic_other", 8);
    }

    public void initField() {
        this.note = new ALStringField();
        this.note.setFieldName(ALLocalizationUtils.getl10n((String)"MSGBOARD_NOTE"));
        this.note.setTrim(false);
        this.attachment = new ALStringField();
        this.attachment.setFieldName(ALLocalizationUtils.getl10n((String)"MSGBOARD_FILE_ATTACH"));
        this.attachment.setTrim(true);
        this.fileuploadList = new ArrayList<FileuploadLiteBean>();
    }

    protected void setValidator() {
        this.note.setNotNull(true);
        this.note.limitMaxLength(10000);
    }

    protected boolean validate(List<String> msgList) {
        this.note.validate(msgList);
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            int i;
            int fsize;
            String topicid = rundata.getParameters().getString("topic_reply_id");
            EipTMsgboardTopic topic = this.hasAclDeleteTopicOthers ? MsgboardUtils.getEipTMsgboardTopicReply(rundata, context, topicid, true) : MsgboardUtils.getEipTMsgboardTopicReply(rundata, context, topicid, false);
            if (topic == null) {
                logger.debug((Object)"[MsgboardTopicReplyFormData] Not found ID...");
                throw new ALPageNotFoundException();
            }
            ArrayList<String> fpaths = new ArrayList<String>();
            List files = topic.getEipTMsgboardFileArray();
            if (files != null && files.size() > 0) {
                fsize = files.size();
                for (i = 0; i < fsize; ++i) {
                    fpaths.add(((EipTMsgboardFile)files.get(i)).getFilePath());
                }
            }
            Database.delete((Persistent)topic);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(topic.getTopicId().intValue(), 180, topic.getTopicName());
            if (fpaths.size() > 0) {
                fsize = fpaths.size();
                for (i = 0; i < fsize; ++i) {
                    ALStorageService.deleteFile((String)(MsgboardUtils.getSaveDirPath(this.orgId, this.uid) + (String)fpaths.get(i)));
                }
            }
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"[MsgboardTopicReplyFormData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            EipTMsgboardTopic parenttopic = MsgboardUtils.getEipTMsgboardParentTopic(rundata, context, false);
            if (parenttopic == null) {
                logger.debug((Object)"[MsgboardTopicReplyFormData] Not found ID...");
                throw new ALPageNotFoundException();
            }
            if (!MsgboardUtils.hasAuthorityToReply(this.uid, parenttopic.getEipTMsgboardCategory())) {
                msgList.add(" \u3053\u306e\u30c8\u30d4\u30c3\u30af\u306b\u8fd4\u4fe1\u3059\u308b\u6a29\u9650\u304c\u3042\u308a\u307e\u305b\u3093\u3002 ");
                return false;
            }
            Date updateDate = Calendar.getInstance().getTime();
            EipTMsgboardTopic topic = (EipTMsgboardTopic)Database.create(EipTMsgboardTopic.class);
            topic.setEipTMsgboardCategory(parenttopic.getEipTMsgboardCategory());
            topic.setTopicName("");
            topic.setParentId(parenttopic.getTopicId());
            topic.setOwnerId(Integer.valueOf(this.uid));
            topic.setNote(this.note.getValue());
            topic.setCreateUserId(Integer.valueOf(this.uid));
            topic.setUpdateUserId(Integer.valueOf(this.uid));
            topic.setCreateDate(Calendar.getInstance().getTime());
            topic.setUpdateDate(updateDate);
            parenttopic.setUpdateUserId(Integer.valueOf(this.uid));
            parenttopic.setUpdateDate(updateDate);
            if (!MsgboardUtils.insertFileDataDelegate(rundata, context, topic, this.fileuploadList, this.folderName, msgList)) {
                return false;
            }
            Database.commit();
            List<ALEipUser> memberList = this.selectMsgMember(rundata, context);
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(topic.getTopicId().intValue(), 180, parenttopic.getTopicName(), "insert");
            if ("T".equals(topic.getEipTMsgboardCategory().getPublicFlag())) {
                ALEipUser user = ALEipUtils.getALEipUser((int)this.uid);
                MsgboardUtils.createNewCommentActivity(parenttopic, user.getName().getValue(), topic);
                ArrayList<String> recipient = new ArrayList<String>();
                for (int i = 0; i < memberList.size(); ++i) {
                    recipient.add(memberList.get(i).getName().toString());
                }
                MsgboardUtils.createNewTopicActivity(parenttopic, user.getName().toString(), recipient, topic);
            } else {
                List<Integer> userIds = MsgboardUtils.getWhatsNewInsertList(rundata, topic.getEipTMsgboardCategory().getCategoryId(), topic.getEipTMsgboardCategory().getPublicFlag());
                ArrayList<String> recipients = new ArrayList<String>();
                int u_size = userIds.size();
                for (int i = 0; i < u_size; ++i) {
                    Integer _id = userIds.get(i);
                    ALEipUser user = ALEipUtils.getALEipUser((int)_id);
                    if (user == null) continue;
                    recipients.add(user.getName().getValue());
                }
                if (recipients.size() > 0) {
                    ALEipUser user = ALEipUtils.getALEipUser((int)this.uid);
                    MsgboardUtils.createNewCommentActivity(parenttopic, user.getName().getValue(), recipients, topic);
                    ArrayList<String> recipient = new ArrayList<String>();
                    for (int i = 0; i < memberList.size(); ++i) {
                        recipient.add(memberList.get(i).getName().toString());
                    }
                    MsgboardUtils.createNewTopicActivity(parenttopic, user.getName().toString(), recipient, topic);
                }
            }
            ALStorageService.deleteTmpFolder((int)this.uid, (String)this.folderName);
            try {
                int msgType = ALMailUtils.getSendDestType((int)27);
                if (msgType > 0) {
                    List destMemberList = ALMailUtils.getALEipUserAddrs(memberList, (int)ALEipUtils.getUserId((RunData)rundata), (boolean)false);
                    String subject = "[" + ALOrgUtilsService.getAlias() + "]\u63b2\u793a\u677f";
                    String orgId = Database.getDomainName();
                    ArrayList<ALAdminMailMessage> messageList = new ArrayList<ALAdminMailMessage>();
                    for (ALEipUserAddr destMember : destMemberList) {
                        ALAdminMailMessage message = new ALAdminMailMessage(destMember);
                        message.setPcSubject(subject);
                        message.setCellularSubject(subject);
                        message.setPcBody(MsgboardUtils.createReplyMsgForPc(rundata, parenttopic, topic, memberList));
                        message.setCellularBody(MsgboardUtils.createReplyMsgForCellPhone(rundata, parenttopic, topic, memberList));
                        messageList.add(message);
                    }
                    ALMailService.sendAdminMailAsync((ALAdminMailContext)new ALAdminMailContext(orgId, ALEipUtils.getUserId((RunData)rundata), messageList, ALMailUtils.getSendDestType((int)27)));
                }
            }
            catch (Exception ex) {
                msgList.add("\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
                logger.error((Object)"msgboard", (Throwable)ex);
                return false;
            }
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"[MsgboardTopicReplyFormData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        return true;
    }

    private List<ALEipUser> selectMsgMember(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        EipTMsgboardTopic parenttopic = MsgboardUtils.getEipTMsgboardParentTopic(rundata, context, false);
        SelectQuery topicQuery = Database.query(EipTMsgboardTopic.class);
        Expression topicExp = ExpressionFactory.matchExp((String)"parentId", (Object)parenttopic.getTopicId());
        topicQuery.setQualifier(topicExp);
        List topicList = topicQuery.fetchList();
        topicList.add(parenttopic);
        ArrayList<Integer> userIdList = new ArrayList<Integer>();
        for (EipTMsgboardTopic topic : topicList) {
            Integer userId = topic.getCreateUserId();
            if (userId.equals(this.uid) || userIdList.contains(userId)) continue;
            userIdList.add(userId);
        }
        userIdList.add(-1);
        SelectQuery userQuery = Database.query(TurbineUser.class);
        Expression userExp = ExpressionFactory.inDbExp((String)"USER_ID", userIdList);
        userQuery.setQualifier(userExp);
        return ALEipUtils.getUsersFromSelectQuery((SelectQuery)userQuery);
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    public boolean doInsert(ALAction action, RunData rundata, Context context) {
        try {
            if (!this.doCheckSecurity(rundata, context)) {
                return false;
            }
            this.init(action, rundata, context);
            this.doCheckAclPermission(rundata, context, 4);
            action.setMode("insert");
            ArrayList<String> msgList = new ArrayList<String>();
            this.setValidator();
            boolean res = false;
            if (this.isOverQuota()) {
                msgList.add(ALLocalizationUtils.getl10n((String)"COMMON_FULL_DISK_DELETE_DETA_OR_CHANGE_PLAN"));
            } else {
                boolean bl = res = this.setFormData(rundata, context, msgList) && this.validate(msgList) && this.insertFormData(rundata, context, msgList);
            }
            if (!res) {
                action.setMode("new_form");
                this.setMode(action.getMode());
            }
            if (action instanceof MsgboardTopicFormJSONScreen) {
                action.setResultData((Object)this);
                action.addErrorMessages(msgList);
                action.putData(rundata, context);
            } else {
                MsgboardAction msgboardAction = (MsgboardAction)action;
                msgboardAction.setResultDataOnTopicDetail((Object)this);
                msgboardAction.addErrorMessagesOnTopicDetail(msgList);
                msgboardAction.putDataOnTopicDetail(rundata, context);
            }
            return res;
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError((RunData)rundata);
            return false;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    public boolean doViewForm(ALAction action, RunData rundata, Context context) {
        try {
            this.init(action, rundata, context);
            action.setMode("reply");
            ArrayList<String> msgList = new ArrayList<String>();
            boolean res = this.setFormData(rundata, context, msgList);
            if (action instanceof MsgboardTopicDetailScreen) {
                MsgboardTopicDetailScreen msgboardAction = (MsgboardTopicDetailScreen)action;
                msgboardAction.setResultDataOnTopicDetail((Object)this);
                msgboardAction.addErrorMessagesOnTopicDetail(msgList);
                msgboardAction.putDataOnTopicDetail(rundata, context);
            } else {
                MsgboardAction msgboardAction = (MsgboardAction)action;
                msgboardAction.setResultDataOnTopicDetail((Object)this);
                msgboardAction.addErrorMessagesOnTopicDetail(msgList);
                msgboardAction.putDataOnTopicDetail(rundata, context);
            }
            return res;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        try {
            this.fileuploadList = FileuploadUtils.getFileuploadList((RunData)rundata);
        }
        catch (Exception ex) {
            logger.error((Object)"msgboard", (Throwable)ex);
        }
        return res;
    }

    public void setAclPortletFeature(String featureName) {
        this.aclPortletFeature = featureName;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public List<FileuploadLiteBean> getAttachmentFileNameList() {
        return this.fileuploadList;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public String getAclPortletFeature() {
        if (this.aclPortletFeature == null || "".equals(this.aclPortletFeature)) {
            return "msgboard_topic_reply";
        }
        return this.aclPortletFeature;
    }

    public boolean hasAclUpdateTopicOthers() {
        return this.hasAclUpdateTopicOthers;
    }

    public boolean hasAclDeleteTopicOthers() {
        return this.hasAclDeleteTopicOthers;
    }
}

