/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.services.social.impl;

import com.aimluck.eip.cayenne.om.portlet.EipTTimeline;
import com.aimluck.eip.cayenne.om.portlet.EipTTimelineMap;
import com.aimluck.eip.cayenne.om.social.Activity;
import com.aimluck.eip.cayenne.om.social.ActivityMap;
import com.aimluck.eip.cayenne.om.social.AppData;
import com.aimluck.eip.cayenne.om.social.Application;
import com.aimluck.eip.cayenne.om.social.ContainerConfig;
import com.aimluck.eip.cayenne.om.social.ModuleId;
import com.aimluck.eip.cayenne.om.social.OAuthConsumer;
import com.aimluck.eip.common.ALActivity;
import com.aimluck.eip.common.ALActivityCount;
import com.aimluck.eip.common.ALApplication;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALOAuthConsumer;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.Operations;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.services.push.ALPushService;
import com.aimluck.eip.services.social.ALContainerConfigService;
import com.aimluck.eip.services.social.ALSocialApplicationHandler;
import com.aimluck.eip.services.social.gadgets.ALGadgetSpec;
import com.aimluck.eip.services.social.gadgets.ALOAuthService;
import com.aimluck.eip.services.social.model.ALActivityGetRequest;
import com.aimluck.eip.services.social.model.ALActivityPutRequest;
import com.aimluck.eip.services.social.model.ALApplicationGetRequest;
import com.aimluck.eip.services.social.model.ALApplicationPutRequest;
import com.aimluck.eip.services.social.model.ALOAuthConsumerPutRequest;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;

public class ALDefaultSocialApplicationHanlder
extends ALSocialApplicationHandler {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALDefaultSocialApplicationHanlder.class.getName());
    private static ALSocialApplicationHandler instance;

    public static ALSocialApplicationHandler getInstance() {
        if (instance == null) {
            instance = new ALDefaultSocialApplicationHanlder();
        }
        return instance;
    }

    public ResultList<ALApplication> getApplicationList(ALApplicationGetRequest request) {
        SelectQuery<Application> query = this.buildApplicationQuery(request);
        ResultList resultList = query.getResultList();
        ArrayList<ALApplication> list = new ArrayList<ALApplication>(resultList.size());
        ArrayList<String> specUrls = new ArrayList<String>(list.size());
        boolean fetchXml = request.isFetchXml();
        for (Object app : resultList) {
            specUrls.add(app.getUrl());
        }
        Map metaData = null;
        if (fetchXml) {
            metaData = this.getMetaData(specUrls, "home", request.isDetail(), true);
        }
        for (Application app : resultList) {
            ALApplication model = new ALApplication();
            model.setAppId(String.valueOf(app.getId()));
            model.setTitle(app.getTitle());
            model.setConsumerKey(app.getConsumerKey());
            model.setConsumerSecret(app.getConsumerSecret());
            model.setUrl(app.getUrl());
            model.setStatus(app.getStatus().intValue());
            model.setDescription(app.getDescription());
            if (fetchXml) {
                ALGadgetSpec gadgetSpec = (ALGadgetSpec)metaData.get(app.getUrl());
                model.setUserPrefs(gadgetSpec.getUserPrefs());
            }
            list.add(model);
        }
        ResultList result = new ResultList(list, resultList.getLimit(), resultList.getPage(), resultList.getTotalCount());
        return result;
    }

    public ALApplication getApplication(ALApplicationGetRequest request) {
        SelectQuery<Application> query = this.buildApplicationQuery(request);
        Application app = (Application)query.fetchSingle();
        if (app == null) {
            return null;
        }
        ALApplication model = new ALApplication();
        model.setAppId(String.valueOf(app.getId()));
        model.setTitle(app.getTitle());
        model.setConsumerKey(app.getConsumerKey());
        model.setConsumerSecret(app.getConsumerSecret());
        model.setUrl(app.getUrl());
        model.setStatus(app.getStatus().intValue());
        model.setIcon(app.getIcon());
        model.setDescription(app.getDescription());
        boolean fetchXml = request.isFetchXml();
        ALGadgetSpec gadgetSpec = null;
        if (fetchXml) {
            gadgetSpec = this.getMetaData(app.getUrl(), request.isDetail());
        }
        if (gadgetSpec != null) {
            model.setUserPrefs(gadgetSpec.getUserPrefs());
        }
        if (gadgetSpec != null && request.isDetail()) {
            ArrayList<ALOAuthConsumer> consumers = new ArrayList<ALOAuthConsumer>();
            List services = gadgetSpec.getOAuthServices();
            List consumerModels = app.getOauthConsumer();
            for (ALOAuthService service : services) {
                ALOAuthConsumer consumer = new ALOAuthConsumer();
                consumer.setAppId(app.getAppId());
                consumer.setName(service.getName());
                consumer.setAuthorizationUrl(service.getAuthorizationUrl());
                consumer.setRequestUrl(service.getRequestUrl());
                consumer.setAccessUrl(service.getAccessUrl());
                for (OAuthConsumer consumerModel : consumerModels) {
                    if (!service.getName().equals(consumerModel.getName())) continue;
                    consumer.setType(consumerModel.getType());
                    consumer.setConsumerKey(consumerModel.getConsumerKey());
                    consumer.setConsumerSecret(consumerModel.getConsumerSecret());
                }
                consumers.add(consumer);
            }
            model.addOAuthConsumers(consumers);
        }
        return model;
    }

    public List<ALOAuthConsumer> getOAuthConsumer(String appId) {
        ALApplication app = this.getApplication(new ALApplicationGetRequest().withAppId(appId).withIsDetail(true).withStatus(ALApplicationGetRequest.Status.ALL));
        return app.getOAuthConsumers();
    }

    public void putOAuthConsumer(ALOAuthConsumerPutRequest request) {
        try {
            Date date = new Date();
            String appId = request.getAppId();
            String name = request.getName();
            Application app = (Application)Database.get(Application.class, (String)"APP_ID", (Object)appId);
            if (app == null) {
                return;
            }
            List oauthConsumers = app.getOauthConsumer();
            boolean has = false;
            if (oauthConsumers != null) {
                for (OAuthConsumer oauthConsumer : oauthConsumers) {
                    if (!oauthConsumer.getName().equals(name)) continue;
                    oauthConsumer.setType(request.getType().value());
                    oauthConsumer.setConsumerKey(request.getConsumerKey());
                    oauthConsumer.setConsumerSecret(request.getConsumerSecret());
                    oauthConsumer.setUpdateDate(date);
                    has = true;
                }
            }
            if (!has) {
                OAuthConsumer oauthConsumer = (OAuthConsumer)Database.create(OAuthConsumer.class);
                oauthConsumer.setApplication(app);
                oauthConsumer.setName(request.getName());
                oauthConsumer.setType(request.getType().value());
                oauthConsumer.setConsumerKey(request.getConsumerKey());
                oauthConsumer.setConsumerSecret(request.getConsumerSecret());
                oauthConsumer.setCreateDate(date);
                oauthConsumer.setUpdateDate(date);
            }
            Database.commit();
        }
        catch (Throwable t) {
            Database.rollback();
            throw new RuntimeException(t);
        }
    }

    public void createApplication(ALApplicationPutRequest request) {
        String url = request.getUrl();
        Date date = new Date();
        try {
            Application app = (Application)Database.create(Application.class);
            app.setAppId("");
            app.setUrl(url);
            app.setTitle(request.getTitle());
            app.setStatus(Integer.valueOf(1));
            app.setDescription(request.getDescription());
            app.setIcon(request.getIcon());
            app.setCreateDate(date);
            app.setUpdateDate(date);
            Database.commit();
            app.setAppId(String.valueOf(app.getId()));
            Database.commit();
            if (request.getActivityLoginName() != null && request.getActivityLoginName().length() > 0) {
                String title = "\u30a2\u30d7\u30ea\u300c" + ALCommonUtils.compressString((String)request.getTitle().toString(), (int)30) + "\u300d\u3092\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3057\u307e\u3057\u305f\u3002";
                String portletParams = "?template=GadgetsAdminDetailScreen" + "&entityid=" + app.getAppId().toString();
                this.createActivity(new ALActivityPutRequest().withAppId("GadgetAdd").withPortletParams(portletParams).withUserId(request.getActivityUserId()).withTitle(title).withPriority(0.0f).withLoginName(request.getActivityLoginName()).withExternalId(String.valueOf(app.getAppId().toString())));
            }
        }
        catch (Throwable t) {
            Database.rollback();
            throw new RuntimeException(t);
        }
    }

    public void updateApplication(String appId, ALApplicationPutRequest request) {
        Date date = new Date();
        try {
            Application app = (Application)Database.get(Application.class, (String)"APP_ID", (Object)appId);
            app.setTitle(request.getTitle());
            app.setDescription(request.getDescription());
            app.setIcon(request.getIcon());
            app.setUpdateDate(date);
            Database.commit();
        }
        catch (Throwable t) {
            Database.rollback();
            throw new RuntimeException(t);
        }
    }

    public void enableApplication(String ... appIdList) {
        try {
            for (String appId : appIdList) {
                Application app = (Application)Database.get(Application.class, (String)"APP_ID", (Object)appId);
                if (app == null) continue;
                app.setStatus(Integer.valueOf(1));
            }
            Database.commit();
        }
        catch (Throwable t) {
            Database.rollback();
            throw new RuntimeException(t);
        }
    }

    public void enableApplication(List<String> appIdList) {
        this.enableApplication(appIdList.toArray(new String[appIdList.size()]));
    }

    public void disableApplication(String ... appIdList) {
        try {
            for (String appId : appIdList) {
                Application app = (Application)Database.get(Application.class, (String)"APP_ID", (Object)appId);
                if (app == null) continue;
                app.setStatus(Integer.valueOf(0));
            }
            Database.commit();
        }
        catch (Throwable t) {
            Database.rollback();
            throw new RuntimeException(t);
        }
    }

    public void disableApplication(List<String> appIdList) {
        this.disableApplication(appIdList.toArray(new String[appIdList.size()]));
    }

    public void deleteApplication(String ... appIdList) {
        try {
            for (String appId : appIdList) {
                Database.delete((Persistent)((Persistent)Database.get(Application.class, (String)"APP_ID", (Object)appId)));
                String sql1 = "delete from app_data where app_id = #bind($appId)";
                Database.sql(AppData.class, (String)sql1).param("appId", (Object)appId).execute();
                String sql2 = "delete from activity where app_id = #bind($appId)";
                Database.sql(Activity.class, (String)sql2).param("appId", (Object)appId).execute();
            }
            Database.commit();
        }
        catch (Throwable t) {
            Database.rollback();
            throw new RuntimeException(t);
        }
    }

    public void deleteApplication(List<String> appIdList) {
        this.deleteApplication(appIdList.toArray(new String[appIdList.size()]));
    }

    public boolean checkApplicationAvailability(String appId) {
        try {
            Application app = (Application)Database.get(Application.class, (String)"APP_ID", (Object)appId);
            if (app == null) {
                return false;
            }
            Integer status = app.getStatus();
            if (status == null) {
                return false;
            }
            return status == 1;
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected SelectQuery<Application> buildApplicationQuery(ALApplicationGetRequest request) {
        SelectQuery query = Database.query(Application.class);
        int limit = request.getLimit();
        int page = request.getPage();
        ALApplicationGetRequest.Status status = request.getStatus();
        if (limit > 0) {
            query.limit(limit);
        }
        if (page > 0) {
            query.page(page);
        }
        switch (status) {
            case ACTIVE: {
                query.where(Operations.eq((String)"status", (Object)1));
                break;
            }
            case INACTIVE: {
                query.where(Operations.eq((String)"status", (Object)0));
                break;
            }
        }
        String appId = request.getAppId();
        if (appId != null && appId.length() > 0) {
            query.where(Operations.eq((String)"appId", (Object)appId));
        }
        query.orderAscending("title");
        return query;
    }

    public String getContainerConfig(ALSocialApplicationHandler.Property property) {
        ContainerConfig config = null;
        Object obj = ALEipManager.getInstance().getContainerConfig(property.toString());
        if (obj != null) {
            return (String)obj;
        }
        config = (ContainerConfig)Database.query(ContainerConfig.class).where(Operations.eq((String)"name", (Object)property.toString())).fetchSingle();
        if (config == null) {
            ALEipManager.getInstance().setContainerConfig(property.toString(), (Object)property.defaultValue());
            return property.defaultValue();
        }
        ALEipManager.getInstance().setContainerConfig(property.toString(), (Object)config.getValue());
        return config.getValue();
    }

    public void putContainerConfig(ALSocialApplicationHandler.Property property, String value) {
        try {
            ContainerConfig config = (ContainerConfig)Database.query(ContainerConfig.class).where(Operations.eq((String)"name", (Object)property.toString())).fetchSingle();
            if (config == null) {
                config = (ContainerConfig)Database.create(ContainerConfig.class);
                config.setName(property.toString());
            }
            config.setValue(value);
            Database.commit();
        }
        catch (Throwable t) {
            Database.rollback();
            throw new RuntimeException(t);
        }
    }

    public ResultList<ALActivity> getActivityList(ALActivityGetRequest request) {
        SelectQuery<Activity> query = this.buildActivityQuery(request);
        ResultList resultList = query.getResultList();
        ArrayList<ALActivity> list = new ArrayList<ALActivity>(resultList.size());
        for (Activity model : resultList) {
            ALActivity activity = new ALActivity();
            activity.setId(model.getId().intValue());
            activity.setLoginName(model.getLoginName());
            activity.setAppId(model.getAppId());
            activity.setTitle(model.getTitle());
            activity.setUpdateDate(model.getUpdateDate());
            activity.setExternalId(model.getExternalId());
            activity.setPortletParams(model.getPortletParams());
            activity.setIcon(model.getIcon());
            activity.setModuleId(model.getModuleId());
            try {
                ALEipUser user = ALEipUtils.getALEipUser((String)model.getLoginName());
                if (model.getAppId().equals("timeline") && user == null) {
                    activity.setDisplayName(model.getLoginName());
                } else {
                    activity.setDisplayName(user.getAliasName().getValue());
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            String loginName = request.getTargetLoginName();
            if (loginName != null && loginName.length() > 0) {
                activity.setRead(this.isReadActivity(model.getId(), loginName));
            } else {
                activity.setRead(true);
            }
            list.add(activity);
        }
        ResultList result = new ResultList(list, resultList.getLimit(), resultList.getPage(), resultList.getTotalCount());
        return result;
    }

    public ALActivity getActivity(ALActivityGetRequest request) {
        SelectQuery<Activity> query = this.buildActivityQuery(request);
        Activity model = (Activity)query.fetchSingle();
        if (model == null) {
            return null;
        }
        ALActivity activity = new ALActivity();
        activity.setId(model.getId().intValue());
        activity.setAppId(model.getAppId());
        activity.setLoginName(model.getLoginName());
        activity.setTitle(model.getTitle());
        activity.setUpdateDate(model.getUpdateDate());
        activity.setExternalId(model.getExternalId());
        activity.setPortletParams(model.getPortletParams());
        activity.setIcon(model.getIcon());
        String loginName = request.getTargetLoginName();
        if (loginName != null && loginName.length() > 0) {
            activity.setRead(this.isReadActivity(model.getId(), loginName));
        } else {
            activity.setRead(false);
        }
        try {
            ALEipUser user = ALEipUtils.getALEipUser((String)model.getLoginName());
            activity.setDisplayName(user.getAliasName().getValue());
        }
        catch (ALDBErrorException e) {
            // empty catch block
        }
        return activity;
    }

    public ALActivityCount getActivityCount(ALActivityGetRequest request) {
        ALActivityCount result = new ALActivityCount();
        result.setCount(this.buildActivityQuery(request).getCount());
        request.setRead(-1);
        Activity activity = (Activity)this.buildActivityQuery(request).limit(1).fetchSingle();
        if (activity != null) {
            result.setMax(activity.getUpdateDate().getTime());
        }
        return result;
    }

    public void setAllReadActivity(String loginName) {
        try {
            DataContext dataContext = DataContext.getThreadDataContext();
            String url = dataContext.getParentDataDomain().getNode(Database.getDomainName() + "domainNode").getDataSource().getConnection().getMetaData().getURL();
            String sql = "";
            if (url != null && url.startsWith("jdbc:postgresql")) {
                StringBuilder b = new StringBuilder("update activity_map set is_read = 1 ");
                b.append(" from activity where activity_map.activity_id = activity.id ");
                b.append(" and activity_map.login_name = #bind($loginName) ");
                sql = b.toString();
            } else {
                StringBuilder b = new StringBuilder("update activity_map, activity set is_read = 1 ");
                b.append(" where activity_map.activity_id = activity.id ");
                b.append(" and activity_map.login_name = #bind($loginName) ");
                sql = b.toString();
            }
            Database.sql(ActivityMap.class, (String)sql).param("loginName", (Object)loginName).execute();
        }
        catch (Throwable t) {
            Database.rollback();
            logger.warn((Object)"[ALDefaultSocialApplicationHanlder]", t);
        }
    }

    public void setReadActivity(int activityId, String loginName) {
        try {
            DataContext dataContext = DataContext.getThreadDataContext();
            String url = dataContext.getParentDataDomain().getNode(Database.getDomainName() + "domainNode").getDataSource().getConnection().getMetaData().getURL();
            String sql = "";
            if (url != null && url.startsWith("jdbc:postgresql")) {
                StringBuilder b = new StringBuilder("update activity_map set is_read = 1 ");
                b.append(" from activity where activity_map.activity_id = activity.id ");
                b.append(" and activity.id = #bind($activityId) ");
                b.append(" and activity_map.login_name = #bind($loginName) ");
                sql = b.toString();
            } else {
                StringBuilder b = new StringBuilder("update activity_map, activity set is_read = 1 ");
                b.append(" where activity_map.activity_id = activity.id ");
                b.append(" and activity.id = #bind($activityId) ");
                b.append(" and activity_map.login_name = #bind($loginName) ");
                sql = b.toString();
            }
            Database.sql(ActivityMap.class, (String)sql).param("activityId", (Object)activityId).param("loginName", (Object)loginName).execute();
        }
        catch (Throwable t) {
            Database.rollback();
            logger.warn((Object)"[ALDefaultSocialApplicationHanlder]", t);
        }
    }

    public boolean isReadActivity(int activityId, String loginName) {
        StringBuilder b = new StringBuilder("select activity_map.is_read from activity_map inner join activity on activity_map.activity_id = activity.id ");
        b.append(" and activity.id = #bind($activityId) ");
        b.append(" and activity_map.login_name = #bind($loginName) ");
        String sql = b.toString();
        try {
            ActivityMap activityMap = (ActivityMap)Database.sql(ActivityMap.class, (String)sql).param("activityId", (Object)activityId).param("loginName", (Object)loginName).fetchSingle();
            if (activityMap != null) {
                return activityMap.getIsRead() == 1;
            }
        }
        catch (Throwable t) {
            Database.rollback();
            logger.warn((Object)"[ALDefaultSocialApplicationHanlder]", t);
        }
        return true;
    }

    protected SelectQuery<Activity> buildActivityQuery(ALActivityGetRequest request) {
        long max;
        String postId;
        String appId;
        String loginName;
        String keyword;
        float priority;
        int external_id;
        int isRead;
        int page;
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        SelectQuery query = Database.query(Activity.class);
        int limit = request.getLimit();
        if (limit > 0) {
            query.limit(limit);
        }
        if ((page = request.getPage()) > 0) {
            query.page(page);
        }
        if ((isRead = request.isRead()) >= 0) {
            query.where(Operations.eq((String)"activityMaps.isRead", (Object)isRead));
        }
        if ((external_id = request.getExternalId()) > 0) {
            query.where(Operations.eq((String)"externalId", (Object)external_id));
        }
        if ((priority = request.getPriority()) >= 0.0f) {
            query.where(Operations.eq((String)"priority", (Object)Float.valueOf(priority)));
        }
        if ((keyword = request.getKeyword()) != null && !keyword.equals("")) {
            query.where(Operations.contains((String)"title", (Object)keyword).or(Operations.contains((String)"loginName", (Object)keyword)));
        }
        if ((loginName = request.getLoginName()) != null && loginName.length() > 0) {
            ALEipUser user = null;
            try {
                user = ALEipUtils.getALEipUser((String)loginName);
            }
            catch (ALDBErrorException e) {
                throw new RuntimeException(e);
            }
            if (priority < 1.0f) {
                if (!aclhandler.hasAuthority((int)user.getUserId().getValue(), "msgboard_topic", 1)) {
                    query.where(Operations.ne((String)"appId", (Object)"Msgboard"));
                }
                if (!aclhandler.hasAuthority((int)user.getUserId().getValue(), "blog_entry_other", 1)) {
                    query.where(Operations.ne((String)"appId", (Object)"blog"));
                }
            }
            query.where(Operations.ne((String)"loginName", (Object)loginName));
        }
        String targetLoginName = request.getTargetLoginName();
        boolean targetLoginNameLimit = request.isTargetLoginNameLimit();
        if (targetLoginName != null && targetLoginName.length() > 0) {
            if (!targetLoginNameLimit) {
                query.where(Operations.in((String)"activityMaps.loginName", (Object[])new Object[]{targetLoginName, "-1"}));
            } else {
                query.where(Operations.in((String)"activityMaps.loginName", (Object[])new Object[]{targetLoginName}));
            }
        }
        if ((appId = request.getAppId()) != null && appId.length() > 0) {
            if (appId.equals("Gadget")) {
                query.where(Operations.ne((String)"appId", (Object)"Schedule"));
                query.where(Operations.ne((String)"appId", (Object)"Blog"));
                query.where(Operations.ne((String)"appId", (Object)"Msgboard"));
                query.where(Operations.ne((String)"appId", (Object)"ToDo"));
                query.where(Operations.ne((String)"appId", (Object)"Cabinet"));
            } else {
                query.where(Operations.eq((String)"appId", (Object)appId));
            }
        }
        if ((postId = request.getPostId()) != null && !"".equals(postId)) {
            List userIds = ALEipUtils.getUserIds((String)postId);
            ArrayList<String> loginNameList = new ArrayList<String>();
            Iterator iterator = userIds.iterator();
            while (iterator.hasNext()) {
                int userId = (Integer)iterator.next();
                try {
                    String name = ALEipUtils.getALEipUser((int)userId).getName().getValue();
                    loginNameList.add(name);
                }
                catch (ALDBErrorException e) {}
            }
            if (!loginNameList.isEmpty()) {
                query.where(Operations.in((String)"loginName", loginNameList));
            }
        }
        if ((max = request.getMax()) > 0L) {
            Date date = new Date();
            date.setTime(max);
            query.where(Operations.gt((String)"updateDate", (Object)date));
        }
        query.orderDesending("updateDate");
        return query;
    }

    public void createActivity(ALActivityPutRequest request) {
        block22: {
            try {
                ALApplication application;
                Activity activity = (Activity)Database.create(Activity.class);
                activity.setAppId(request.getAppId());
                activity.setLoginName(request.getLoginName());
                activity.setBody(request.getBody());
                activity.setExternalId(request.getExternalId());
                activity.setModuleId(Integer.valueOf(0));
                Float priority = Float.valueOf(request.getPriority());
                if (priority.floatValue() < 0.0f) {
                    priority = Float.valueOf(0.0f);
                }
                if (priority.floatValue() > 1.0f) {
                    priority = Float.valueOf(1.0f);
                }
                activity.setPriority(priority);
                activity.setTitle(request.getTitle());
                activity.setPortletParams(request.getPortletParams());
                activity.setUpdateDate(new Date());
                List recipients = request.getRecipients();
                if (recipients != null && recipients.size() > 0) {
                    for (String recipient : recipients) {
                        ActivityMap activityMap = (ActivityMap)Database.create(ActivityMap.class);
                        activityMap.setLoginName(recipient);
                        activityMap.setActivity(activity);
                        activityMap.setIsRead(Integer.valueOf(priority.floatValue() == 1.0f ? 0 : 1));
                    }
                    if (priority.floatValue() == 1.0f) {
                        HashMap params = new HashMap();
                        ALPushService.pushAsync((String)"activity", params, (List)recipients);
                    }
                } else {
                    ActivityMap activityMap = (ActivityMap)Database.create(ActivityMap.class);
                    activityMap.setLoginName("-1");
                    activityMap.setActivity(activity);
                    activityMap.setIsRead(Integer.valueOf(1));
                }
                if ((application = this.getApplication(new ALApplicationGetRequest().withAppId(request.getAppId()))) != null) {
                    activity.setIcon(application.getIcon().getValue());
                }
                String activitySaveLimit = ALContainerConfigService.get((ALSocialApplicationHandler.Property)ALSocialApplicationHandler.Property.ACTIVITY_SAVE_LIMIT);
                int limit = 30;
                try {
                    limit = Integer.valueOf(activitySaveLimit);
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                Calendar cal = Calendar.getInstance();
                cal.add(5, -limit);
                Database.query(ActivityMap.class).where(Operations.lt((String)"activity.updateDate", (Object)cal.getTime())).deleteAll();
                String sql = "delete from activity where update_date < '" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(cal.getTime()) + "'";
                Database.sql(Activity.class, (String)sql).execute();
                Database.commit();
                if (priority.floatValue() != 0.0f) break block22;
                Calendar tCal = Calendar.getInstance();
                int parentId = 0;
                Calendar tCalBefore = Calendar.getInstance();
                tCalBefore.set(tCal.get(1), tCal.get(2), tCal.get(5), 0, 0, 0);
                Calendar tCalAfter = Calendar.getInstance();
                tCalAfter.set(tCal.get(1), tCal.get(2), tCal.get(5), 0, 0, 0);
                tCalAfter.add(5, 1);
                Expression exp1 = ExpressionFactory.matchExp((String)"ownerId", (Object)request.getUserId());
                Expression exp2 = ExpressionFactory.matchExp((String)"timelineType", (Object)"A");
                Expression exp3 = ExpressionFactory.matchExp((String)"parentId", (Object)0);
                Expression exp4 = ExpressionFactory.betweenExp((String)"createDate", (Object)tCalBefore.getTime(), (Object)tCalAfter.getTime());
                Expression exp5 = ExpressionFactory.matchExp((String)"appId", (Object)"ACTIVITY_PARENT");
                Expression exp6 = ExpressionFactory.matchExp((String)"externalId", (Object)"0");
                SelectQuery tQuery = Database.query(EipTTimeline.class);
                tQuery.andQualifier(exp1.andExp(exp2.andExp(exp3.andExp(exp4.andExp(exp5).andExp(exp6)))));
                tQuery.distinct(true);
                List parents = tQuery.fetchList();
                if (parents != null && parents.size() != 0) {
                    parentId = ((EipTTimeline)parents.get(0)).getTimelineId();
                    EipTTimeline parent = (EipTTimeline)Database.get(EipTTimeline.class, (Object)parentId);
                    parent.setUpdateDate(tCal.getTime());
                } else {
                    EipTTimeline timeline = (EipTTimeline)Database.create(EipTTimeline.class);
                    timeline.setParentId(Integer.valueOf(0));
                    timeline.setOwnerId(Integer.valueOf(request.getUserId()));
                    timeline.setAppId("ACTIVITY_PARENT");
                    timeline.setExternalId("0");
                    timeline.setNote("");
                    timeline.setTimelineType("A");
                    timeline.setParams(new SimpleDateFormat("yyyyMMdd").format(cal.getTime()));
                    timeline.setCreateDate(tCal.getTime());
                    timeline.setUpdateDate(tCal.getTime());
                    Database.commit();
                    this.daysFirstActivate(request.getLoginName());
                    ALApplication application2 = this.getApplication(new ALApplicationGetRequest().withAppId(request.getAppId()));
                    if (application2 != null) {
                        activity.setIcon(application2.getIcon().getValue());
                    }
                    String activitySaveLimit2 = ALContainerConfigService.get((ALSocialApplicationHandler.Property)ALSocialApplicationHandler.Property.ACTIVITY_SAVE_LIMIT);
                    int limit2 = 30;
                    try {
                        limit2 = Integer.valueOf(activitySaveLimit2);
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    Calendar cal2 = Calendar.getInstance();
                    cal2.add(5, -limit2);
                    Database.query(EipTTimelineMap.class).where(Operations.lt((String)"eipTTimeline.updateDate", (Object)cal2.getTime())).deleteAll();
                    tQuery = Database.query(EipTTimeline.class);
                    tQuery.andQualifier(exp1.andExp(exp2.andExp(exp3.andExp(exp4.andExp(exp5).andExp(exp6)))));
                    tQuery.distinct(true);
                    parents = tQuery.fetchList();
                    if (parents != null && parents.size() != 0) {
                        parentId = ((EipTTimeline)parents.get(0)).getTimelineId();
                        EipTTimeline parent = (EipTTimeline)Database.get(EipTTimeline.class, (Object)parentId);
                        parent.setUpdateDate(tCal.getTime());
                    }
                }
                exp1 = ExpressionFactory.matchExp((String)"timelineType", (Object)"A");
                exp2 = ExpressionFactory.matchExp((String)"ownerId", (Object)request.getUserId());
                exp3 = ExpressionFactory.matchExp((String)"appId", (Object)request.getAppId());
                exp4 = ExpressionFactory.matchExp((String)"externalId", (Object)request.getExternalId());
                tQuery = Database.query(EipTTimeline.class);
                tQuery.andQualifier(exp1.andExp(exp2.andExp(exp3.andExp(exp4))));
                tQuery.distinct(true);
                List olders = tQuery.fetchList();
                if (olders != null && olders.size() != 0) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String timelineSql = "UPDATE eip_t_timeline SET parent_id = #bind($parentId) , note = #bind($title) , params = #bind($portletParams) , update_date =  '" + sdf.format(tCal.getTime()) + "'" + " WHERE timeline_type = 'A' " + " AND owner_id = #bind($userId) " + " AND app_id = #bind($appId) " + " AND external_id = #bind($externalId); ";
                    Database.sql(EipTTimeline.class, (String)timelineSql).param("parentId", (Object)parentId).param("title", (Object)request.getTitle()).param("portletParams", (Object)request.getPortletParams()).param("userId", (Object)request.getUserId()).param("appId", (Object)request.getAppId()).param("externalId", (Object)request.getExternalId()).execute();
                } else {
                    EipTTimeline timeline = (EipTTimeline)Database.create(EipTTimeline.class);
                    timeline.setParentId(Integer.valueOf(parentId));
                    timeline.setOwnerId(Integer.valueOf(request.getUserId()));
                    timeline.setAppId(request.getAppId());
                    timeline.setExternalId(request.getExternalId());
                    timeline.setNote(request.getTitle());
                    timeline.setTimelineType("A");
                    timeline.setParams(request.getPortletParams());
                    timeline.setCreateDate(tCal.getTime());
                    timeline.setUpdateDate(tCal.getTime());
                    if (recipients != null && recipients.size() > 0) {
                        for (String recipient : recipients) {
                            EipTTimelineMap timelineMap = (EipTTimelineMap)Database.create(EipTTimelineMap.class);
                            timelineMap.setLoginName(recipient);
                            timelineMap.setEipTTimeline(timeline);
                            timelineMap.setIsRead(Integer.valueOf(priority.floatValue() == 1.0f ? 0 : 1));
                        }
                    } else {
                        EipTTimelineMap timelineMap = (EipTTimelineMap)Database.create(EipTTimelineMap.class);
                        timelineMap.setLoginName("-1");
                        timelineMap.setEipTTimeline(timeline);
                        timelineMap.setIsRead(Integer.valueOf(1));
                    }
                }
                Database.commit();
            }
            catch (Throwable t) {
                Database.rollback();
                throw new RuntimeException(t);
            }
        }
    }

    public long getNextModuleId() {
        ModuleId moduleId = null;
        try {
            moduleId = (ModuleId)Database.create(ModuleId.class);
            Database.commit();
        }
        catch (Throwable t) {
            Database.rollback();
            throw new RuntimeException(t);
        }
        long next = moduleId.getId().longValue();
        try {
            String sql = "delete from module_id";
            Database.sql(ModuleId.class, (String)sql).execute();
        }
        catch (Throwable t) {
            Database.rollback();
        }
        return next;
    }

    public void deleteUserData(String ... loginNameList) {
        try {
            for (String loginName : loginNameList) {
                String sql1 = "delete from app_data where login_name = #bind($loginName)";
                Database.sql(AppData.class, (String)sql1).param("loginName", (Object)loginName).execute();
                String sql2 = "delete from activity where login_name = #bind($loginName)";
                Database.sql(Activity.class, (String)sql2).param("loginName", (Object)loginName).execute();
                String sql3 = "delete from activity_map where login_name = #bind($loginName)";
                Database.sql(Activity.class, (String)sql3).param("loginName", (Object)loginName).execute();
            }
            Database.commit();
        }
        catch (Throwable t) {
            Database.rollback();
            throw new RuntimeException(t);
        }
    }

    public void deleteUserData(List<String> loginNameList) {
        this.deleteUserData(loginNameList.toArray(new String[loginNameList.size()]));
    }

    protected void daysFirstActivate(String uid) {
    }
}

