/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.accessctl.action;

import com.aimluck.eip.cayenne.om.account.EipTAclPortletFeature;
import com.aimluck.eip.cayenne.om.account.EipTAclRole;
import com.aimluck.eip.cayenne.om.account.EipTAclUserRoleMap;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SQLTemplate;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.DataRow;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;

public class ALActionAccessControlHandler
extends ALAccessControlHandler {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALActionAccessControlHandler.class.getName());

    public boolean hasAuthority(int userId, String featureName, int aclType) {
        Map roleMap = ALEipManager.getInstance().getAclRoleMap(userId);
        EipTAclRole role = (EipTAclRole)roleMap.get(featureName);
        if (role == null) {
            return false;
        }
        int dbAclType = role.getAclType();
        return (dbAclType & aclType) == aclType;
    }

    public List<Integer> getAcceptUserIdsExceptLoginUser(int uid, String feat, int acl_type) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        sb.append("USER_ID");
        sb.append(" FROM turbine_user WHERE (");
        sb.append("USER_ID");
        sb.append(" IN (SELECT ");
        sb.append("USER_ID");
        sb.append(" FROM eip_t_acl_user_role_map WHERE ");
        sb.append("ROLE_ID");
        sb.append(" IN (SELECT ");
        sb.append("ROLE_ID");
        sb.append(" FROM eip_t_acl_role WHERE ((");
        sb.append("ACL_TYPE");
        sb.append(" & ");
        sb.append(Integer.toString(acl_type));
        sb.append(") = ");
        sb.append(Integer.toString(acl_type));
        sb.append(") AND (");
        sb.append("FEATURE_ID");
        sb.append(" IN (SELECT ");
        sb.append("FEATURE_ID");
        sb.append(" FROM eip_t_acl_portlet_feature WHERE ");
        sb.append("FEATURE_NAME");
        sb.append("='");
        sb.append(feat.trim());
        sb.append("'))))) AND (");
        sb.append("USER_ID");
        sb.append(" != ");
        sb.append(Integer.toString(uid));
        sb.append(")");
        ArrayList<Integer> userIds = new ArrayList<Integer>();
        String sqlString = sb.toString();
        List list = Database.sql(TurbineUser.class, (String)sqlString).fetchList();
        for (TurbineUser tuser : list) {
            userIds.add(tuser.getUserId());
        }
        return userIds;
    }

    public List<Integer> getAcceptUserIdsInListExceptLoginUser(int uid, String feat, int acl_type, List<ALEipUser> ulist) {
        int u_size;
        ArrayList<Integer> userIds = new ArrayList<Integer>();
        if (ulist == null || (u_size = ulist.size()) < 1) {
            return userIds;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        sb.append("USER_ID");
        sb.append(" FROM turbine_user WHERE (");
        sb.append("USER_ID");
        sb.append(" IN (SELECT ");
        sb.append("USER_ID");
        sb.append(" FROM turbine_user_group_role WHERE ");
        sb.append("ROLE_ID");
        sb.append(" IN (SELECT ");
        sb.append("ROLE_ID");
        sb.append(" FROM eip_t_acl_role WHERE ((");
        sb.append("ACL_TYPE");
        sb.append(" & ");
        sb.append("#bind($aclType)");
        sb.append(") = ");
        sb.append("#bind($aclType)");
        sb.append(") AND (");
        sb.append("FEATURE_ID");
        sb.append(" IN (SELECT ");
        sb.append("FEATURE_ID");
        sb.append(" FROM eip_t_acl_portlet_feature WHERE ");
        sb.append("FEATURE_NAME");
        sb.append("= ");
        sb.append("#bind($feat)");
        sb.append("))))) AND (");
        sb.append("USER_ID");
        sb.append(" in (");
        for (int i = 0; i < u_size; ++i) {
            sb.append("#bind($").append(Integer.toString(i)).append(")");
            if (i + 1 >= u_size) continue;
            sb.append(",");
        }
        sb.append(")) AND (");
        sb.append("USER_ID");
        sb.append(" != ");
        sb.append("#bind($uid)");
        sb.append(")");
        String sqlString = sb.toString();
        SQLTemplate template = Database.sql(TurbineUser.class, (String)sqlString);
        template.param("aclType", (Object)acl_type);
        template.param("feat", (Object)feat.trim());
        template.param("uid", (Object)uid);
        for (int i = 0; i < u_size; ++i) {
            ALEipUser member = ulist.get(i);
            template.param(Integer.toString(i), (Object)((int)member.getUserId().getValue()));
        }
        List list = template.fetchList();
        for (TurbineUser tuser : list) {
            userIds.add(tuser.getUserId());
        }
        return userIds;
    }

    public List<TurbineUser> getAuthorityUsersFromGroup(RunData rundata, String feat, String groupname, boolean includeLoginuser) {
        int listNumber = 1;
        int detailNumber = 2;
        int updateNumber = 8;
        int aclNumber = listNumber | detailNumber | updateNumber;
        StringBuffer sb = new StringBuffer();
        sb.append("(SELECT ");
        sb.append("USER_ID");
        sb.append(" FROM eip_t_acl_user_role_map WHERE ");
        sb.append("ROLE_ID");
        sb.append(" IN (SELECT ");
        sb.append("ROLE_ID");
        sb.append(" FROM eip_t_acl_role WHERE ((");
        sb.append("ACL_TYPE");
        sb.append(" & ");
        sb.append("#bind($aclNumber)");
        sb.append(") = ");
        sb.append("#bind($aclNumber)");
        sb.append(") AND (");
        sb.append("FEATURE_ID");
        sb.append(" IN (SELECT ");
        sb.append("FEATURE_ID");
        sb.append(" FROM eip_t_acl_portlet_feature WHERE ");
        sb.append("FEATURE_NAME");
        sb.append("= ");
        sb.append("#bind($feat)");
        sb.append("))))");
        StringBuffer statement = new StringBuffer();
        statement.append("SELECT DISTINCT ");
        statement.append("B.USER_ID, B.LOGIN_NAME, B.FIRST_NAME, B.LAST_NAME, D.POSITION ");
        statement.append("FROM turbine_user_group_role as A ");
        statement.append("LEFT JOIN turbine_user as B ");
        statement.append("on A.USER_ID = B.USER_ID ");
        statement.append("LEFT JOIN turbine_group as C ");
        statement.append("on A.GROUP_ID = C.GROUP_ID ");
        statement.append("LEFT JOIN eip_m_user_position as D ");
        statement.append("on A.USER_ID = D.USER_ID ");
        statement.append("WHERE B.USER_ID IN ");
        statement.append(sb);
        statement.append(" AND B.DISABLED = 'F'");
        statement.append(" AND C.GROUP_NAME = #bind($groupname) ");
        statement.append("ORDER BY D.POSITION");
        SQLTemplate template = Database.sql(TurbineUser.class, (String)statement.toString());
        template.param("aclNumber", (Object)aclNumber);
        template.param("feat", (Object)feat.trim());
        template.param("groupname", (Object)groupname);
        List list = template.fetchList();
        return list;
    }

    public void insertDefaultRole(int uid) throws Exception {
        TurbineUser tuser = (TurbineUser)Database.get(TurbineUser.class, (Object)uid);
        StringBuilder sql = new StringBuilder().append("SELECT * FROM eip_t_acl_role ").append(" WHERE create_date IS NULL");
        SQLTemplate sqltemp = Database.sql(EipTAclRole.class, (String)String.valueOf(sql));
        List fetchList = sqltemp.fetchListAsDataRow();
        ArrayList<EipTAclRole> list = new ArrayList<EipTAclRole>();
        for (DataRow row : fetchList) {
            EipTAclRole object = (EipTAclRole)Database.objectFromRowData((DataRow)row, EipTAclRole.class);
            EipTAclRole eipTAclRole = (EipTAclRole)Database.get(EipTAclRole.class, (Object)object.getRoleId());
            EipTAclPortletFeature feature = (EipTAclPortletFeature)Database.get(EipTAclPortletFeature.class, (Object)row.get((Object)"feature_id"));
            eipTAclRole.setEipTAclPortletFeature(feature);
            list.add(eipTAclRole);
        }
        for (EipTAclRole role : list) {
            EipTAclUserRoleMap map = (EipTAclUserRoleMap)Database.create(EipTAclUserRoleMap.class);
            map.setEipTAclRole(role);
            map.setTurbineUser(tuser);
        }
    }
}

