/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.oid;

import com.workingdogs.village.QueryDataSet;
import com.workingdogs.village.Record;
import com.workingdogs.village.Value;
import java.math.BigDecimal;
import java.sql.Connection;
import org.apache.torque.adapter.DB;
import org.apache.torque.oid.IdGenerator;

public class AutoIncrementIdGenerator
implements IdGenerator {
    private DB dbAdapter;

    public AutoIncrementIdGenerator(DB adapter) {
        this.dbAdapter = adapter;
    }

    public int getIdAsInt(Connection connection, Object keyInfo) throws Exception {
        return this.getIdAsVillageValue(connection, keyInfo).asInt();
    }

    public long getIdAsLong(Connection connection, Object keyInfo) throws Exception {
        return this.getIdAsVillageValue(connection, keyInfo).asLong();
    }

    public BigDecimal getIdAsBigDecimal(Connection connection, Object keyInfo) throws Exception {
        return this.getIdAsVillageValue(connection, keyInfo).asBigDecimal();
    }

    public String getIdAsString(Connection connection, Object keyInfo) throws Exception {
        return this.getIdAsVillageValue(connection, keyInfo).asString();
    }

    public boolean isPriorToInsert() {
        return false;
    }

    public boolean isPostInsert() {
        return true;
    }

    public final boolean isConnectionRequired() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value getIdAsVillageValue(Connection connection, Object keyInfo) throws Exception {
        String idSQL = this.dbAdapter.getIDMethodSQL(keyInfo);
        Value id = null;
        QueryDataSet qds = null;
        try {
            qds = new QueryDataSet(connection, idSQL);
            qds.fetchRecords(1);
            Record rec = qds.getRecord(0);
            id = rec.getValue(1);
        }
        finally {
            if (qds != null) {
                qds.close();
            }
        }
        return id;
    }
}

