/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.om;

import java.io.Serializable;
import java.sql.Connection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.TorqueException;
import org.apache.torque.om.ComboKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.Persistent;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.om.StringKey;

public abstract class BaseObject
implements Persistent,
Serializable {
    public static final int NEW_ID = -1;
    private static final String NOT_IMPLEMENTED = "Not implemented: Method must be overridden if called";
    private boolean isNew = true;
    private ObjectKey primaryKey = null;
    private boolean modified = true;
    private transient Log log = null;

    public ObjectKey getPrimaryKey() {
        return this.primaryKey;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean b) {
        this.isNew = b;
    }

    public void setPrimaryKey(String primaryKey) throws TorqueException {
        this.primaryKey = new StringKey(primaryKey);
    }

    public void setPrimaryKey(SimpleKey[] primaryKey) throws TorqueException {
        this.primaryKey = new ComboKey(primaryKey);
    }

    public void setPrimaryKey(ObjectKey primaryKey) throws TorqueException {
        this.primaryKey = primaryKey;
    }

    public void setModified(boolean m) {
        this.modified = m;
    }

    public void resetModified() {
        this.modified = false;
    }

    public Object getByName(String field) {
        throw new Error("BaseObject.getByName: Not implemented: Method must be overridden if called");
    }

    public Object getByPeerName(String name) {
        throw new Error("BaseObject.getByPeerName: Not implemented: Method must be overridden if called");
    }

    public Object getByPosition(int pos) {
        throw new Error("BaseObject.getByPosition: Not implemented: Method must be overridden if called");
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof BaseObject) {
            return this.equals((BaseObject)obj);
        }
        return false;
    }

    public boolean equals(BaseObject bo) {
        if (bo == null) {
            return false;
        }
        if (this == bo) {
            return true;
        }
        if (this.getPrimaryKey() == null || bo.getPrimaryKey() == null) {
            return false;
        }
        return this.getPrimaryKey().equals(bo.getPrimaryKey());
    }

    public int hashCode() {
        ObjectKey ok = this.getPrimaryKey();
        if (ok == null) {
            return super.hashCode();
        }
        return ok.hashCode();
    }

    protected Log log() {
        return this.getLog();
    }

    protected Log getLog() {
        if (this.log == null) {
            this.log = LogFactory.getLog((String)this.getClass().getName());
        }
        return this.log;
    }

    public abstract void save() throws Exception;

    public abstract void save(String var1) throws Exception;

    public abstract void save(Connection var1) throws Exception;
}

