/*
 * Decompiled with CFR 0.152.
 */
package com.develop.jcfe.attribute;

import com.develop.jcfe.attribute.Attribute;
import com.develop.jcfe.attribute.ExceptionTableEntry;
import com.develop.jcfe.cpool.ConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;

public class CodeAttribute
extends Attribute {
    private short max_stack = (short)-1;
    private short max_locals = (short)-1;
    private int code_length = -1;
    private byte[] code;
    private short exception_table_length = 0;
    private Vector exception_table = new Vector();
    private ArrayList attributes = new ArrayList();

    public byte[] getCode() {
        return this.code;
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    public CodeAttribute(ConstantPool cp, DataInputStream dis, short name_index, int attribute_length) throws IOException {
        super("Code", name_index);
        this.max_stack = dis.readShort();
        this.max_locals = dis.readShort();
        this.code_length = dis.readInt();
        this.code = new byte[this.code_length];
        dis.readFully(this.code);
        this.exception_table_length = dis.readShort();
        short loop = 0;
        while (loop < this.exception_table_length) {
            this.exception_table.addElement(ExceptionTableEntry.read(dis));
            loop = (short)(loop + 1);
        }
        short attributes_count = dis.readShort();
        loop = 0;
        while (loop < attributes_count) {
            Attribute inf = Attribute.read(cp, dis);
            this.attributes.add(inf);
            loop = (short)(loop + 1);
        }
    }

    public int getLength() {
        int length = 12 + this.code.length + this.exception_table_length * 8;
        int n = 0;
        while (n < this.attributes.size()) {
            length += this.getAttribute(n).getTotalLength();
            ++n;
        }
        return length;
    }

    public CodeAttribute(ConstantPool cp, short max_stack, short max_locals, byte[] code, Vector exception_table) {
        super("Code", cp.addUtf8("Code"));
        this.max_stack = max_stack;
        this.max_locals = max_locals;
        this.code = code;
        this.exception_table = exception_table;
        this.exception_table_length = (short)exception_table.size();
        this.code_length = code.length;
    }

    public ExceptionTableEntry getExceptionTableEntry(int n) {
        return (ExceptionTableEntry)this.exception_table.elementAt(n);
    }

    public Attribute getAttribute(int n) {
        return (Attribute)this.attributes.get(n);
    }

    public void writeToStream(DataOutputStream ds) throws IOException {
        super.writeToStream(ds);
        ds.writeShort(this.max_stack);
        ds.writeShort(this.max_locals);
        ds.writeInt(this.code_length);
        ds.write(this.code);
        ds.writeShort(this.exception_table_length);
        int n = 0;
        while (n < this.exception_table.size()) {
            this.getExceptionTableEntry(n).writeToStream(ds);
            ++n;
        }
        ds.writeShort(this.attributes.size());
        int n2 = 0;
        while (n2 < this.attributes.size()) {
            this.getAttribute(n2).writeToStream(ds);
            ++n2;
        }
    }
}

