/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.server;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.server.BrokerPool;
import ojb.broker.server.RequestProcessor;
import ojb.broker.util.LoggerFactory;

public class PersistenceBrokerServer {
    private static final String defaultFileName = "repository.xml";
    private static final int defaultPort = 2001;
    private File repositoryFile;
    private ServerSocket server;
    public static int THREADCOUNT = 10;
    private Vector processors = new Vector();
    private BrokerPool brokers;

    BrokerPool getBrokerPool() {
        return this.brokers;
    }

    public PersistenceBrokerServer(File repositoryFile, int port) throws IOException {
        this.repositoryFile = repositoryFile.getCanonicalFile();
        this.server = new ServerSocket(port);
        this.brokers = new BrokerPool(repositoryFile);
    }

    public PersistenceBrokerServer(File repositoryFile) throws IOException {
        this(repositoryFile, 2001);
    }

    private RequestProcessor addNewProcessor() {
        RequestProcessor t = new RequestProcessor(this, this.brokers);
        this.processors.addElement(t);
        return t;
    }

    void releaseProcessor(RequestProcessor p) {
        Vector vector = this.processors;
        synchronized (vector) {
            this.processors.addElement(p);
            this.processors.notifyAll();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        int i = 0;
        while (i < THREADCOUNT) {
            new Thread((Runnable)this.addNewProcessor(), "OJB RequestProcessor " + this.processors.size()).start();
            ++i;
        }
        System.setProperty("OJB.servermode", "true");
        LoggerFactory.getBootLogger().info("PersistenceBrokerServer is accepting connections on port " + this.server.getLocalPort());
        while (true) {
            try {
                block8: while (true) {
                    Socket request = this.server.accept();
                    Vector vector = this.processors;
                    synchronized (vector) {
                        while (true) {
                            if (!this.processors.isEmpty()) {
                                RequestProcessor rp = (RequestProcessor)this.processors.elementAt(0);
                                this.processors.removeElementAt(0);
                                rp.setSocket(request);
                                continue block8;
                            }
                            try {
                                this.processors.wait();
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                    }
                    break;
                }
            }
            catch (IOException e) {
                LoggerFactory.getBootLogger().error(e);
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        int port;
        if (!PersistenceBrokerFactory.getConfiguration().isServerUsed()) {
            LoggerFactory.getBootLogger().fatal("OJB is not properly configured to run in server mode, check OJB.properties");
            System.exit(-1);
        }
        File repositoryFile = null;
        try {
            repositoryFile = new File(args[0]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LoggerFactory.getBootLogger().fatal("Usage: java PersistenceBrokerServer RepositoryFile [port]");
            System.exit(-1);
        }
        try {
            port = Integer.parseInt(args[1]);
            if (port < 0 || port > 65535) {
                port = 2001;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LoggerFactory.getBootLogger().warn("no port specified, will use default: 2001");
            port = 2001;
        }
        catch (Throwable t) {
            LoggerFactory.getBootLogger().error("invalid port: " + args[1] + ". will use default: " + 2001);
            port = 2001;
        }
        try {
            PersistenceBrokerServer pbserver = new PersistenceBrokerServer(repositoryFile, port);
            pbserver.run();
        }
        catch (IOException e) {
            LoggerFactory.getBootLogger().fatal("OJB PersistenceBrokerServer could not start because of an " + e.getClass());
            LoggerFactory.getBootLogger().fatal(e);
            System.exit(-1);
        }
    }
}

