/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.services.portal.impl;

import com.aimluck.eip.cayenne.om.account.EipMInactiveApplication;
import com.aimluck.eip.http.HttpServletRequestLocator;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.services.portal.ALPortalApplicationHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class ALDefaultPortalApplicationHandler
extends ALPortalApplicationHandler {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALDefaultPortalApplicationHandler.class.getName());
    private static ALPortalApplicationHandler instance;
    public static final String KEY_INACTIVE_APPLICATIONS = "com.aipo.portal.inactive.applications";

    public static ALPortalApplicationHandler getInstance() {
        if (instance == null) {
            instance = new ALDefaultPortalApplicationHandler();
        }
        return instance;
    }

    public boolean isActive(String portletName) {
        List<String> list = this.getInactiveApplicationList();
        return !list.contains(portletName);
    }

    protected List<String> getInactiveApplicationList() {
        HttpServletRequest request = HttpServletRequestLocator.get();
        List<String> result = null;
        if (request != null) {
            try {
                Object attr = request.getAttribute(KEY_INACTIVE_APPLICATIONS);
                if (attr != null) {
                    result = this.explode((String)attr, ",");
                }
            }
            catch (Throwable t) {
                logger.warn((Object)"[ALDefaultPortalApplicationHandler]", t);
            }
        }
        if (result == null) {
            result = this.getInactiveApplicationListByQuery();
        }
        return result;
    }

    protected List<String> getInactiveApplicationListByQuery() {
        List list = Database.query(EipMInactiveApplication.class).fetchList();
        ArrayList<String> result = new ArrayList<String>();
        for (EipMInactiveApplication model : list) {
            result.add(model.getName());
        }
        HttpServletRequest request = HttpServletRequestLocator.get();
        if (request != null) {
            try {
                String value = this.implode(result, ",");
                request.setAttribute(KEY_INACTIVE_APPLICATIONS, (Object)value);
            }
            catch (Throwable t) {
                logger.warn((Object)"[ALDefaultPortalApplicationHandler]", t);
            }
        }
        return result;
    }

    protected List<String> explode(String s, String separator) {
        StringTokenizer st = new StringTokenizer(s, separator);
        ArrayList<String> v = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        return v;
    }

    protected String implode(List<String> array, String separator) {
        StringBuilder out = new StringBuilder();
        boolean first = true;
        for (String v : array) {
            if (first) {
                first = false;
            } else {
                out.append(separator);
            }
            out.append(v);
        }
        return out.toString();
    }
}

