/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.account;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.account.util.AccountUtils;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPosition;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.services.datasync.ALDataSyncFactoryService;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AccountEditFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AccountEditFormData.class.getName());
    private static final String DEFAULT_VIEW_PASSWORD = "******";
    private ALStringField loginname;
    private ALStringField firstname;
    private ALStringField lastname;
    private ALStringField new_password;
    private ALStringField new_password_confirm;
    private ALStringField email;
    private ALStringField in_telephone;
    private ALStringField out_telephone1;
    private ALStringField out_telephone2;
    private ALStringField out_telephone3;
    private ALStringField cellular_phone1;
    private ALStringField cellular_phone2;
    private ALStringField cellular_phone3;
    private ALStringField cellular_mail;
    private ALStringField first_name_kana;
    private ALStringField last_name_kana;
    private final List<ALStringField> post_name_list = new ArrayList<ALStringField>();
    private ALStringField position_name;
    private ALStringField photo = null;
    private FileuploadLiteBean filebean = null;
    private String folderName = null;
    private String orgId;
    private byte[] facePhoto;
    private byte[] facePhoto_smartphone;
    private boolean dontUpdatePasswd = false;
    private boolean delete_photo = false;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"entityid", (String)rundata.getUser().getUserName());
        }
        this.folderName = rundata.getParameters().getString("folderName");
        this.orgId = Database.getDomainName();
        this.delete_photo = rundata.getParameters().getBoolean("delete_photo", false);
    }

    public void initField() {
        this.loginname = new ALStringField();
        this.loginname.setFieldName(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_LOGIN_NAME", (Object[])new Object[0]));
        this.loginname.setTrim(true);
        this.firstname = new ALStringField();
        this.firstname.setFieldName(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_LASTNAME", (Object[])new Object[0]));
        this.firstname.setTrim(true);
        this.lastname = new ALStringField();
        this.lastname.setFieldName(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_FIRSTNAME", (Object[])new Object[0]));
        this.lastname.setTrim(true);
        this.new_password = new ALStringField();
        this.new_password.setFieldName(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_PASS", (Object[])new Object[0]));
        this.new_password.setTrim(true);
        this.new_password_confirm = new ALStringField();
        this.new_password_confirm.setFieldName(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_PASSWORDCONFIRMMSG_NOT_INDENTION", (Object[])new Object[0]));
        this.new_password_confirm.setTrim(true);
        this.email = new ALStringField();
        this.email.setFieldName(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_USER_EMAIL", (Object[])new Object[0]));
        this.email.setTrim(true);
        this.in_telephone = new ALStringField();
        this.in_telephone.setFieldName(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_IN_TELEPHONE", (Object[])new Object[0]));
        this.in_telephone.setTrim(true);
        this.out_telephone1 = new ALStringField();
        this.out_telephone1.setFieldName(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_OUT_TELEPHONE", (Object[])new Object[0]));
        this.out_telephone1.setTrim(true);
        this.out_telephone2 = new ALStringField();
        this.out_telephone2.setFieldName(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_OUT_TELEPHONE", (Object[])new Object[0]));
        this.out_telephone2.setTrim(true);
        this.out_telephone3 = new ALStringField();
        this.out_telephone3.setFieldName(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_OUT_TELEPHONE", (Object[])new Object[0]));
        this.out_telephone3.setTrim(true);
        this.cellular_phone1 = new ALStringField();
        this.cellular_phone1.setFieldName(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_USER_CELLULAR_PHONE", (Object[])new Object[0]));
        this.cellular_phone1.setTrim(true);
        this.cellular_phone2 = new ALStringField();
        this.cellular_phone2.setFieldName(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_USER_CELLULAR_PHONE", (Object[])new Object[0]));
        this.cellular_phone2.setTrim(true);
        this.cellular_phone3 = new ALStringField();
        this.cellular_phone3.setFieldName(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_USER_CELLULAR_PHONE", (Object[])new Object[0]));
        this.cellular_phone3.setTrim(true);
        this.cellular_mail = new ALStringField();
        this.cellular_mail.setFieldName(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_USER_CELLULAR_MAIL", (Object[])new Object[0]));
        this.cellular_mail.setTrim(true);
        this.first_name_kana = new ALStringField();
        this.first_name_kana.setFieldName(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_LAST_NAME_SPELL1", (Object[])new Object[0]));
        this.first_name_kana.setTrim(true);
        this.last_name_kana = new ALStringField();
        this.last_name_kana.setFieldName(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_FIRST_NAME_SPELL1", (Object[])new Object[0]));
        this.last_name_kana.setTrim(true);
        this.position_name = new ALStringField();
        this.position_name.setFieldName(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_POSITION", (Object[])new Object[0]));
        this.position_name.setTrim(true);
        this.photo = new ALStringField();
        this.photo.setFieldName(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_USER_PHOTO", (Object[])new Object[0]));
        this.photo.setTrim(true);
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        try {
            List fileBeanList;
            if (res && (fileBeanList = FileuploadUtils.getFileuploadList((RunData)rundata)) != null && fileBeanList.size() > 0) {
                this.filebean = (FileuploadLiteBean)fileBeanList.get(0);
                if (this.filebean.getFileId() != 0) {
                    String[] acceptExts = ImageIO.getWriterFormatNames();
                    this.facePhoto_smartphone = null;
                    FileuploadUtils.ShrinkImageSet bytesShrinkFilebean = FileuploadUtils.getBytesShrinkFilebean((String)this.orgId, (String)this.folderName, (int)ALEipUtils.getUserId((RunData)rundata), (FileuploadLiteBean)this.filebean, (String[])acceptExts, (int)64, (int)64, msgList, (boolean)false);
                    if (bytesShrinkFilebean != null) {
                        this.facePhoto_smartphone = bytesShrinkFilebean.getShrinkImage();
                    }
                    String[] acceptExts2 = ImageIO.getWriterFormatNames();
                    this.facePhoto = null;
                    FileuploadUtils.ShrinkImageSet bytesShrinkFilebean2 = FileuploadUtils.getBytesShrinkFilebean((String)this.orgId, (String)this.folderName, (int)ALEipUtils.getUserId((RunData)rundata), (FileuploadLiteBean)this.filebean, (String[])acceptExts2, (int)86, (int)86, msgList, (boolean)false);
                    if (bytesShrinkFilebean2 != null) {
                        this.facePhoto = bytesShrinkFilebean2.getShrinkImage();
                    }
                } else {
                    this.facePhoto = null;
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"AccountEditFormData.setFormData", (Throwable)ex);
            res = false;
        }
        return res;
    }

    protected void setValidator() {
        this.firstname.setNotNull(true);
        this.firstname.limitMaxLength(50);
        this.lastname.setNotNull(true);
        this.lastname.limitMaxLength(50);
        this.first_name_kana.setNotNull(true);
        this.first_name_kana.limitMaxLength(50);
        this.last_name_kana.setNotNull(true);
        this.last_name_kana.limitMaxLength(50);
        this.new_password.setNotNull(true);
        this.new_password.setCharacterType(19);
        this.new_password.limitMaxLength(16);
        this.new_password_confirm.setNotNull(true);
        this.new_password_confirm.setCharacterType(19);
        this.new_password_confirm.limitMaxLength(16);
        this.in_telephone.setCharacterType(19);
        this.in_telephone.limitMaxLength(13);
        this.email.setCharacterType(19);
        this.out_telephone1.setCharacterType(2);
        this.out_telephone1.limitMaxLength(5);
        this.out_telephone2.setCharacterType(2);
        this.out_telephone2.limitMaxLength(4);
        this.out_telephone3.setCharacterType(2);
        this.out_telephone3.limitMaxLength(4);
        this.cellular_phone1.setCharacterType(2);
        this.cellular_phone1.limitMaxLength(5);
        this.cellular_phone2.setCharacterType(2);
        this.cellular_phone2.limitMaxLength(4);
        this.cellular_phone3.setCharacterType(2);
        this.cellular_phone3.limitMaxLength(4);
        this.cellular_mail.setCharacterType(19);
        this.cellular_mail.limitMaxLength(50);
    }

    protected boolean validate(List<String> msgList) {
        ArrayList dummy = new ArrayList();
        this.firstname.validate(msgList);
        this.lastname.validate(msgList);
        this.first_name_kana.setValue(ALStringUtil.convertHiragana2Katakana((String)ALStringUtil.convertH2ZKana((String)this.first_name_kana.toString())));
        this.last_name_kana.setValue(ALStringUtil.convertHiragana2Katakana((String)ALStringUtil.convertH2ZKana((String)this.last_name_kana.toString())));
        this.first_name_kana.validate(msgList);
        this.last_name_kana.validate(msgList);
        if (!this.new_password.toString().equals(this.new_password_confirm.toString())) {
            msgList.add(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_ALERT_NEWPW", (Object[])new Object[0]));
        }
        this.in_telephone.validate(msgList);
        Pattern pattern = Pattern.compile(".*[^-0-9]+.*");
        Matcher matcher = pattern.matcher(this.in_telephone.getValue());
        Boolean ext_validater = matcher.matches();
        if (ext_validater.booleanValue()) {
            msgList.add(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_POST_WITHIN_SIXTEEN", (Object[])new Object[0]));
        }
        this.email.validate(msgList);
        if (this.email.getValue() != null && this.email.getValue().trim().length() > 0 && !ALStringUtil.isMailAddress((String)this.email.getValue())) {
            msgList.add(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_ALERT_EMAIL", (Object[])new Object[0]));
        }
        this.cellular_mail.validate(msgList);
        if (this.cellular_mail.getValue().trim().length() > 0 && !ALStringUtil.isCellPhoneMailAddress((String)this.cellular_mail.getValue())) {
            msgList.add(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_ALERT_EMAIL_MOBILE", (Object[])new Object[0]));
        }
        if (!(this.out_telephone1.getValue().equals("") && this.out_telephone2.getValue().equals("") && this.out_telephone3.getValue().equals("") || this.out_telephone1.validate(dummy) && this.out_telephone2.validate(dummy) && this.out_telephone3.validate(dummy))) {
            msgList.add(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_POST_SET_TELEPHON_EXTERNAL_NOMBER", (Object[])new Object[0]));
        }
        if (!(this.cellular_phone1.getValue().equals("") && this.cellular_phone2.getValue().equals("") && this.cellular_phone3.getValue().equals("") || this.cellular_phone1.validate(dummy) && this.cellular_phone2.validate(dummy) && this.cellular_phone3.validate(dummy))) {
            msgList.add(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_ALERT_TELEPHONE_MOBILE", (Object[])new Object[0]));
        }
        if (this.filebean != null && this.filebean.getFileId() != 0 && this.facePhoto == null) {
            msgList.add(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_ALERT_PHOTO", (Object[])new Object[0]));
        }
        if ("insert".equals(this.getMode())) {
            if (!this.new_password.getValue().equals(this.new_password_confirm.getValue())) {
                msgList.add(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_ALERT_PASSWORD", (Object[])new Object[0]));
            } else {
                this.new_password.validate(msgList);
                this.new_password_confirm.validate(msgList);
            }
        } else if ("update".equals(this.getMode())) {
            if (this.new_password.getValue().equals(DEFAULT_VIEW_PASSWORD) && this.new_password_confirm.getValue().equals(DEFAULT_VIEW_PASSWORD)) {
                this.dontUpdatePasswd = true;
            } else if (!this.new_password.getValue().equals(this.new_password_confirm.getValue())) {
                msgList.add(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_ALERT_PASSWORD", (Object[])new Object[0]));
            } else {
                this.new_password.validate(msgList);
                this.new_password_confirm.validate(msgList);
            }
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            StringTokenizer token;
            ALBaseUser user = AccountUtils.getBaseUser(rundata, context);
            if (user == null) {
                logger.debug((Object)("Not found. (" + AccountEditFormData.class.getName() + ")"));
                return false;
            }
            this.loginname.setValue(user.getUserName());
            this.firstname.setValue(user.getFirstName());
            this.lastname.setValue(user.getLastName());
            this.email.setValue(user.getEmail());
            this.in_telephone.setValue(user.getInTelephone());
            if (user.getOutTelephone() != null && (token = new StringTokenizer(user.getOutTelephone(), "-")).countTokens() == 3) {
                this.out_telephone1.setValue(token.nextToken());
                this.out_telephone2.setValue(token.nextToken());
                this.out_telephone3.setValue(token.nextToken());
            }
            if (user.getCellularPhone() != null && (token = new StringTokenizer(user.getCellularPhone(), "-")).countTokens() == 3) {
                this.cellular_phone1.setValue(token.nextToken());
                this.cellular_phone2.setValue(token.nextToken());
                this.cellular_phone3.setValue(token.nextToken());
            }
            this.cellular_mail.setValue(user.getCellularMail());
            this.first_name_kana.setValue(user.getFirstNameKana());
            this.last_name_kana.setValue(user.getLastNameKana());
            List postNames = ALEipUtils.getPostNameList((int)Integer.valueOf(user.getUserId()));
            this.setPostNameList(postNames);
            this.position_name.setValue(this.getPositionName(user.getPositionId()));
            if (user.getPhoto() != null) {
                this.filebean = new FileuploadLiteBean();
                this.filebean.initField();
                this.filebean.setFolderName("");
                this.filebean.setFileId(0);
                this.filebean.setFileName(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_OLD_PHOTO", (Object[])new Object[0]));
                this.filebean.setUserId(Integer.parseInt(user.getUserId()));
                this.filebean.setPhotoModified(String.valueOf(user.getPhotoModified().getTime()));
            }
            this.new_password.setValue(DEFAULT_VIEW_PASSWORD);
            this.new_password_confirm.setValue(DEFAULT_VIEW_PASSWORD);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"AccountEditFormData.loadFormData", (Throwable)e);
            return false;
        }
    }

    public void loadEmail(RunData rundata) {
        try {
            ALBaseUser user = (ALBaseUser)rundata.getUser();
            if (user == null) {
                logger.debug((Object)("Not found. (" + AccountEditFormData.class.getName() + ")"));
                this.email.setValue("");
            } else {
                this.email.setValue(user.getEmail());
            }
        }
        catch (Exception e) {
            logger.error((Object)"AccountEditFormData.loadEmail", (Throwable)e);
        }
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            ALBaseUser user = AccountUtils.getBaseUser(rundata, context);
            if (user == null) {
                return false;
            }
            if (!ALDataSyncFactoryService.getInstance().getDataSyncHandler().checkConnect()) {
                msgList.add(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_ALERT_CONNECT_DB_FAILED", (Object[])new Object[0]));
                return false;
            }
            user.setLastAccessDate();
            user.setFirstName(this.firstname.getValue());
            user.setLastName(this.lastname.getValue());
            user.setInTelephone(this.in_telephone.getValue());
            if (!(this.out_telephone1.getValue().equals("") || this.out_telephone2.getValue().equals("") || this.out_telephone3.getValue().equals(""))) {
                user.setOutTelephone(new StringBuffer().append(this.out_telephone1.getValue()).append("-").append(this.out_telephone2.getValue()).append("-").append(this.out_telephone3.getValue()).toString());
            } else {
                user.setOutTelephone("");
            }
            if (!(this.cellular_phone1.getValue().equals("") || this.cellular_phone2.getValue().equals("") || this.cellular_phone3.getValue().equals(""))) {
                user.setCellularPhone(new StringBuffer().append(this.cellular_phone1.getValue()).append("-").append(this.cellular_phone2.getValue()).append("-").append(this.cellular_phone3.getValue()).toString());
            } else {
                user.setCellularPhone("");
            }
            user.setCellularMail(this.cellular_mail.getValue());
            user.setFirstNameKana(this.first_name_kana.getValue());
            user.setLastNameKana(this.last_name_kana.getValue());
            user.setEmail(this.email.getValue());
            if (this.filebean != null && this.filebean.getFileId() != 0) {
                user.setPhotoSmartphone(this.facePhoto_smartphone);
                user.setHasPhotoSmartphone(true);
                user.setPhotoModifiedSmartphone(new Date());
                user.setPhoto(this.facePhoto);
                user.setHasPhoto(true);
                user.setPhotoModified(new Date());
            } else if (this.delete_photo) {
                user.setPhoto(null);
                user.setHasPhoto(false);
                user.setPhotoSmartphone(null);
                user.setHasPhotoSmartphone(false);
            }
            if (!this.dontUpdatePasswd) {
                JetspeedSecurity.forcePassword((JetspeedUser)user, (String)this.new_password.getValue());
            } else {
                TurbineUser tuser = (TurbineUser)Database.get(TurbineUser.class, (Object)user.getUserId());
                user.setPassword(tuser.getPasswordValue());
            }
            JetspeedSecurity.saveUser((JetspeedUser)user);
            if (!ALDataSyncFactoryService.getInstance().getDataSyncHandler().updateUser(user)) {
                return false;
            }
            ALBaseUser currentUser = (ALBaseUser)rundata.getUser();
            if (currentUser.getUserName().equals(user.getUserName())) {
                currentUser.setPassword(user.getPassword());
                currentUser.setHasPhoto(user.hasPhoto());
                currentUser.setPhotoModified(user.getPhotoModified());
            }
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(Integer.valueOf(user.getUserId()).intValue(), 260, null);
            ALStorageService.deleteTmpFolder((int)ALEipUtils.getUserId((RunData)rundata), (String)this.folderName);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"AccountEditFormData.updateFormData", (Throwable)e);
            return false;
        }
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    public ALStringField getCellularMail() {
        return this.cellular_mail;
    }

    public ALStringField getEmail() {
        return this.email;
    }

    public ALStringField getFirstNameKana() {
        return this.first_name_kana;
    }

    public ALStringField getFirstName() {
        return this.firstname;
    }

    public ALStringField getNewPassword() {
        return this.new_password;
    }

    public ALStringField getNewPasswordConfirm() {
        return this.new_password_confirm;
    }

    public void setNewPassword(String field) {
        this.new_password.setValue(field);
    }

    public void setNewPasswordConfirm(String field) {
        this.new_password_confirm.setValue(field);
    }

    public ALStringField getInTelephone() {
        return this.in_telephone;
    }

    public ALStringField getLastNameKana() {
        return this.last_name_kana;
    }

    public ALStringField getLastName() {
        return this.lastname;
    }

    public ALStringField getCellularPhone1() {
        return this.cellular_phone1;
    }

    public ALStringField getCellularPhone2() {
        return this.cellular_phone2;
    }

    public ALStringField getCellularPhone3() {
        return this.cellular_phone3;
    }

    public ALStringField getOutTelephone1() {
        return this.out_telephone1;
    }

    public ALStringField getOutTelephone2() {
        return this.out_telephone2;
    }

    public ALStringField getOutTelephone3() {
        return this.out_telephone3;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public List<FileuploadLiteBean> getAttachmentFileNameList() {
        if (this.filebean == null) {
            return null;
        }
        ArrayList<FileuploadLiteBean> list = new ArrayList<FileuploadLiteBean>();
        list.add(this.filebean);
        return list;
    }

    public List<ALStringField> getPostNameList() {
        return this.post_name_list;
    }

    public void setPostNameList(List<ALStringField> list) {
        this.post_name_list.addAll(list);
    }

    public ALStringField getPositionName() {
        return this.position_name;
    }

    public void setLoginName(ALStringField loginname) {
        this.loginname = loginname;
    }

    public ALStringField getLoginName() {
        return this.loginname;
    }

    private String getPositionName(int id) {
        if (ALEipManager.getInstance().getPositionMap().containsKey(id)) {
            return ((ALEipPosition)ALEipManager.getInstance().getPositionMap().get(id)).getPositionName().getValue();
        }
        return null;
    }
}

