/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.account;

import com.aimluck.eip.cayenne.om.account.EipMPosition;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AccountPositionMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AccountPositionMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, List<String> values, List<String> msgList) {
        try {
            List<EipMPosition> list = this.getEipMPositions(rundata, context, values);
            if (list == null || list.size() == 0) {
                return false;
            }
            EipMPosition position = null;
            ArrayList<Integer> ids = new ArrayList<Integer>();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                position = list.get(i);
                ids.add(position.getPositionId());
            }
            Expression exp = ExpressionFactory.inDbExp((String)"POSITION_ID", ids);
            SelectQuery query = Database.query(EipMPosition.class, (Expression)exp);
            List postisions = query.fetchList();
            int psize = postisions.size();
            for (int i = 0; i < psize; ++i) {
                Database.delete((Persistent)((Persistent)list.get(i)));
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(list.get(i).getPositionId().intValue(), 3, "\u5f79\u8077\u300c" + list.get(i).getPositionName() + "\u300d\u3092\u524a\u9664");
            }
            int idssize = ids.size();
            for (int i = 0; i < idssize; ++i) {
                String sql = "UPDATE turbine_user set POSITION_ID = 0 where POSITION_ID = " + (Integer)ids.get(i);
                Database.sql(TurbineUser.class, (String)sql).execute();
            }
            Database.commit();
            ALEipManager.getInstance().reloadPosition();
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"AccountPositionMultiDelete.action", (Throwable)ex);
            return false;
        }
        return true;
    }

    private List<EipMPosition> getEipMPositions(RunData rundata, Context context, List<String> values) {
        List list = null;
        try {
            if (values == null || values.size() == 0) {
                logger.debug((Object)"values are empty...");
                return null;
            }
            Expression exp = ExpressionFactory.inDbExp((String)"POSITION_ID", values);
            SelectQuery query = Database.query(EipMPosition.class, (Expression)exp);
            list = query.fetchList();
            if (list == null || list.size() == 0) {
                logger.debug((Object)"Not found ID...");
                return null;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"AccountPositionMultiDelete.getEipMPositions", (Throwable)ex);
            list = null;
        }
        return list;
    }
}

