/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.access.DbLoaderDelegate;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.util.EntityMergeSupport;
import org.apache.cayenne.util.NameConverter;
import org.apache.cayenne.util.Util;
import org.apache.log4j.Logger;
import org.objectstyle.ashwood.dbutil.Table;

public class DbLoader {
    private static Logger logObj = Logger.getLogger(DbLoader.class);
    private static final Collection EXCLUDED_PROCEDURES = Arrays.asList("auto_pk_for_table", "auto_pk_for_table;1");
    public static final String WILDCARD = "%";
    private List dbEntityList = new ArrayList();
    private Set skippedEntities = new HashSet();
    protected Connection con;
    protected DbAdapter adapter;
    protected DatabaseMetaData metaData;
    protected DbLoaderDelegate delegate;
    protected String genericClassName;

    private static String defaultRelName(String dstName, boolean toMany) {
        String uglyName = toMany ? dstName + "_ARRAY" : "to_" + dstName;
        return NameConverter.underscoredToJava(uglyName, false);
    }

    private static String uniqueRelName(Entity entity, String dstName, boolean toMany) {
        String baseRelName;
        int currentSuffix = 1;
        String relName = baseRelName = DbLoader.defaultRelName(dstName, toMany);
        while (entity.getRelationship(relName) != null) {
            relName = baseRelName + currentSuffix;
            ++currentSuffix;
        }
        return relName;
    }

    public DbLoader(Connection con, DbAdapter adapter, DbLoaderDelegate delegate) {
        this.adapter = adapter;
        this.con = con;
        this.delegate = delegate;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (null == this.metaData) {
            this.metaData = this.con.getMetaData();
        }
        return this.metaData;
    }

    public Connection getCon() {
        return this.con;
    }

    public String getGenericClassName() {
        return this.genericClassName;
    }

    public void setGenericClassName(String genericClassName) {
        this.genericClassName = genericClassName;
    }

    public DbAdapter getAdapter() {
        return this.adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCatalogs() throws SQLException {
        ArrayList<String> catalogs = new ArrayList<String>();
        ResultSet rs = this.getMetaData().getCatalogs();
        try {
            while (rs.next()) {
                String catalog_name = rs.getString(1);
                catalogs.add(catalog_name);
            }
        }
        finally {
            rs.close();
        }
        return catalogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSchemas() throws SQLException {
        ArrayList<String> schemas = new ArrayList<String>();
        ResultSet rs = this.getMetaData().getSchemas();
        try {
            while (rs.next()) {
                String schema_name = rs.getString(1);
                schemas.add(schema_name);
            }
        }
        finally {
            rs.close();
        }
        return schemas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTableTypes() throws SQLException {
        ArrayList<String> types = new ArrayList<String>();
        ResultSet rs = this.getMetaData().getTableTypes();
        try {
            while (rs.next()) {
                types.add(rs.getString("TABLE_TYPE").trim());
            }
        }
        finally {
            rs.close();
        }
        return types;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        ArrayList<Table> tables = new ArrayList<Table>();
        if (logObj.isDebugEnabled()) {
            logObj.debug("Read tables: catalog=" + catalog + ", schema=" + schemaPattern + ", tableNames=" + tableNamePattern);
            if (types != null && types.length > 0) {
                for (int i = 0; i < types.length; ++i) {
                    logObj.debug("Read tables: table type=" + types[i]);
                }
            }
        }
        ResultSet rs = this.getMetaData().getTables(catalog, schemaPattern, tableNamePattern, types);
        try {
            while (rs.next()) {
                String cat = rs.getString("TABLE_CAT");
                String schema = rs.getString("TABLE_SCHEM");
                String name = rs.getString("TABLE_NAME");
                if (name == null || name.startsWith("BIN$")) continue;
                Table info = new Table(cat, schema, name);
                tables.add(info);
            }
        }
        finally {
            rs.close();
        }
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadDbEntities(DataMap map, List tables) throws SQLException {
        ResultSet rs;
        this.dbEntityList = new ArrayList();
        Iterator iter = tables.iterator();
        while (iter.hasNext()) {
            Table table;
            block21: {
                table = (Table)iter.next();
                DbEntity oldEnt = map.getDbEntity(table.getName());
                if (oldEnt != null) {
                    if (this.delegate == null) {
                        return false;
                    }
                    try {
                        if (this.delegate.overwriteDbEntity(oldEnt)) {
                            logObj.debug("Overwrite: " + oldEnt.getName());
                            map.removeDbEntity(oldEnt.getName(), true);
                            this.delegate.dbEntityRemoved(oldEnt);
                            break block21;
                        }
                        logObj.debug("Keep old: " + oldEnt.getName());
                        this.skippedEntities.add(oldEnt);
                        continue;
                    }
                    catch (CayenneException ex) {
                        logObj.debug("Load canceled.");
                        return false;
                    }
                }
            }
            DbEntity dbEntity = new DbEntity();
            dbEntity.setName(table.getName());
            dbEntity.setSchema(table.getSchema());
            dbEntity.setCatalog(table.getCatalog());
            rs = this.getMetaData().getColumns(table.getCatalog(), table.getSchema(), table.getName(), WILDCARD);
            try {
                while (rs.next()) {
                    String tableName = rs.getString("TABLE_NAME");
                    if (!dbEntity.getName().equals(tableName)) {
                        logObj.info("Incorrectly returned columns for '" + tableName + ", skipping.");
                        continue;
                    }
                    String columnName = rs.getString("COLUMN_NAME");
                    boolean allowNulls = rs.getBoolean("NULLABLE");
                    int columnType = rs.getInt("DATA_TYPE");
                    int columnSize = rs.getInt("COLUMN_SIZE");
                    String typeName = rs.getString("TYPE_NAME");
                    int decimalDigits = -1;
                    if (TypesMapping.isDecimal(columnType)) {
                        decimalDigits = rs.getInt("DECIMAL_DIGITS");
                        if (rs.wasNull()) {
                            decimalDigits = -1;
                        }
                    }
                    DbAttribute attr = this.adapter.buildAttribute(columnName, typeName, columnType, columnSize, decimalDigits, allowNulls);
                    attr.setEntity(dbEntity);
                    dbEntity.addAttribute(attr);
                }
            }
            finally {
                rs.close();
            }
            map.addDbEntity(dbEntity);
            if (this.delegate != null) {
                this.delegate.dbEntityAdded(dbEntity);
            }
            if (map.getDbEntity(table.getName()) != dbEntity) continue;
            this.dbEntityList.add(dbEntity);
        }
        Iterator i = map.getDbEntities().iterator();
        while (i.hasNext()) {
            DbEntity dbEntity = (DbEntity)i.next();
            String tableName = dbEntity.getName();
            rs = this.metaData.getPrimaryKeys(null, dbEntity.getSchema(), tableName);
            try {
                while (rs.next()) {
                    String keyName = rs.getString(4);
                    DbAttribute attribute = (DbAttribute)dbEntity.getAttribute(keyName);
                    if (attribute != null) {
                        attribute.setPrimaryKey(true);
                        continue;
                    }
                    logObj.warn("Can't locate attribute for primary key: " + keyName);
                }
            }
            finally {
                rs.close();
            }
        }
        Iterator skippedEntityIter = this.skippedEntities.iterator();
        while (skippedEntityIter.hasNext()) {
            DbEntity skippedEntity = (DbEntity)skippedEntityIter.next();
            this.loadDbRelationships(skippedEntity, map);
        }
        return true;
    }

    public void loadObjEntities(DataMap map) {
        Iterator dbEntities = this.dbEntityList.iterator();
        if (!dbEntities.hasNext()) {
            return;
        }
        ArrayList<ObjEntity> loadedEntities = new ArrayList<ObjEntity>(this.dbEntityList.size());
        String packageName = map.getDefaultPackage();
        if (Util.isEmptyString(packageName)) {
            packageName = "";
        } else if (!packageName.endsWith(".")) {
            packageName = packageName + ".";
        }
        while (dbEntities.hasNext()) {
            String objEntityName;
            DbEntity dbEntity = (DbEntity)dbEntities.next();
            Collection existing = map.getMappedEntities(dbEntity);
            if (existing.size() > 0) {
                loadedEntities.addAll(existing);
                continue;
            }
            String baseName = objEntityName = NameConverter.underscoredToJava(dbEntity.getName(), true);
            for (int i = 1; i < 1000 && map.getObjEntity(objEntityName) != null; ++i) {
                objEntityName = baseName + i;
            }
            ObjEntity objEntity = new ObjEntity(objEntityName);
            objEntity.setDbEntity(dbEntity);
            objEntity.setClassName(this.getGenericClassName() != null ? this.getGenericClassName() : packageName + objEntity.getName());
            map.addObjEntity(objEntity);
            loadedEntities.add(objEntity);
            if (this.delegate == null) continue;
            this.delegate.objEntityAdded(objEntity);
        }
        new EntityMergeSupport(map).synchronizeWithDbEntities(loadedEntities);
    }

    public void loadDbRelationships(DataMap map) throws SQLException {
        Iterator it = this.dbEntityList.iterator();
        while (it.hasNext()) {
            DbEntity pkEntity = (DbEntity)it.next();
            this.loadDbRelationships(pkEntity, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDbRelationships(DbEntity pkEntity, DataMap map) throws SQLException {
        DatabaseMetaData md = this.getMetaData();
        String pkEntName = pkEntity.getName();
        ResultSet rs = null;
        try {
            rs = md.getExportedKeys(pkEntity.getCatalog(), pkEntity.getSchema(), pkEntity.getName());
        }
        catch (SQLException cay182Ex) {
            logObj.info("Error getting relationships for '" + pkEntName + "', ignoring.");
            return;
        }
        try {
            if (!rs.next()) {
                return;
            }
            DbRelationship forwardRelationship = null;
            DbRelationship reverseRelationship = null;
            DbEntity fkEntity = null;
            do {
                short keySeq;
                if ((keySeq = rs.getShort("KEY_SEQ")) == 1) {
                    String fkEntityName;
                    if (forwardRelationship != null) {
                        this.postprocessMasterDbRelationship(forwardRelationship);
                        forwardRelationship = null;
                    }
                    if ((fkEntity = map.getDbEntity(fkEntityName = rs.getString("FKTABLE_NAME"))) == null) {
                        logObj.info("FK warning: no entity found for name '" + fkEntityName + "'");
                    } else {
                        if (this.skippedEntities.contains(pkEntity) && this.skippedEntities.contains(fkEntity)) continue;
                        forwardRelationship = new DbRelationship(DbLoader.uniqueRelName(pkEntity, fkEntityName, true));
                        forwardRelationship.setSourceEntity(pkEntity);
                        forwardRelationship.setTargetEntity(fkEntity);
                        pkEntity.addRelationship(forwardRelationship);
                        reverseRelationship = new DbRelationship(DbLoader.uniqueRelName(fkEntity, pkEntName, false));
                        reverseRelationship.setToMany(false);
                        reverseRelationship.setSourceEntity(fkEntity);
                        reverseRelationship.setTargetEntity(pkEntity);
                        fkEntity.addRelationship(reverseRelationship);
                    }
                }
                if (fkEntity == null) continue;
                String pkName = rs.getString("PKCOLUMN_NAME");
                String fkName = rs.getString("FKCOLUMN_NAME");
                DbAttribute pkAtt = (DbAttribute)pkEntity.getAttribute(pkName);
                if (pkAtt == null) {
                    logObj.info("no attribute for declared primary key: " + pkName);
                    continue;
                }
                DbAttribute fkAtt = (DbAttribute)fkEntity.getAttribute(fkName);
                if (fkAtt == null) {
                    logObj.info("no attribute for declared foreign key: " + fkName);
                    continue;
                }
                forwardRelationship.addJoin(new DbJoin(forwardRelationship, pkName, fkName));
                reverseRelationship.addJoin(new DbJoin(reverseRelationship, fkName, pkName));
            } while (rs.next());
            if (forwardRelationship != null) {
                this.postprocessMasterDbRelationship(forwardRelationship);
                forwardRelationship = null;
            }
        }
        finally {
            rs.close();
        }
    }

    protected void postprocessMasterDbRelationship(DbRelationship relationship) {
        boolean toPK = true;
        List joins = relationship.getJoins();
        Iterator joinsIt = joins.iterator();
        while (joinsIt.hasNext()) {
            DbJoin join = (DbJoin)joinsIt.next();
            if (join.getTarget().isPrimaryKey()) continue;
            toPK = false;
            break;
        }
        boolean toDependentPK = false;
        boolean toMany = true;
        if (toPK) {
            toDependentPK = true;
            if (((DbEntity)relationship.getTargetEntity()).getPrimaryKey().size() == joins.size()) {
                toMany = false;
            }
        }
        if (!toMany) {
            Entity source = relationship.getSourceEntity();
            source.removeRelationship(relationship.getName());
            relationship.setName(DbLoader.uniqueRelName(source, relationship.getTargetEntityName(), false));
            source.addRelationship(relationship);
        }
        relationship.setToDependentPK(toDependentPK);
        relationship.setToMany(toMany);
    }

    private String[] getDefaultTableTypes() {
        String viewType = this.adapter.tableTypeForView();
        String tableType = this.adapter.tableTypeForTable();
        ArrayList<String> list = new ArrayList<String>();
        if (viewType != null) {
            list.add(viewType);
        }
        if (tableType != null) {
            list.add(tableType);
        }
        String[] types = new String[list.size()];
        list.toArray(types);
        return types;
    }

    public DataMap loadDataMapFromDB(String schemaName, String tablePattern, DataMap dataMap) throws SQLException {
        String[] types = this.getDefaultTableTypes();
        if (types.length == 0) {
            throw new SQLException("No supported table types found.");
        }
        return this.loadDataMapFromDB(schemaName, tablePattern, types, dataMap);
    }

    public DataMap loadDataMapFromDB(String schemaName, String tablePattern, String[] tableTypes, DataMap dataMap) throws SQLException {
        if (tablePattern == null) {
            tablePattern = WILDCARD;
        }
        if (!this.loadDbEntities(dataMap, this.getTables(null, schemaName, tablePattern, tableTypes))) {
            return dataMap;
        }
        this.loadDbRelationships(dataMap);
        this.loadObjEntities(dataMap);
        return dataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProceduresFromDB(String schemaPattern, String namePattern, DataMap dataMap) throws SQLException {
        HashMap<String, Procedure> procedures = null;
        ResultSet rs = this.getMetaData().getProcedures(null, schemaPattern, namePattern);
        try {
            while (rs.next()) {
                String name = rs.getString("PROCEDURE_NAME");
                if (EXCLUDED_PROCEDURES.contains(name)) {
                    logObj.info("skipping Cayenne PK procedure: " + name);
                    continue;
                }
                String catalog = rs.getString("PROCEDURE_CAT");
                String schema = rs.getString("PROCEDURE_SCHEM");
                short type = rs.getShort("PROCEDURE_TYPE");
                Procedure procedure = new Procedure(name);
                procedure.setCatalog(catalog);
                procedure.setSchema(schema);
                switch (type) {
                    case 0: 
                    case 1: {
                        procedure.setReturningValue(false);
                        break;
                    }
                    case 2: {
                        procedure.setReturningValue(true);
                    }
                }
                if (procedures == null) {
                    procedures = new HashMap<String, Procedure>();
                }
                procedures.put(procedure.getFullyQualifiedName(), procedure);
            }
        }
        finally {
            rs.close();
        }
        if (procedures == null) {
            return;
        }
        ResultSet columnsRS = this.getMetaData().getProcedureColumns(null, schemaPattern, namePattern, null);
        try {
            while (columnsRS.next()) {
                Procedure procedure;
                String key;
                String schema = columnsRS.getString("PROCEDURE_SCHEM");
                String name = columnsRS.getString("PROCEDURE_NAME");
                if (EXCLUDED_PROCEDURES.contains(name)) continue;
                String columnName = columnsRS.getString("COLUMN_NAME");
                short type = columnsRS.getShort("COLUMN_TYPE");
                String string = key = schema != null ? schema + '.' + name : name;
                if (type == 3) {
                    logObj.debug("skipping ResultSet column: " + key + "." + columnName);
                }
                if ((procedure = (Procedure)procedures.get(key)) == null) {
                    logObj.info("invalid procedure column, no procedure found: " + key + "." + columnName);
                    continue;
                }
                ProcedureParameter column = new ProcedureParameter(columnName);
                if (columnName == null) {
                    if (type == 5) {
                        logObj.debug("null column name, assuming result column: " + key);
                        column.setName("_return_value");
                    } else {
                        logObj.info("invalid null column name, skipping column : " + key);
                        continue;
                    }
                }
                int columnType = columnsRS.getInt("DATA_TYPE");
                int columnSize = columnsRS.getInt("LENGTH");
                int decimalDigits = -1;
                if (TypesMapping.isDecimal(columnType)) {
                    decimalDigits = columnsRS.getShort("SCALE");
                    if (columnsRS.wasNull()) {
                        decimalDigits = -1;
                    }
                }
                switch (type) {
                    case 1: {
                        column.setDirection(1);
                        break;
                    }
                    case 2: {
                        column.setDirection(3);
                        break;
                    }
                    case 4: {
                        column.setDirection(2);
                        break;
                    }
                    case 5: {
                        procedure.setReturningValue(true);
                    }
                }
                column.setMaxLength(columnSize);
                column.setPrecision(decimalDigits);
                column.setProcedure(procedure);
                column.setType(columnType);
                procedure.addCallParameter(column);
            }
        }
        finally {
            columnsRS.close();
        }
        Iterator it = procedures.values().iterator();
        while (it.hasNext()) {
            Procedure procedure = (Procedure)it.next();
            dataMap.addProcedure(procedure);
        }
    }
}

