/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.trans;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.access.trans.LOBBatchQueryBuilder;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.UpdateBatchQuery;

public class LOBUpdateBatchQueryBuilder
extends LOBBatchQueryBuilder {
    public LOBUpdateBatchQueryBuilder(DbAdapter adapter) {
        super(adapter);
    }

    public List getValuesForLOBUpdateParameters(BatchQuery query) {
        int i;
        int len = query.getDbAttributes().size();
        UpdateBatchQuery updateBatch = (UpdateBatchQuery)query;
        ArrayList<Object> values = new ArrayList<Object>(len);
        List qualifierAttributes = updateBatch.getQualifierAttributes();
        List updatedDbAttributes = updateBatch.getUpdatedAttributes();
        int updatedLen = updatedDbAttributes.size();
        int qualifierLen = qualifierAttributes.size();
        for (i = 0; i < updatedLen; ++i) {
            DbAttribute attribute = (DbAttribute)updatedDbAttributes.get(i);
            Object value = query.getValue(i);
            if (!this.isUpdateableColumn(value, attribute.getType())) continue;
            values.add(value);
        }
        for (i = 0; i < qualifierLen; ++i) {
            values.add(query.getValue(updatedLen + i));
        }
        return values;
    }

    public String createSqlString(BatchQuery batch) {
        DbAttribute attribute;
        UpdateBatchQuery updateBatch = (UpdateBatchQuery)batch;
        String table = batch.getDbEntity().getFullyQualifiedName();
        List idDbAttributes = updateBatch.getQualifierAttributes();
        List updatedDbAttributes = updateBatch.getUpdatedAttributes();
        StringBuffer query = new StringBuffer("UPDATE ");
        query.append(table).append(" SET ");
        int len = updatedDbAttributes.size();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                query.append(", ");
            }
            attribute = (DbAttribute)updatedDbAttributes.get(i);
            query.append(attribute.getName()).append(" = ");
            this.appendUpdatedParameter(query, attribute, batch.getValue(i));
        }
        query.append(" WHERE ");
        Iterator i = idDbAttributes.iterator();
        while (i.hasNext()) {
            attribute = (DbAttribute)i.next();
            this.appendDbAttribute(query, attribute);
            query.append(" = ?");
            if (!i.hasNext()) continue;
            query.append(" AND ");
        }
        return query.toString();
    }
}

