/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.cayenne.access.types.AbstractType;

public class ShortType
extends AbstractType {
    protected boolean widenShorts;

    public ShortType(boolean widenShorts) {
        this.widenShorts = widenShorts;
    }

    public String getClassName() {
        return Short.class.getName();
    }

    public Object materializeObject(ResultSet rs, int index, int type) throws Exception {
        short s = rs.getShort(index);
        return rs.wasNull() ? null : new Short(s);
    }

    public Object materializeObject(CallableStatement st, int index, int type) throws Exception {
        short s = st.getShort(index);
        return st.wasNull() ? null : new Short(s);
    }

    public void setJdbcObject(PreparedStatement st, Object val, int pos, int type, int precision) throws Exception {
        if (this.widenShorts && val instanceof Short) {
            val = new Integer(((Short)val).intValue());
        }
        super.setJdbcObject(st, val, pos, type, precision);
    }
}

