/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conf;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.util.Properties;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.util.ResourceLocator;
import org.apache.commons.pool.impl.GenericObjectPool;

class DBCPDataSourceProperties {
    private static final String PROPERTY_PREFIX = "cayenne.dbcp.";
    private Properties properties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(ResourceLocator resourceLocator, String location) throws IOException {
        InputStream in = resourceLocator.findResourceStream(location);
        if (in == null && !location.endsWith(".properties")) {
            in = resourceLocator.findResourceStream(location + ".properties");
        }
        if (in == null) {
            throw new ConfigurationException("DBCP properties file not found: " + location);
        }
        Properties properties = new Properties();
        try {
            properties.load(in);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
        return properties;
    }

    DBCPDataSourceProperties(ResourceLocator resourceLocator, String location) throws IOException {
        this(DBCPDataSourceProperties.loadProperties(resourceLocator, location));
    }

    DBCPDataSourceProperties(Properties properties) {
        this.properties = properties;
    }

    Properties getProperties() {
        return this.properties;
    }

    String getString(String property, boolean required) {
        String value = this.properties.getProperty(PROPERTY_PREFIX + property);
        if (required && value == null) {
            throw new ConfigurationException("No value for required property: cayenne.dbcp." + property);
        }
        return value;
    }

    String getString(String property) {
        return this.getString(property, false);
    }

    boolean getBoolean(String property, boolean defaultValue) {
        String value = this.getString(property);
        return value != null ? "true".equalsIgnoreCase(this.getString(property)) : defaultValue;
    }

    int getInt(String property, int defaultValue) {
        String value = this.getString(property);
        try {
            return value != null ? Integer.parseInt(value) : defaultValue;
        }
        catch (NumberFormatException nfex) {
            return defaultValue;
        }
    }

    long getLong(String property, long defaultValue) {
        String value = this.getString(property);
        try {
            return value != null ? Long.parseLong(value) : defaultValue;
        }
        catch (NumberFormatException nfex) {
            return defaultValue;
        }
    }

    byte getByte(String property, byte defaultValue) {
        String value = this.getString(property);
        try {
            return value != null ? Byte.parseByte(value) : defaultValue;
        }
        catch (NumberFormatException nfex) {
            return defaultValue;
        }
    }

    byte getWhenExhaustedAction(String property, byte defaultValue) throws ConfigurationException {
        String value = this.getString(property);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Byte.parseByte(value);
        }
        catch (NumberFormatException nfex) {
            try {
                return GenericObjectPool.class.getField(value).getByte(null);
            }
            catch (Throwable th) {
                throw new ConfigurationException("Invalid 'whenExhaustedAction': " + value);
            }
        }
    }

    int getTransactionIsolation(String property, int defaultValue) {
        String value = this.getString(property);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfex) {
            try {
                return Connection.class.getField(value).getInt(null);
            }
            catch (Throwable th) {
                throw new ConfigurationException("Invalid 'defaultTransactionIsolation': " + value);
            }
        }
    }
}

